/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.runtime.variable;

import org.activiti.app.model.runtime.RestVariable;
import org.activiti.app.rest.runtime.variable.RestVariableConverter;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.springframework.stereotype.Component;

@Component
public class StringRestVariableConverter
implements RestVariableConverter {
    @Override
    public String getRestTypeName() {
        return "string";
    }

    @Override
    public Class<?> getVariableType() {
        return String.class;
    }

    @Override
    public Object getVariableValue(RestVariable result) {
        if (result.getValue() != null) {
            if (!(result.getValue() instanceof String)) {
                throw new ActivitiIllegalArgumentException("Converter can only convert strings");
            }
            return (String)result.getValue();
        }
        return null;
    }

    @Override
    public void convertVariableValue(Object variableValue, RestVariable result) {
        if (variableValue != null) {
            if (!(variableValue instanceof String)) {
                throw new ActivitiIllegalArgumentException("Converter can only convert strings");
            }
            result.setValue(variableValue);
        } else {
            result.setValue(null);
        }
    }
}

