/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.export;

import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Message;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.Signal;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.apache.commons.lang3.StringUtils;

public class SignalAndMessageDefinitionExport
implements BpmnXMLConstants {
    public static void writeSignalsAndMessages(BpmnModel model, XMLStreamWriter xtw) throws Exception {
        for (Process process : model.getProcesses()) {
            for (FlowElement flowElement : process.findFlowElementsOfType(Event.class)) {
                MessageEventDefinition messageEvent;
                Event event = (Event)flowElement;
                if (event.getEventDefinitions().isEmpty()) continue;
                EventDefinition eventDefinition = (EventDefinition)event.getEventDefinitions().get(0);
                if (eventDefinition instanceof SignalEventDefinition) {
                    SignalEventDefinition signalEvent = (SignalEventDefinition)eventDefinition;
                    if (model.containsSignalId(signalEvent.getSignalRef())) continue;
                    Signal signal = new Signal(signalEvent.getSignalRef(), signalEvent.getSignalRef());
                    model.addSignal(signal);
                    continue;
                }
                if (!(eventDefinition instanceof MessageEventDefinition) || model.containsMessageId((messageEvent = (MessageEventDefinition)eventDefinition).getMessageRef())) continue;
                Message message = new Message(messageEvent.getMessageRef(), messageEvent.getMessageRef(), null);
                model.addMessage(message);
            }
        }
        for (Signal signal : model.getSignals()) {
            xtw.writeStartElement("signal");
            xtw.writeAttribute("id", signal.getId());
            xtw.writeAttribute("name", signal.getName());
            if (signal.getScope() != null) {
                xtw.writeAttribute("http://activiti.org/bpmn", "scope", signal.getScope());
            }
            xtw.writeEndElement();
        }
        for (Message message : model.getMessages()) {
            xtw.writeStartElement("message");
            String messageId = message.getId();
            if (model.getTargetNamespace() != null && messageId.startsWith(model.getTargetNamespace())) {
                messageId = messageId.replace(model.getTargetNamespace(), "");
                messageId = messageId.replaceFirst(":", "");
            } else {
                for (String prefix : model.getNamespaces().keySet()) {
                    String namespace = model.getNamespace(prefix);
                    if (!messageId.startsWith(namespace)) continue;
                    messageId = messageId.replace(model.getTargetNamespace(), "");
                    messageId = prefix + messageId;
                }
            }
            xtw.writeAttribute("id", messageId);
            if (StringUtils.isNotEmpty((CharSequence)message.getName())) {
                xtw.writeAttribute("name", message.getName());
            }
            if (StringUtils.isNotEmpty((CharSequence)message.getItemRef())) {
                String itemRef = message.getItemRef();
                for (String prefix : model.getNamespaces().keySet()) {
                    String namespace = model.getNamespace(prefix);
                    if (!itemRef.startsWith(namespace)) continue;
                    if (prefix.isEmpty()) {
                        itemRef = itemRef.replace(namespace + ":", "");
                        break;
                    }
                    itemRef = itemRef.replace(namespace, prefix);
                    break;
                }
                xtw.writeAttribute("itemRef", itemRef);
            }
            xtw.writeEndElement();
        }
    }
}

