/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.parser;

import java.util.List;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.EventSubProcess;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.Transaction;
import org.apache.commons.lang3.StringUtils;

public class SubProcessParser
implements BpmnXMLConstants {
    public void parse(XMLStreamReader xtr, List<SubProcess> activeSubProcessList, Process activeProcess) {
        Object subProcess = null;
        subProcess = "transaction".equalsIgnoreCase(xtr.getLocalName()) ? new Transaction() : ("true".equalsIgnoreCase(xtr.getAttributeValue(null, "triggeredByEvent")) ? new EventSubProcess() : new SubProcess());
        BpmnXMLUtil.addXMLLocation((BaseElement)subProcess, xtr);
        activeSubProcessList.add((SubProcess)subProcess);
        subProcess.setId(xtr.getAttributeValue(null, "id"));
        subProcess.setName(xtr.getAttributeValue(null, "name"));
        boolean async = false;
        String asyncString = xtr.getAttributeValue("http://activiti.org/bpmn", "async");
        if ("true".equalsIgnoreCase(asyncString)) {
            async = true;
        }
        boolean notExclusive = false;
        String exclusiveString = xtr.getAttributeValue("http://activiti.org/bpmn", "exclusive");
        if ("false".equalsIgnoreCase(exclusiveString)) {
            notExclusive = true;
        }
        boolean forCompensation = false;
        String compensationString = xtr.getAttributeValue(null, "isForCompensation");
        if ("true".equalsIgnoreCase(compensationString)) {
            forCompensation = true;
        }
        subProcess.setAsynchronous(async);
        subProcess.setNotExclusive(notExclusive);
        subProcess.setForCompensation(forCompensation);
        if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "default"))) {
            subProcess.setDefaultFlow(xtr.getAttributeValue(null, "default"));
        }
        if (activeSubProcessList.size() > 1) {
            SubProcess parentSubProcess = activeSubProcessList.get(activeSubProcessList.size() - 2);
            parentSubProcess.addFlowElement((FlowElement)subProcess);
            subProcess.setSubProcess(parentSubProcess);
        } else {
            activeProcess.addFlowElement((FlowElement)subProcess);
        }
    }
}

