/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.child.multi.instance;

import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.child.BaseChildElementParser;
import org.activiti.bpmn.converter.child.ElementParser;
import org.activiti.bpmn.converter.child.multi.instance.LoopCardinalityParser;
import org.activiti.bpmn.converter.child.multi.instance.LoopDataOutputRefParser;
import org.activiti.bpmn.converter.child.multi.instance.MultiInstanceAttributesParser;
import org.activiti.bpmn.converter.child.multi.instance.MultiInstanceCompletionConditionParser;
import org.activiti.bpmn.converter.child.multi.instance.MultiInstanceDataInputParser;
import org.activiti.bpmn.converter.child.multi.instance.MultiInstanceInputDataItemParser;
import org.activiti.bpmn.converter.child.multi.instance.MultiInstanceOutputDataItemParser;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;

public class MultiInstanceParser
extends BaseChildElementParser {
    private final List<ElementParser<MultiInstanceLoopCharacteristics>> multiInstanceElementParsers;

    public MultiInstanceParser() {
        this(Arrays.asList(new LoopCardinalityParser(), new MultiInstanceDataInputParser(), new MultiInstanceInputDataItemParser(), new MultiInstanceCompletionConditionParser(), new LoopDataOutputRefParser(), new MultiInstanceOutputDataItemParser(), new MultiInstanceAttributesParser()));
    }

    public MultiInstanceParser(List<ElementParser<MultiInstanceLoopCharacteristics>> multiInstanceElementParsers) {
        this.multiInstanceElementParsers = multiInstanceElementParsers;
    }

    @Override
    public String getElementName() {
        return "multiInstanceLoopCharacteristics";
    }

    @Override
    public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
        if (!(parentElement instanceof Activity)) {
            return;
        }
        MultiInstanceLoopCharacteristics multiInstanceDef = new MultiInstanceLoopCharacteristics();
        BpmnXMLUtil.addXMLLocation((BaseElement)multiInstanceDef, xtr);
        this.parseMultiInstanceProperties(xtr, multiInstanceDef);
        ((Activity)parentElement).setLoopCharacteristics(multiInstanceDef);
    }

    private void parseMultiInstanceProperties(XMLStreamReader xtr, MultiInstanceLoopCharacteristics multiInstanceDef) {
        boolean readyWithMultiInstance = false;
        try {
            do {
                ElementParser matchingParser;
                if ((matchingParser = (ElementParser)this.multiInstanceElementParsers.stream().filter(elementParser -> elementParser.canParseCurrentElement(xtr)).findFirst().orElse(null)) != null) {
                    matchingParser.setInformation(xtr, multiInstanceDef);
                }
                if (xtr.isEndElement() && this.getElementName().equalsIgnoreCase(xtr.getLocalName())) {
                    readyWithMultiInstance = true;
                }
                if (!xtr.hasNext()) continue;
                xtr.next();
            } while (!readyWithMultiInstance && xtr.hasNext());
        }
        catch (Exception e) {
            LOGGER.warn("Error parsing multi instance definition", (Throwable)e);
        }
    }
}

