/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.export;

import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.apache.commons.lang3.StringUtils;

public class MultiInstanceExport
implements BpmnXMLConstants {
    public static void writeMultiInstance(Activity activity, XMLStreamWriter xtw) throws Exception {
        MultiInstanceLoopCharacteristics multiInstanceObject;
        if (activity.getLoopCharacteristics() != null && MultiInstanceExport.hasMultiInstanceElements(multiInstanceObject = activity.getLoopCharacteristics())) {
            xtw.writeStartElement("multiInstanceLoopCharacteristics");
            BpmnXMLUtil.writeDefaultAttribute("isSequential", String.valueOf(multiInstanceObject.isSequential()).toLowerCase(), xtw);
            if (StringUtils.isNotEmpty((CharSequence)multiInstanceObject.getInputDataItem())) {
                BpmnXMLUtil.writeQualifiedAttribute("collection", multiInstanceObject.getInputDataItem(), xtw);
            }
            if (StringUtils.isNotEmpty((CharSequence)multiInstanceObject.getElementVariable())) {
                BpmnXMLUtil.writeQualifiedAttribute("elementVariable", multiInstanceObject.getElementVariable(), xtw);
            }
            if (StringUtils.isNotEmpty((CharSequence)multiInstanceObject.getLoopCardinality())) {
                xtw.writeStartElement("loopCardinality");
                xtw.writeCharacters(multiInstanceObject.getLoopCardinality());
                xtw.writeEndElement();
            }
            if (StringUtils.isNotEmpty((CharSequence)multiInstanceObject.getLoopDataOutputRef())) {
                xtw.writeStartElement("loopDataOutputRef");
                xtw.writeCharacters(multiInstanceObject.getLoopDataOutputRef());
                xtw.writeEndElement();
            }
            if (StringUtils.isNotEmpty((CharSequence)multiInstanceObject.getOutputDataItem())) {
                xtw.writeStartElement("outputDataItem");
                xtw.writeAttribute("name", multiInstanceObject.getOutputDataItem());
                xtw.writeEndElement();
            }
            if (StringUtils.isNotEmpty((CharSequence)multiInstanceObject.getCompletionCondition())) {
                xtw.writeStartElement("completionCondition");
                xtw.writeCharacters(multiInstanceObject.getCompletionCondition());
                xtw.writeEndElement();
            }
            xtw.writeEndElement();
        }
    }

    private static boolean hasMultiInstanceElements(MultiInstanceLoopCharacteristics multiInstanceObject) {
        return StringUtils.isNotEmpty((CharSequence)multiInstanceObject.getLoopCardinality()) || StringUtils.isNotEmpty((CharSequence)multiInstanceObject.getInputDataItem()) || StringUtils.isNotEmpty((CharSequence)multiInstanceObject.getCompletionCondition()) || StringUtils.isNotEmpty((CharSequence)multiInstanceObject.getLoopDataOutputRef()) || StringUtils.isNotEmpty((CharSequence)multiInstanceObject.getOutputDataItem());
    }
}

