/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.camel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.MapExceptionEntry;
import org.activiti.camel.ActivitiEndpoint;
import org.activiti.camel.ExchangeUtils;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.pvm.PvmProcessDefinition;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.spring.SpringProcessEngineConfiguration;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.commons.lang3.StringUtils;

public abstract class CamelBehavior
extends AbstractBpmnActivityBehavior
implements ActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected Expression camelContext;
    protected CamelContext camelContextObj;
    protected SpringProcessEngineConfiguration springConfiguration;
    protected List<MapExceptionEntry> mapExceptions;
    protected TargetType toTargetType = null;

    protected abstract void setPropertTargetVariable(ActivitiEndpoint var1);

    protected void updateTargetVariables(ActivitiEndpoint endpoint) {
        this.toTargetType = null;
        if (endpoint.isCopyVariablesToBodyAsMap()) {
            this.toTargetType = TargetType.BODY_AS_MAP;
        } else if (endpoint.isCopyCamelBodyToBody()) {
            this.toTargetType = TargetType.BODY;
        } else if (endpoint.isCopyVariablesToProperties()) {
            this.toTargetType = TargetType.PROPERTIES;
        }
        if (this.toTargetType == null) {
            this.setPropertTargetVariable(endpoint);
        }
    }

    protected void copyVariables(Map<String, Object> variables, Exchange exchange, ActivitiEndpoint endpoint) {
        switch (this.toTargetType) {
            case BODY_AS_MAP: {
                this.copyVariablesToBodyAsMap(variables, exchange);
                break;
            }
            case BODY: {
                this.copyVariablesToBody(variables, exchange);
                break;
            }
            case PROPERTIES: {
                this.copyVariablesToProperties(variables, exchange);
            }
        }
    }

    public void execute(ActivityExecution execution) throws Exception {
        this.setAppropriateCamelContext(execution);
        ActivitiEndpoint endpoint = this.createEndpoint(execution);
        Exchange exchange = this.createExchange(execution, endpoint);
        endpoint.process(exchange);
        execution.setVariables(ExchangeUtils.prepareVariables(exchange, endpoint));
        if (!this.handleCamelException(exchange, execution)) {
            this.leave(execution);
        }
    }

    protected ActivitiEndpoint createEndpoint(ActivityExecution execution) {
        String uri = "activiti://" + this.getProcessDefinitionKey(execution) + ":" + execution.getActivity().getId();
        return this.getEndpoint(uri);
    }

    protected ActivitiEndpoint getEndpoint(String key) {
        for (Endpoint e : this.camelContextObj.getEndpoints()) {
            if (!e.getEndpointKey().equals(key) || !(e instanceof ActivitiEndpoint)) continue;
            return (ActivitiEndpoint)e;
        }
        throw new ActivitiException("Activiti endpoint not defined for " + key);
    }

    protected Exchange createExchange(ActivityExecution activityExecution, ActivitiEndpoint endpoint) {
        Exchange ex = endpoint.createExchange();
        ex.setProperty("PROCESS_ID_PROPERTY", (Object)activityExecution.getProcessInstanceId());
        ex.setProperty("EXECUTION_ID_PROPERTY", (Object)activityExecution.getId());
        Map variables = activityExecution.getVariables();
        this.updateTargetVariables(endpoint);
        this.copyVariables(variables, ex, endpoint);
        return ex;
    }

    protected boolean handleCamelException(Exchange exchange, ActivityExecution execution) throws Exception {
        boolean notHandledByCamel;
        Exception camelException = exchange.getException();
        boolean bl = notHandledByCamel = exchange.isFailed() && camelException != null;
        if (notHandledByCamel) {
            if (camelException instanceof BpmnError) {
                ErrorPropagation.propagateError((BpmnError)((BpmnError)camelException), (ActivityExecution)execution);
                return true;
            }
            if (ErrorPropagation.mapException((Exception)camelException, (ActivityExecution)execution, this.mapExceptions)) {
                return true;
            }
            throw new ActivitiException("Unhandled exception on camel route", (Throwable)camelException);
        }
        return false;
    }

    protected void copyVariablesToProperties(Map<String, Object> variables, Exchange exchange) {
        for (Map.Entry<String, Object> var : variables.entrySet()) {
            exchange.setProperty(var.getKey(), var.getValue());
        }
    }

    protected void copyVariablesToBodyAsMap(Map<String, Object> variables, Exchange exchange) {
        exchange.getIn().setBody(new HashMap<String, Object>(variables));
    }

    protected void copyVariablesToBody(Map<String, Object> variables, Exchange exchange) {
        Object camelBody = variables.get("camelBody");
        if (camelBody != null) {
            exchange.getIn().setBody(camelBody);
        }
    }

    protected String getProcessDefinitionKey(ActivityExecution execution) {
        PvmProcessDefinition processDefinition = execution.getActivity().getProcessDefinition();
        return processDefinition.getKey();
    }

    protected boolean isASync(ActivityExecution execution) {
        return execution.getActivity().isAsync();
    }

    protected void setAppropriateCamelContext(ActivityExecution execution) {
        String camelContextValue;
        if (this.springConfiguration == null) {
            ProcessEngineConfigurationImpl engineConfiguration = Context.getProcessEngineConfiguration();
            try {
                this.springConfiguration = (SpringProcessEngineConfiguration)engineConfiguration;
            }
            catch (Exception e) {
                throw new ActivitiException("Expecting a SpringProcessEngineConfiguration for the Activiti Camel module.", (Throwable)e);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)(camelContextValue = this.getStringFromField(this.camelContext, (DelegateExecution)execution))) || this.camelContextObj == null) {
            Object ctx;
            if (StringUtils.isEmpty((CharSequence)camelContextValue) && this.camelContextObj == null) {
                camelContextValue = this.springConfiguration.getDefaultCamelContext();
            }
            if ((ctx = this.springConfiguration.getApplicationContext().getBean(camelContextValue)) == null || !(ctx instanceof CamelContext)) {
                throw new ActivitiException("Could not find CamelContext named " + camelContextValue + ".");
            }
            this.camelContextObj = (CamelContext)ctx;
        }
    }

    protected String getStringFromField(Expression expression, DelegateExecution execution) {
        Object value;
        if (expression != null && (value = expression.getValue((VariableScope)execution)) != null) {
            return value.toString();
        }
        return null;
    }

    public void setCamelContext(Expression camelContext) {
        this.camelContext = camelContext;
    }

    public static enum TargetType {
        BODY_AS_MAP,
        BODY,
        PROPERTIES;

    }
}

