/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cdi.impl.event;

import java.util.HashSet;
import java.util.Set;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BusinessRuleTask;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.EventGateway;
import org.activiti.bpmn.model.EventSubProcess;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.InclusiveGateway;
import org.activiti.bpmn.model.ManualTask;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.ReceiveTask;
import org.activiti.bpmn.model.ScriptTask;
import org.activiti.bpmn.model.SendTask;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.Task;
import org.activiti.bpmn.model.ThrowEvent;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.bpmn.model.Transaction;
import org.activiti.bpmn.model.UserTask;
import org.activiti.cdi.BusinessProcessEventType;
import org.activiti.cdi.impl.event.CdiExecutionListener;
import org.activiti.cdi.impl.event.CdiTaskListener;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.parse.BpmnParseHandler;

public class CdiEventSupportBpmnParseHandler
implements BpmnParseHandler {
    protected static final Set<Class<? extends BaseElement>> supportedTypes = new HashSet<Class<? extends BaseElement>>();

    public Set<Class<? extends BaseElement>> getHandledTypes() {
        return supportedTypes;
    }

    public void parse(BpmnParse bpmnParse, BaseElement element) {
        if (element instanceof SequenceFlow) {
            TransitionImpl transition = (TransitionImpl)bpmnParse.getSequenceFlows().get(element.getId());
            transition.addExecutionListener((ExecutionListener)new CdiExecutionListener(transition.getId()));
        } else {
            ActivityImpl activity = bpmnParse.getCurrentScope().findActivity(element.getId());
            if (element instanceof UserTask) {
                this.addCreateListener(activity);
                this.addAssignListener(activity);
                this.addCompleteListener(activity);
            }
            if (activity != null) {
                this.addStartEventListener(activity);
                this.addEndEventListener(activity);
            }
        }
    }

    private void addCompleteListener(ActivityImpl activity) {
        UserTaskActivityBehavior behavior = (UserTaskActivityBehavior)activity.getActivityBehavior();
        behavior.getTaskDefinition().addTaskListener("complete", (TaskListener)new CdiTaskListener(activity.getId(), BusinessProcessEventType.COMPLETE_TASK));
    }

    private void addAssignListener(ActivityImpl activity) {
        UserTaskActivityBehavior behavior = (UserTaskActivityBehavior)activity.getActivityBehavior();
        behavior.getTaskDefinition().addTaskListener("assignment", (TaskListener)new CdiTaskListener(activity.getId(), BusinessProcessEventType.ASSIGN_TASK));
    }

    private void addCreateListener(ActivityImpl activity) {
        UserTaskActivityBehavior behavior = (UserTaskActivityBehavior)activity.getActivityBehavior();
        behavior.getTaskDefinition().addTaskListener("create", (TaskListener)new CdiTaskListener(activity.getId(), BusinessProcessEventType.CREATE_TASK));
    }

    protected void addEndEventListener(ActivityImpl activity) {
        activity.addExecutionListener("end", (ExecutionListener)new CdiExecutionListener(activity.getId(), BusinessProcessEventType.END_ACTIVITY));
    }

    protected void addStartEventListener(ActivityImpl activity) {
        activity.addExecutionListener("start", (ExecutionListener)new CdiExecutionListener(activity.getId(), BusinessProcessEventType.START_ACTIVITY));
    }

    static {
        supportedTypes.add(StartEvent.class);
        supportedTypes.add(EndEvent.class);
        supportedTypes.add(ExclusiveGateway.class);
        supportedTypes.add(InclusiveGateway.class);
        supportedTypes.add(ParallelGateway.class);
        supportedTypes.add(ScriptTask.class);
        supportedTypes.add(ServiceTask.class);
        supportedTypes.add(BusinessRuleTask.class);
        supportedTypes.add(Task.class);
        supportedTypes.add(ManualTask.class);
        supportedTypes.add(UserTask.class);
        supportedTypes.add(EndEvent.class);
        supportedTypes.add(SubProcess.class);
        supportedTypes.add(EventSubProcess.class);
        supportedTypes.add(CallActivity.class);
        supportedTypes.add(SendTask.class);
        supportedTypes.add(ReceiveTask.class);
        supportedTypes.add(EventGateway.class);
        supportedTypes.add(Transaction.class);
        supportedTypes.add(ThrowEvent.class);
        supportedTypes.add(TimerEventDefinition.class);
        supportedTypes.add(ErrorEventDefinition.class);
        supportedTypes.add(SignalEventDefinition.class);
        supportedTypes.add(SequenceFlow.class);
    }
}

