/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cdi.impl.event;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Date;
import javax.enterprise.inject.spi.BeanManager;
import org.activiti.cdi.BusinessProcessEvent;
import org.activiti.cdi.BusinessProcessEventType;
import org.activiti.cdi.annotation.event.AssignTaskLiteral;
import org.activiti.cdi.annotation.event.BusinessProcessLiteral;
import org.activiti.cdi.annotation.event.CompleteTaskLiteral;
import org.activiti.cdi.annotation.event.CreateTaskLiteral;
import org.activiti.cdi.impl.event.CdiBusinessProcessEvent;
import org.activiti.cdi.impl.util.BeanManagerLookup;
import org.activiti.cdi.impl.util.ProgrammaticBeanLookup;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.repository.ProcessDefinition;

public class CdiTaskListener
implements TaskListener,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final BusinessProcessEventType type;
    protected final String transitionName;
    protected final String activityId;

    public CdiTaskListener(String transitionName) {
        this.type = BusinessProcessEventType.TAKE;
        this.transitionName = transitionName;
        this.activityId = null;
    }

    public CdiTaskListener(String activityId, BusinessProcessEventType type) {
        this.type = type;
        this.transitionName = null;
        this.activityId = activityId;
    }

    public void notify(DelegateTask task) {
        try {
            ProgrammaticBeanLookup.lookup(ProcessEngine.class);
        }
        catch (Exception e) {
            return;
        }
        BusinessProcessEvent event = this.createEvent(task);
        Annotation[] qualifiers = this.getQualifiers(event);
        this.getBeanManager().fireEvent((Object)event, qualifiers);
    }

    protected BusinessProcessEvent createEvent(DelegateTask task) {
        String processDefinitionId = task.getExecution().getProcessDefinitionId();
        ProcessDefinition processDefinition = task.getExecution().getEngineServices().getRepositoryService().getProcessDefinition(processDefinitionId);
        return new CdiBusinessProcessEvent(this.activityId, this.transitionName, processDefinition, (VariableScope)task, this.type, task.getExecution().getProcessInstanceId(), task.getExecutionId(), new Date());
    }

    protected BeanManager getBeanManager() {
        BeanManager bm = BeanManagerLookup.getBeanManager();
        if (bm == null) {
            throw new ActivitiException("No cdi bean manager avaiable, cannot publish event.");
        }
        return bm;
    }

    protected Annotation[] getQualifiers(BusinessProcessEvent event) {
        BusinessProcessLiteral businessProcessQualifier = new BusinessProcessLiteral(event.getProcessDefinition().getKey());
        if (this.type == BusinessProcessEventType.CREATE_TASK) {
            return new Annotation[]{businessProcessQualifier, new CreateTaskLiteral(this.activityId)};
        }
        if (this.type == BusinessProcessEventType.ASSIGN_TASK) {
            return new Annotation[]{businessProcessQualifier, new AssignTaskLiteral(this.activityId)};
        }
        if (this.type == BusinessProcessEventType.COMPLETE_TASK) {
            return new Annotation[]{businessProcessQualifier, new CompleteTaskLiteral(this.activityId)};
        }
        return new Annotation[0];
    }
}

