/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cdi.impl.util;

import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.activiti.engine.ActivitiException;

public class BeanManagerLookup {
    public static BeanManager localInstance;
    public static String jndiName;

    public static BeanManager getBeanManager() {
        if (localInstance != null) {
            return localInstance;
        }
        return BeanManagerLookup.lookupBeanManagerInJndi();
    }

    private static BeanManager lookupBeanManagerInJndi() {
        if (jndiName != null) {
            try {
                return (BeanManager)InitialContext.doLookup(jndiName);
            }
            catch (NamingException e) {
                throw new ActivitiException("Could not lookup beanmanager in jndi using name: '" + jndiName + "'.", (Throwable)e);
            }
        }
        try {
            return (BeanManager)InitialContext.doLookup("java:comp/BeanManager");
        }
        catch (NamingException e) {
            try {
                return (BeanManager)InitialContext.doLookup("java:comp/env/BeanManager");
            }
            catch (NamingException namingException) {
                throw new ActivitiException("Could not lookup beanmanager in jndi. If no jndi is avalable, set the beanmanger to the 'localInstance' property of this class.");
            }
        }
    }
}

