/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cdi.impl;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.DeploymentBuilder;
import org.activiti.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProcessDeployer {
    public static final String PROCESSES_FILE_NAME = "processes.xml";
    public static final String PROCESS_ELEMENT_NAME = "process";
    public static final String PROCESS_ATTR_RESOURCE = "resource";
    private static Logger logger = LoggerFactory.getLogger(ProcessDeployer.class);
    protected final ProcessEngine processEngine;

    public ProcessDeployer(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    public String deployProcess(String resourceName) {
        logger.debug("Start deploying single process.");
        DeploymentBuilder deploymentBuilder = this.processEngine.getRepositoryService().createDeployment();
        deploymentBuilder.addClasspathResource(resourceName);
        Deployment deployment = deploymentBuilder.deploy();
        logger.debug("Process deployed");
        return ((ProcessDefinition)this.processEngine.getRepositoryService().createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult()).getId();
    }

    public void deployProcesses() {
        Set<String> resourceNames = this.getResourceNames();
        if (resourceNames.isEmpty()) {
            logger.debug("Not creating a deployment");
            return;
        }
        logger.debug("Start deploying processes.");
        DeploymentBuilder deploymentBuilder = this.processEngine.getRepositoryService().createDeployment();
        for (String string : resourceNames) {
            logger.info("Adding '" + string + "' to deployment.");
            deploymentBuilder.addClasspathResource(string);
        }
        deploymentBuilder.deploy();
        logger.debug("Done deploying processes.");
    }

    public Set<String> getResourceNames() {
        HashSet<String> result = new HashSet<String>();
        URL processFileUrl = this.getClass().getClassLoader().getResource(PROCESSES_FILE_NAME);
        if (processFileUrl == null) {
            logger.debug("No '{}'-file provided.", (Object)PROCESSES_FILE_NAME);
            return result;
        }
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(processFileUrl.openStream());
            NodeList nodeList = document.getElementsByTagName(PROCESS_ELEMENT_NAME);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element ce;
                String resourceName;
                Node cn = nodeList.item(i);
                if (!(cn instanceof Element) || (resourceName = (ce = (Element)cn).getAttribute(PROCESS_ATTR_RESOURCE)) == null || resourceName.length() == 0) continue;
                result.add(resourceName);
            }
        }
        catch (Exception e) {
            logger.error("could not parse file '{}'. {}", new Object[]{PROCESSES_FILE_NAME, e.getMessage(), e});
        }
        return result;
    }
}

