/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cdi.impl.annotation;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.activiti.cdi.BusinessProcess;
import org.activiti.cdi.annotation.ProcessVariable;
import org.activiti.cdi.annotation.StartProcess;
import org.activiti.engine.ActivitiException;

@Interceptor
@StartProcess(value="")
public class StartProcessInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    BusinessProcess businessProcess;

    @AroundInvoke
    public Object invoke(InvocationContext ctx) throws Exception {
        try {
            Object result = ctx.proceed();
            StartProcess startProcessAnnotation = ctx.getMethod().getAnnotation(StartProcess.class);
            String name = startProcessAnnotation.name();
            String key = startProcessAnnotation.value();
            Map<String, Object> variables = this.extractVariables(startProcessAnnotation, ctx);
            if (name.length() > 0) {
                this.businessProcess.startProcessByName(name, variables);
            } else {
                this.businessProcess.startProcessByKey(key, variables);
            }
            return result;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw e;
        }
        catch (Exception e) {
            throw new ActivitiException("Error while starting process using @StartProcess on method  '" + ctx.getMethod() + "': " + e.getMessage(), (Throwable)e);
        }
    }

    private Map<String, Object> extractVariables(StartProcess startProcessAnnotation, InvocationContext ctx) throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        for (Field field : ctx.getMethod().getDeclaringClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(ProcessVariable.class)) continue;
            field.setAccessible(true);
            ProcessVariable processStartVariable = field.getAnnotation(ProcessVariable.class);
            String fieldName = processStartVariable.value();
            if (fieldName == null || fieldName.length() == 0) {
                fieldName = field.getName();
            }
            Object value = field.get(ctx.getTarget());
            variables.put(fieldName, value);
        }
        return variables;
    }
}

