/*
 * Decompiled with CFR 0.152.
 */
package org.conf.activiti.runtime;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleAbstractTypeResolver;
import com.fasterxml.jackson.databind.module.SimpleModule;
import org.activiti.runtime.api.event.CloudRuntimeEvent;
import org.activiti.runtime.api.event.VariableEvent;
import org.activiti.runtime.api.event.impl.CloudVariableCreatedEventImpl;
import org.activiti.runtime.api.event.impl.CloudVariableDeletedEventImpl;
import org.activiti.runtime.api.event.impl.CloudVariableUpdatedEventImpl;
import org.activiti.runtime.api.model.CloudVariableInstance;
import org.activiti.runtime.api.model.impl.CloudVariableInstanceImpl;
import org.conf.activiti.runtime.CloudRuntimeMixIn;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CloudCommonModelAutoConfiguration {
    @Bean
    public Module customizeCloudCommonModelObjectMapper() {
        SimpleModule module = new SimpleModule("mapMixCloudRuntimeEvents", Version.unknownVersion());
        module.registerSubtypes(new NamedType[]{new NamedType(CloudVariableCreatedEventImpl.class, VariableEvent.VariableEvents.VARIABLE_CREATED.name())});
        module.registerSubtypes(new NamedType[]{new NamedType(CloudVariableUpdatedEventImpl.class, VariableEvent.VariableEvents.VARIABLE_UPDATED.name())});
        module.registerSubtypes(new NamedType[]{new NamedType(CloudVariableDeletedEventImpl.class, VariableEvent.VariableEvents.VARIABLE_DELETED.name())});
        SimpleAbstractTypeResolver resolver = new SimpleAbstractTypeResolver(){

            public JavaType resolveAbstractType(DeserializationConfig config, BeanDescription typeDesc) {
                return this.findTypeMapping(config, typeDesc.getType());
            }
        };
        resolver.addMapping(CloudVariableInstance.class, CloudVariableInstanceImpl.class);
        module.setAbstractTypes(resolver);
        module.setMixInAnnotation(CloudRuntimeEvent.class, CloudRuntimeMixIn.class);
        return module;
    }
}

