/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.crystalball.simulator;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.activiti.crystalball.simulator.EventCalendar;
import org.activiti.crystalball.simulator.SimulationDebugger;
import org.activiti.crystalball.simulator.SimulationEvent;
import org.activiti.crystalball.simulator.SimulationEventHandler;
import org.activiti.crystalball.simulator.SimulationRun;
import org.activiti.crystalball.simulator.SimulationRunContext;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.delegate.VariableScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSimulationRun
implements SimulationRun,
SimulationDebugger {
    private static Logger log = LoggerFactory.getLogger(AbstractSimulationRun.class);
    protected String id;
    protected Map<String, SimulationEventHandler> eventHandlerMap = new HashMap<String, SimulationEventHandler>();
    protected ProcessEngine processEngine;

    public AbstractSimulationRun(Map<String, SimulationEventHandler> eventHandlers) {
        if (eventHandlers != null && !eventHandlers.isEmpty()) {
            this.eventHandlerMap.putAll(eventHandlers);
        }
    }

    @Override
    public void execute(VariableScope execution) throws Exception {
        this.init(execution);
        this.runContinue();
        this.close();
    }

    protected SimulationEvent removeSimulationEvent() {
        SimulationEvent event = SimulationRunContext.getEventCalendar().removeFirstEvent();
        if (event != null && event.hasSimulationTime()) {
            this.processEngine.getProcessEngineConfiguration().getClock().setCurrentTime(new Date(event.getSimulationTime()));
        }
        return event;
    }

    @Override
    public void init(VariableScope execution) {
        this.initSimulationRunContext(execution);
        this.initHandlers();
    }

    @Override
    public void step() {
        SimulationEvent event = this.removeSimulationEvent();
        if (!this.simulationEnd(event)) {
            log.debug("executing simulation event {}", (Object)event);
            this.executeEvent(event);
            log.debug("simulation event {event} execution done", (Object)event);
        } else {
            log.info("Simulation run has ended.");
        }
    }

    @Override
    public void runContinue() {
        SimulationEvent event = this.removeSimulationEvent();
        while (!this.simulationEnd(event)) {
            this.executeEvent(event);
            event = this.removeSimulationEvent();
        }
    }

    @Override
    public void runTo(long simulationTime) {
        SimulationEvent breakEvent = new SimulationEvent.Builder("BREAK").simulationTime(simulationTime).priority(-1).build();
        EventCalendar calendar = SimulationRunContext.getEventCalendar();
        calendar.addEvent(breakEvent);
        this.runContinue();
    }

    @Override
    public void runTo(String simulationEventType) {
        EventCalendar eventCalendar = SimulationRunContext.getEventCalendar();
        SimulationEvent event = eventCalendar.peekFirstEvent();
        while (!simulationEventType.equals(event.getType()) && !this.simulationEnd(event)) {
            this.step();
            event = eventCalendar.peekFirstEvent();
        }
    }

    @Override
    public abstract void close();

    protected abstract void initSimulationRunContext(VariableScope var1);

    protected void initHandlers() {
        for (SimulationEventHandler handler : this.eventHandlerMap.values()) {
            handler.init();
        }
    }

    protected abstract boolean simulationEnd(SimulationEvent var1);

    protected void executeEvent(SimulationEvent event) {
        log.debug("Simulation time:" + this.processEngine.getProcessEngineConfiguration().getClock().getCurrentTime());
        SimulationEventHandler handler = this.eventHandlerMap.get(event.getType());
        if (handler != null) {
            log.debug("Handling event of type[{}]", (Object)event.getType());
            handler.handle(event);
        } else {
            log.warn("Event type[{}] does not have any handler assigned.", (Object)event.getType());
        }
    }
}

