/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.engine;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.activiti.dmn.api.DmnRepositoryService;
import org.activiti.dmn.api.DmnRuleService;
import org.activiti.dmn.engine.ActivitiDmnException;
import org.activiti.dmn.engine.Clock;
import org.activiti.dmn.engine.CustomExpressionFunctionRegistry;
import org.activiti.dmn.engine.DmnEngine;
import org.activiti.dmn.engine.RuleEngineExecutor;
import org.activiti.dmn.engine.impl.DmnEngineImpl;
import org.activiti.dmn.engine.impl.DmnRepositoryServiceImpl;
import org.activiti.dmn.engine.impl.DmnRuleServiceImpl;
import org.activiti.dmn.engine.impl.RuleEngineExecutorImpl;
import org.activiti.dmn.engine.impl.ServiceImpl;
import org.activiti.dmn.engine.impl.cfg.CommandExecutorImpl;
import org.activiti.dmn.engine.impl.cfg.IdGenerator;
import org.activiti.dmn.engine.impl.cfg.StandaloneDmnEngineConfiguration;
import org.activiti.dmn.engine.impl.cfg.StandaloneInMemDmnEngineConfiguration;
import org.activiti.dmn.engine.impl.cfg.TransactionContextFactory;
import org.activiti.dmn.engine.impl.cfg.standalone.StandaloneMybatisTransactionContextFactory;
import org.activiti.dmn.engine.impl.db.DbSqlSessionFactory;
import org.activiti.dmn.engine.impl.deployer.CachingAndArtifactsManager;
import org.activiti.dmn.engine.impl.deployer.DmnDeployer;
import org.activiti.dmn.engine.impl.deployer.DmnDeploymentHelper;
import org.activiti.dmn.engine.impl.deployer.ParsedDeploymentBuilderFactory;
import org.activiti.dmn.engine.impl.interceptor.CommandConfig;
import org.activiti.dmn.engine.impl.interceptor.CommandContextFactory;
import org.activiti.dmn.engine.impl.interceptor.CommandContextInterceptor;
import org.activiti.dmn.engine.impl.interceptor.CommandExecutor;
import org.activiti.dmn.engine.impl.interceptor.CommandInterceptor;
import org.activiti.dmn.engine.impl.interceptor.CommandInvoker;
import org.activiti.dmn.engine.impl.interceptor.LogInterceptor;
import org.activiti.dmn.engine.impl.interceptor.SessionFactory;
import org.activiti.dmn.engine.impl.mvel.config.DefaultCustomExpressionFunctionRegistry;
import org.activiti.dmn.engine.impl.parser.DmnParseFactory;
import org.activiti.dmn.engine.impl.persistence.StrongUuidGenerator;
import org.activiti.dmn.engine.impl.persistence.deploy.DecisionTableCacheEntry;
import org.activiti.dmn.engine.impl.persistence.deploy.DefaultDeploymentCache;
import org.activiti.dmn.engine.impl.persistence.deploy.Deployer;
import org.activiti.dmn.engine.impl.persistence.deploy.DeploymentCache;
import org.activiti.dmn.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.dmn.engine.impl.persistence.entity.DecisionTableEntityManager;
import org.activiti.dmn.engine.impl.persistence.entity.DecisionTableEntityManagerImpl;
import org.activiti.dmn.engine.impl.persistence.entity.DmnDeploymentEntityManager;
import org.activiti.dmn.engine.impl.persistence.entity.DmnDeploymentEntityManagerImpl;
import org.activiti.dmn.engine.impl.persistence.entity.ResourceEntityManager;
import org.activiti.dmn.engine.impl.persistence.entity.ResourceEntityManagerImpl;
import org.activiti.dmn.engine.impl.persistence.entity.data.DecisionTableDataManager;
import org.activiti.dmn.engine.impl.persistence.entity.data.DmnDeploymentDataManager;
import org.activiti.dmn.engine.impl.persistence.entity.data.ResourceDataManager;
import org.activiti.dmn.engine.impl.persistence.entity.data.impl.MybatisDecisionTableDataManager;
import org.activiti.dmn.engine.impl.persistence.entity.data.impl.MybatisDmnDeploymentDataManager;
import org.activiti.dmn.engine.impl.persistence.entity.data.impl.MybatisResourceDataManager;
import org.activiti.dmn.engine.impl.util.DefaultClockImpl;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.builder.xml.XMLConfigBuilder;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.defaults.DefaultSqlSessionFactory;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;
import org.mvel2.integration.PropertyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class DmnEngineConfiguration {
    protected static final Logger logger = LoggerFactory.getLogger(DmnEngineConfiguration.class);
    public static final String NO_TENANT_ID = "";
    public static final String DEFAULT_MYBATIS_MAPPING_FILE = "org/activiti/dmn/db/mapping/mappings.xml";
    public static final String LIQUIBASE_CHANGELOG_PREFIX = "ACT_DMN_";
    public static final String DB_SCHEMA_UPDATE_FALSE = "false";
    public static final String DB_SCHEMA_UPDATE_DROP_CREATE = "create-drop";
    public static final String DB_SCHEMA_UPDATE_TRUE = "true";
    protected String dmnEngineName = "default";
    protected String databaseType;
    protected String jdbcDriver = "org.h2.Driver";
    protected String jdbcUrl = "jdbc:h2:tcp://localhost/~/activitidmn";
    protected String jdbcUsername = "sa";
    protected String jdbcPassword = "";
    protected String dataSourceJndiName;
    protected int jdbcMaxActiveConnections;
    protected int jdbcMaxIdleConnections;
    protected int jdbcMaxCheckoutTime;
    protected int jdbcMaxWaitTime;
    protected boolean jdbcPingEnabled;
    protected String jdbcPingQuery;
    protected int jdbcPingConnectionNotUsedFor;
    protected int jdbcDefaultTransactionIsolationLevel;
    protected DataSource dataSource;
    protected String databaseSchemaUpdate = "true";
    protected String xmlEncoding = "UTF-8";
    protected BeanFactory beanFactory;
    protected CommandConfig defaultCommandConfig;
    protected CommandConfig schemaCommandConfig;
    protected CommandInterceptor commandInvoker;
    protected List<CommandInterceptor> customPreCommandInterceptors;
    protected List<CommandInterceptor> customPostCommandInterceptors;
    protected List<CommandInterceptor> commandInterceptors;
    protected CommandExecutor commandExecutor;
    protected DmnRepositoryService repositoryService = new DmnRepositoryServiceImpl();
    protected DmnRuleService ruleService = new DmnRuleServiceImpl();
    protected RuleEngineExecutor ruleEngineExecutor = new RuleEngineExecutorImpl();
    protected DmnDeploymentDataManager deploymentDataManager;
    protected DecisionTableDataManager decisionTableDataManager;
    protected ResourceDataManager resourceDataManager;
    protected DmnDeploymentEntityManager deploymentEntityManager;
    protected DecisionTableEntityManager decisionTableEntityManager;
    protected ResourceEntityManager resourceEntityManager;
    protected CommandContextFactory commandContextFactory;
    protected TransactionContextFactory transactionContextFactory;
    protected SqlSessionFactory sqlSessionFactory;
    protected TransactionFactory transactionFactory;
    protected Set<Class<?>> customMybatisMappers;
    protected Set<String> customMybatisXMLMappers;
    protected List<SessionFactory> customSessionFactories;
    protected DbSqlSessionFactory dbSqlSessionFactory;
    protected Map<Class<?>, SessionFactory> sessionFactories;
    protected boolean transactionsExternallyManaged;
    protected boolean usingRelationalDatabase = true;
    protected String databaseTablePrefix = "";
    protected String databaseCatalog = "";
    protected String databaseSchema;
    protected boolean tablePrefixIsSchema;
    protected static Properties databaseTypeMappings = DmnEngineConfiguration.getDefaultDatabaseTypeMappings();
    public static final String DATABASE_TYPE_H2 = "h2";
    public static final String DATABASE_TYPE_HSQL = "hsql";
    public static final String DATABASE_TYPE_MYSQL = "mysql";
    public static final String DATABASE_TYPE_ORACLE = "oracle";
    public static final String DATABASE_TYPE_POSTGRES = "postgres";
    public static final String DATABASE_TYPE_MSSQL = "mssql";
    public static final String DATABASE_TYPE_DB2 = "db2";
    protected DmnDeployer dmnDeployer;
    protected DmnParseFactory dmnParseFactory;
    protected ParsedDeploymentBuilderFactory parsedDeploymentBuilderFactory;
    protected DmnDeploymentHelper dmnDeploymentHelper;
    protected CachingAndArtifactsManager cachingAndArtifactsManager;
    protected List<Deployer> customPreDeployers;
    protected List<Deployer> customPostDeployers;
    protected List<Deployer> deployers;
    protected DeploymentManager deploymentManager;
    protected int decisionCacheLimit = -1;
    protected DeploymentCache<DecisionTableCacheEntry> decisionCache;
    protected IdGenerator idGenerator;
    protected Clock clock;
    protected CustomExpressionFunctionRegistry customExpressionFunctionRegistry;
    protected CustomExpressionFunctionRegistry postCustomExpressionFunctionRegistry;
    protected Map<String, Method> customExpressionFunctions = new HashMap<String, Method>();
    protected Map<Class<?>, PropertyHandler> customPropertyHandlers = new HashMap();
    protected boolean enableSafeDmnXml;

    public static Properties getDefaultDatabaseTypeMappings() {
        Properties databaseTypeMappings = new Properties();
        databaseTypeMappings.setProperty("H2", DATABASE_TYPE_H2);
        databaseTypeMappings.setProperty("HSQL Database Engine", DATABASE_TYPE_HSQL);
        databaseTypeMappings.setProperty("MySQL", DATABASE_TYPE_MYSQL);
        databaseTypeMappings.setProperty("Oracle", DATABASE_TYPE_ORACLE);
        databaseTypeMappings.setProperty("PostgreSQL", DATABASE_TYPE_POSTGRES);
        databaseTypeMappings.setProperty("Microsoft SQL Server", DATABASE_TYPE_MSSQL);
        databaseTypeMappings.setProperty(DATABASE_TYPE_DB2, DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/NT", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/NT64", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2 UDP", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/LINUX", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/LINUX390", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/LINUXX8664", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/LINUXZ64", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/LINUXPPC64", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/400 SQL", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/6000", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2 UDB iSeries", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/AIX64", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/HPUX", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/HP64", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/SUN", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/SUN64", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/PTX", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/2", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2 UDB AS400", DATABASE_TYPE_DB2);
        return databaseTypeMappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDatabaseType() {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String databaseProductName = databaseMetaData.getDatabaseProductName();
            logger.debug("database product name: '{}'", (Object)databaseProductName);
            this.databaseType = databaseTypeMappings.getProperty(databaseProductName);
            if (this.databaseType == null) {
                throw new ActivitiDmnException("couldn't deduct database type from database product name '" + databaseProductName + "'");
            }
            logger.debug("using database type: {}", (Object)this.databaseType);
        }
        catch (SQLException e) {
            logger.error("Exception while initializing Database connection", (Throwable)e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                logger.error("Exception while closing the Database connection", (Throwable)e);
            }
        }
    }

    public static DmnEngineConfiguration createDmnEngineConfigurationFromResourceDefault() {
        return DmnEngineConfiguration.createDmnEngineConfigurationFromResource("activiti.dmn.cfg.xml", "dmnEngineConfiguration");
    }

    public static DmnEngineConfiguration createDmnEngineConfigurationFromResource(String resource) {
        return DmnEngineConfiguration.createDmnEngineConfigurationFromResource(resource, "dmnEngineConfiguration");
    }

    public static DmnEngineConfiguration createDmnEngineConfigurationFromResource(String resource, String beanName) {
        return DmnEngineConfiguration.parseProcessEngineConfigurationFromResource(resource, beanName);
    }

    public static DmnEngineConfiguration createDmnEngineConfigurationFromInputStream(InputStream inputStream) {
        return DmnEngineConfiguration.createDmnEngineConfigurationFromInputStream(inputStream, "dmnEngineConfiguration");
    }

    public static DmnEngineConfiguration createDmnEngineConfigurationFromInputStream(InputStream inputStream, String beanName) {
        return DmnEngineConfiguration.parseProcessEngineConfigurationFromInputStream(inputStream, beanName);
    }

    public static DmnEngineConfiguration createStandaloneDmnEngineConfiguration() {
        return new StandaloneDmnEngineConfiguration();
    }

    public static DmnEngineConfiguration createStandaloneInMemDmnEngineConfiguration() {
        return new StandaloneInMemDmnEngineConfiguration();
    }

    public static DmnEngineConfiguration parseDmnEngineConfiguration(Resource springResource, String beanName) {
        DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory();
        XmlBeanDefinitionReader xmlBeanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
        xmlBeanDefinitionReader.setValidationMode(3);
        xmlBeanDefinitionReader.loadBeanDefinitions(springResource);
        DmnEngineConfiguration processEngineConfiguration = (DmnEngineConfiguration)beanFactory.getBean(beanName);
        processEngineConfiguration.setBeanFactory((BeanFactory)beanFactory);
        return processEngineConfiguration;
    }

    public static DmnEngineConfiguration parseProcessEngineConfigurationFromInputStream(InputStream inputStream, String beanName) {
        InputStreamResource springResource = new InputStreamResource(inputStream);
        return DmnEngineConfiguration.parseDmnEngineConfiguration((Resource)springResource, beanName);
    }

    public static DmnEngineConfiguration parseProcessEngineConfigurationFromResource(String resource, String beanName) {
        ClassPathResource springResource = new ClassPathResource(resource);
        return DmnEngineConfiguration.parseDmnEngineConfiguration((Resource)springResource, beanName);
    }

    public DmnEngine buildDmnEngine() {
        this.init();
        return new DmnEngineImpl(this);
    }

    protected void init() {
        this.initCommandContextFactory();
        this.initTransactionContextFactory();
        this.initCommandExecutors();
        this.initIdGenerator();
        this.initDataSource();
        this.initDbSchema();
        this.initTransactionFactory();
        this.initSqlSessionFactory();
        this.initSessionFactories();
        this.initServices();
        this.initDataManagers();
        this.initEntityManagers();
        this.initDeployers();
        this.initClock();
        this.initCustomExpressionFunctions();
    }

    protected void initServices() {
        this.initService(this.repositoryService);
        this.initService(this.ruleService);
    }

    protected void initService(Object service) {
        if (service instanceof ServiceImpl) {
            ((ServiceImpl)service).setCommandExecutor(this.commandExecutor);
        }
    }

    public void initDataManagers() {
        if (this.deploymentDataManager == null) {
            this.deploymentDataManager = new MybatisDmnDeploymentDataManager(this);
        }
        if (this.decisionTableDataManager == null) {
            this.decisionTableDataManager = new MybatisDecisionTableDataManager(this);
        }
        if (this.resourceDataManager == null) {
            this.resourceDataManager = new MybatisResourceDataManager(this);
        }
    }

    public void initEntityManagers() {
        if (this.deploymentEntityManager == null) {
            this.deploymentEntityManager = new DmnDeploymentEntityManagerImpl(this, this.deploymentDataManager);
        }
        if (this.decisionTableEntityManager == null) {
            this.decisionTableEntityManager = new DecisionTableEntityManagerImpl(this, this.decisionTableDataManager);
        }
        if (this.resourceEntityManager == null) {
            this.resourceEntityManager = new ResourceEntityManagerImpl(this, this.resourceDataManager);
        }
    }

    protected void initDataSource() {
        if (this.dataSource == null) {
            if (this.dataSourceJndiName != null) {
                try {
                    this.dataSource = (DataSource)new InitialContext().lookup(this.dataSourceJndiName);
                }
                catch (Exception e) {
                    throw new ActivitiDmnException("couldn't lookup datasource from " + this.dataSourceJndiName + ": " + e.getMessage(), e);
                }
            } else if (this.jdbcUrl != null) {
                if (this.jdbcDriver == null || this.jdbcUsername == null) {
                    throw new ActivitiDmnException("DataSource or JDBC properties have to be specified in a process engine configuration");
                }
                logger.debug("initializing datasource to db: {}", (Object)this.jdbcUrl);
                if (logger.isInfoEnabled()) {
                    logger.info("Configuring Datasource with following properties (omitted password for security)");
                    logger.info("datasource driver: " + this.jdbcDriver);
                    logger.info("datasource url : " + this.jdbcUrl);
                    logger.info("datasource user name : " + this.jdbcUsername);
                }
                PooledDataSource pooledDataSource = new PooledDataSource(this.getClass().getClassLoader(), this.jdbcDriver, this.jdbcUrl, this.jdbcUsername, this.jdbcPassword);
                if (this.jdbcMaxActiveConnections > 0) {
                    pooledDataSource.setPoolMaximumActiveConnections(this.jdbcMaxActiveConnections);
                }
                if (this.jdbcMaxIdleConnections > 0) {
                    pooledDataSource.setPoolMaximumIdleConnections(this.jdbcMaxIdleConnections);
                }
                if (this.jdbcMaxCheckoutTime > 0) {
                    pooledDataSource.setPoolMaximumCheckoutTime(this.jdbcMaxCheckoutTime);
                }
                if (this.jdbcMaxWaitTime > 0) {
                    pooledDataSource.setPoolTimeToWait(this.jdbcMaxWaitTime);
                }
                if (this.jdbcPingEnabled) {
                    pooledDataSource.setPoolPingEnabled(true);
                    if (this.jdbcPingQuery != null) {
                        pooledDataSource.setPoolPingQuery(this.jdbcPingQuery);
                    }
                    pooledDataSource.setPoolPingConnectionsNotUsedFor(this.jdbcPingConnectionNotUsedFor);
                }
                if (this.jdbcDefaultTransactionIsolationLevel > 0) {
                    pooledDataSource.setDefaultTransactionIsolationLevel(Integer.valueOf(this.jdbcDefaultTransactionIsolationLevel));
                }
                this.dataSource = pooledDataSource;
            }
            if (this.dataSource instanceof PooledDataSource) {
                ((PooledDataSource)this.dataSource).forceCloseAll();
            }
        }
        if (this.databaseType == null) {
            this.initDatabaseType();
        }
    }

    public void initDbSchema() {
        try {
            JdbcConnection connection = new JdbcConnection(this.dataSource.getConnection());
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
            database.setDatabaseChangeLogTableName(LIQUIBASE_CHANGELOG_PREFIX + database.getDatabaseChangeLogTableName());
            database.setDatabaseChangeLogLockTableName(LIQUIBASE_CHANGELOG_PREFIX + database.getDatabaseChangeLogLockTableName());
            if (StringUtils.isNotEmpty((CharSequence)this.databaseSchema)) {
                database.setDefaultSchemaName(this.databaseSchema);
                database.setLiquibaseSchemaName(this.databaseSchema);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.databaseCatalog)) {
                database.setDefaultCatalogName(this.databaseCatalog);
                database.setLiquibaseCatalogName(this.databaseCatalog);
            }
            Liquibase liquibase = new Liquibase("org/activiti/dmn/db/liquibase/activiti-dmn-db-changelog.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            if (DB_SCHEMA_UPDATE_DROP_CREATE.equals(this.databaseSchemaUpdate)) {
                logger.debug("Dropping and creating schema DMN");
                liquibase.dropAll();
                liquibase.update("dmn");
            } else if (DB_SCHEMA_UPDATE_TRUE.equals(this.databaseSchemaUpdate)) {
                logger.debug("Updating schema DMN");
                liquibase.update("dmn");
            } else if (DB_SCHEMA_UPDATE_FALSE.equals(this.databaseSchemaUpdate)) {
                logger.debug("Validating schema DMN");
                liquibase.validate();
            }
        }
        catch (Exception e) {
            throw new ActivitiDmnException("Error initialising dmn data model");
        }
    }

    public void initSessionFactories() {
        if (this.sessionFactories == null) {
            this.sessionFactories = new HashMap();
            if (this.usingRelationalDatabase) {
                this.initDbSqlSessionFactory();
            }
        }
        if (this.customSessionFactories != null) {
            for (SessionFactory sessionFactory : this.customSessionFactories) {
                this.addSessionFactory(sessionFactory);
            }
        }
    }

    public void initDbSqlSessionFactory() {
        if (this.dbSqlSessionFactory == null) {
            this.dbSqlSessionFactory = this.createDbSqlSessionFactory();
        }
        this.dbSqlSessionFactory.setDatabaseType(this.databaseType);
        this.dbSqlSessionFactory.setSqlSessionFactory(this.sqlSessionFactory);
        this.dbSqlSessionFactory.setIdGenerator(this.idGenerator);
        this.dbSqlSessionFactory.setDatabaseTablePrefix(this.databaseTablePrefix);
        this.dbSqlSessionFactory.setTablePrefixIsSchema(this.tablePrefixIsSchema);
        this.dbSqlSessionFactory.setDatabaseCatalog(this.databaseCatalog);
        this.dbSqlSessionFactory.setDatabaseSchema(this.databaseSchema);
        this.addSessionFactory(this.dbSqlSessionFactory);
    }

    public DbSqlSessionFactory createDbSqlSessionFactory() {
        return new DbSqlSessionFactory();
    }

    public void addSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactories.put(sessionFactory.getSessionType(), sessionFactory);
    }

    public void initCommandExecutors() {
        this.initDefaultCommandConfig();
        this.initSchemaCommandConfig();
        this.initCommandInvoker();
        this.initCommandInterceptors();
        this.initCommandExecutor();
    }

    public void initDefaultCommandConfig() {
        if (this.defaultCommandConfig == null) {
            this.defaultCommandConfig = new CommandConfig();
        }
    }

    public void initSchemaCommandConfig() {
        if (this.schemaCommandConfig == null) {
            this.schemaCommandConfig = new CommandConfig().transactionNotSupported();
        }
    }

    public void initCommandInvoker() {
        if (this.commandInvoker == null) {
            this.commandInvoker = new CommandInvoker();
        }
    }

    public void initCommandInterceptors() {
        if (this.commandInterceptors == null) {
            this.commandInterceptors = new ArrayList<CommandInterceptor>();
            if (this.customPreCommandInterceptors != null) {
                this.commandInterceptors.addAll(this.customPreCommandInterceptors);
            }
            this.commandInterceptors.addAll(this.getDefaultCommandInterceptors());
            if (this.customPostCommandInterceptors != null) {
                this.commandInterceptors.addAll(this.customPostCommandInterceptors);
            }
            this.commandInterceptors.add(this.commandInvoker);
        }
    }

    public Collection<? extends CommandInterceptor> getDefaultCommandInterceptors() {
        ArrayList<CommandInterceptor> interceptors = new ArrayList<CommandInterceptor>();
        interceptors.add(new LogInterceptor());
        CommandInterceptor transactionInterceptor = this.createTransactionInterceptor();
        if (transactionInterceptor != null) {
            interceptors.add(transactionInterceptor);
        }
        interceptors.add(new CommandContextInterceptor(this.commandContextFactory, this));
        return interceptors;
    }

    public void initCommandExecutor() {
        if (this.commandExecutor == null) {
            CommandInterceptor first = this.initInterceptorChain(this.commandInterceptors);
            this.commandExecutor = new CommandExecutorImpl(this.getDefaultCommandConfig(), first);
        }
    }

    public CommandInterceptor initInterceptorChain(List<CommandInterceptor> chain) {
        if (chain == null || chain.isEmpty()) {
            throw new ActivitiDmnException("invalid command interceptor chain configuration: " + chain);
        }
        for (int i = 0; i < chain.size() - 1; ++i) {
            chain.get(i).setNext(chain.get(i + 1));
        }
        return chain.get(0);
    }

    public CommandInterceptor createTransactionInterceptor() {
        return null;
    }

    protected void initDeployers() {
        if (this.dmnParseFactory == null) {
            this.dmnParseFactory = new DmnParseFactory();
        }
        if (this.dmnDeployer == null) {
            this.deployers = new ArrayList<Deployer>();
            if (this.customPreDeployers != null) {
                this.deployers.addAll(this.customPreDeployers);
            }
            this.deployers.addAll(this.getDefaultDeployers());
            if (this.customPostDeployers != null) {
                this.deployers.addAll(this.customPostDeployers);
            }
        }
        if (this.decisionCache == null) {
            this.decisionCache = this.decisionCacheLimit <= 0 ? new DefaultDeploymentCache<DecisionTableCacheEntry>() : new DefaultDeploymentCache<DecisionTableCacheEntry>(this.decisionCacheLimit);
        }
        this.deploymentManager = new DeploymentManager(this.decisionCache, this);
        this.deploymentManager.setDeployers(this.deployers);
        this.deploymentManager.setDeploymentEntityManager(this.deploymentEntityManager);
        this.deploymentManager.setDecisionTableEntityManager(this.decisionTableEntityManager);
    }

    public Collection<? extends Deployer> getDefaultDeployers() {
        ArrayList<DmnDeployer> defaultDeployers = new ArrayList<DmnDeployer>();
        if (this.dmnDeployer == null) {
            this.dmnDeployer = new DmnDeployer();
        }
        this.initDmnDeployerDependencies();
        this.dmnDeployer.setIdGenerator(this.idGenerator);
        this.dmnDeployer.setParsedDeploymentBuilderFactory(this.parsedDeploymentBuilderFactory);
        this.dmnDeployer.setDmnDeploymentHelper(this.dmnDeploymentHelper);
        this.dmnDeployer.setCachingAndArtifactsManager(this.cachingAndArtifactsManager);
        defaultDeployers.add(this.dmnDeployer);
        return defaultDeployers;
    }

    public void initDmnDeployerDependencies() {
        if (this.parsedDeploymentBuilderFactory == null) {
            this.parsedDeploymentBuilderFactory = new ParsedDeploymentBuilderFactory();
        }
        if (this.parsedDeploymentBuilderFactory.getDmnParseFactory() == null) {
            this.parsedDeploymentBuilderFactory.setDmnParseFactory(this.dmnParseFactory);
        }
        if (this.dmnDeploymentHelper == null) {
            this.dmnDeploymentHelper = new DmnDeploymentHelper();
        }
        if (this.cachingAndArtifactsManager == null) {
            this.cachingAndArtifactsManager = new CachingAndArtifactsManager();
        }
    }

    public void initIdGenerator() {
        if (this.idGenerator == null) {
            this.idGenerator = new StrongUuidGenerator();
        }
    }

    public void initCommandContextFactory() {
        if (this.commandContextFactory == null) {
            this.commandContextFactory = new CommandContextFactory();
        }
        this.commandContextFactory.setDmnEngineConfiguration(this);
    }

    public void initTransactionContextFactory() {
        if (this.transactionContextFactory == null) {
            this.transactionContextFactory = new StandaloneMybatisTransactionContextFactory();
        }
    }

    public void initClock() {
        if (this.clock == null) {
            this.clock = new DefaultClockImpl();
        }
    }

    protected void initCustomExpressionFunctions() {
        if (this.customExpressionFunctionRegistry == null) {
            this.customExpressionFunctions.putAll(new DefaultCustomExpressionFunctionRegistry().getCustomExpressionMethods());
        } else {
            this.customExpressionFunctions.putAll(this.customExpressionFunctionRegistry.getCustomExpressionMethods());
        }
        if (this.postCustomExpressionFunctionRegistry != null) {
            this.customExpressionFunctions.putAll(this.postCustomExpressionFunctionRegistry.getCustomExpressionMethods());
        }
    }

    public void initTransactionFactory() {
        if (this.transactionFactory == null) {
            this.transactionFactory = this.transactionsExternallyManaged ? new ManagedTransactionFactory() : new JdbcTransactionFactory();
        }
    }

    public void initSqlSessionFactory() {
        if (this.sqlSessionFactory == null) {
            InputStream inputStream = null;
            try {
                inputStream = this.getMyBatisXmlConfigurationStream();
                Environment environment = new Environment("default", this.transactionFactory, this.dataSource);
                InputStreamReader reader = new InputStreamReader(inputStream);
                Properties properties = new Properties();
                properties.put("prefix", this.databaseTablePrefix);
                properties.put("limitBefore", NO_TENANT_ID);
                properties.put("limitAfter", NO_TENANT_ID);
                properties.put("limitBetween", NO_TENANT_ID);
                properties.put("limitOuterJoinBetween", NO_TENANT_ID);
                properties.put("limitBeforeNativeQuery", NO_TENANT_ID);
                properties.put("orderBy", "order by ${orderByColumns}");
                properties.put("blobType", "BLOB");
                properties.put("boolValue", "TRUE");
                if (this.databaseType != null) {
                    properties.load(this.getResourceAsStream("org/activiti/dmn/db/properties/" + this.databaseType + ".properties"));
                }
                Configuration configuration = this.initMybatisConfiguration(environment, reader, properties);
                this.sqlSessionFactory = new DefaultSqlSessionFactory(configuration);
            }
            catch (Exception e) {
                throw new ActivitiDmnException("Error while building ibatis SqlSessionFactory: " + e.getMessage(), e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
    }

    public Configuration initMybatisConfiguration(Environment environment, Reader reader, Properties properties) {
        XMLConfigBuilder parser = new XMLConfigBuilder(reader, NO_TENANT_ID, properties);
        Configuration configuration = parser.getConfiguration();
        if (this.databaseType != null) {
            configuration.setDatabaseId(this.databaseType);
        }
        configuration.setEnvironment(environment);
        this.initCustomMybatisMappers(configuration);
        configuration = this.parseMybatisConfiguration(configuration, parser);
        return configuration;
    }

    public void initCustomMybatisMappers(Configuration configuration) {
        if (this.getCustomMybatisMappers() != null) {
            for (Class<?> clazz : this.getCustomMybatisMappers()) {
                configuration.addMapper(clazz);
            }
        }
    }

    public Configuration parseMybatisConfiguration(Configuration configuration, XMLConfigBuilder parser) {
        return this.parseCustomMybatisXMLMappers(parser.parse());
    }

    public Configuration parseCustomMybatisXMLMappers(Configuration configuration) {
        if (this.getCustomMybatisXMLMappers() != null) {
            for (String resource : this.getCustomMybatisXMLMappers()) {
                XMLMapperBuilder mapperParser = new XMLMapperBuilder(this.getResourceAsStream(resource), configuration, resource, configuration.getSqlFragments());
                mapperParser.parse();
            }
        }
        return configuration;
    }

    protected InputStream getResourceAsStream(String resource) {
        return this.getClass().getClassLoader().getResourceAsStream(resource);
    }

    public InputStream getMyBatisXmlConfigurationStream() {
        return this.getResourceAsStream(DEFAULT_MYBATIS_MAPPING_FILE);
    }

    public String getDmnEngineName() {
        return this.dmnEngineName;
    }

    public DmnEngineConfiguration setDmnEngineName(String dmnEngineName) {
        this.dmnEngineName = dmnEngineName;
        return this;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public DmnEngineConfiguration setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
        return this;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DmnEngineConfiguration setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public DmnEngineConfiguration setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
        return this;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public DmnEngineConfiguration setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
        return this;
    }

    public String getJdbcUsername() {
        return this.jdbcUsername;
    }

    public DmnEngineConfiguration setJdbcUsername(String jdbcUsername) {
        this.jdbcUsername = jdbcUsername;
        return this;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public DmnEngineConfiguration setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
        return this;
    }

    public int getJdbcMaxActiveConnections() {
        return this.jdbcMaxActiveConnections;
    }

    public DmnEngineConfiguration setJdbcMaxActiveConnections(int jdbcMaxActiveConnections) {
        this.jdbcMaxActiveConnections = jdbcMaxActiveConnections;
        return this;
    }

    public int getJdbcMaxIdleConnections() {
        return this.jdbcMaxIdleConnections;
    }

    public DmnEngineConfiguration setJdbcMaxIdleConnections(int jdbcMaxIdleConnections) {
        this.jdbcMaxIdleConnections = jdbcMaxIdleConnections;
        return this;
    }

    public int getJdbcMaxCheckoutTime() {
        return this.jdbcMaxCheckoutTime;
    }

    public DmnEngineConfiguration setJdbcMaxCheckoutTime(int jdbcMaxCheckoutTime) {
        this.jdbcMaxCheckoutTime = jdbcMaxCheckoutTime;
        return this;
    }

    public int getJdbcMaxWaitTime() {
        return this.jdbcMaxWaitTime;
    }

    public DmnEngineConfiguration setJdbcMaxWaitTime(int jdbcMaxWaitTime) {
        this.jdbcMaxWaitTime = jdbcMaxWaitTime;
        return this;
    }

    public boolean isJdbcPingEnabled() {
        return this.jdbcPingEnabled;
    }

    public DmnEngineConfiguration setJdbcPingEnabled(boolean jdbcPingEnabled) {
        this.jdbcPingEnabled = jdbcPingEnabled;
        return this;
    }

    public int getJdbcPingConnectionNotUsedFor() {
        return this.jdbcPingConnectionNotUsedFor;
    }

    public DmnEngineConfiguration setJdbcPingConnectionNotUsedFor(int jdbcPingConnectionNotUsedFor) {
        this.jdbcPingConnectionNotUsedFor = jdbcPingConnectionNotUsedFor;
        return this;
    }

    public int getJdbcDefaultTransactionIsolationLevel() {
        return this.jdbcDefaultTransactionIsolationLevel;
    }

    public DmnEngineConfiguration setJdbcDefaultTransactionIsolationLevel(int jdbcDefaultTransactionIsolationLevel) {
        this.jdbcDefaultTransactionIsolationLevel = jdbcDefaultTransactionIsolationLevel;
        return this;
    }

    public String getJdbcPingQuery() {
        return this.jdbcPingQuery;
    }

    public DmnEngineConfiguration setJdbcPingQuery(String jdbcPingQuery) {
        this.jdbcPingQuery = jdbcPingQuery;
        return this;
    }

    public String getDataSourceJndiName() {
        return this.dataSourceJndiName;
    }

    public DmnEngineConfiguration setDataSourceJndiName(String dataSourceJndiName) {
        this.dataSourceJndiName = dataSourceJndiName;
        return this;
    }

    public String getXmlEncoding() {
        return this.xmlEncoding;
    }

    public DmnEngineConfiguration setXmlEncoding(String xmlEncoding) {
        this.xmlEncoding = xmlEncoding;
        return this;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public DmnEngineConfiguration setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        return this;
    }

    public CommandConfig getDefaultCommandConfig() {
        return this.defaultCommandConfig;
    }

    public DmnEngineConfiguration setDefaultCommandConfig(CommandConfig defaultCommandConfig) {
        this.defaultCommandConfig = defaultCommandConfig;
        return this;
    }

    public CommandInterceptor getCommandInvoker() {
        return this.commandInvoker;
    }

    public DmnEngineConfiguration setCommandInvoker(CommandInterceptor commandInvoker) {
        this.commandInvoker = commandInvoker;
        return this;
    }

    public List<CommandInterceptor> getCustomPreCommandInterceptors() {
        return this.customPreCommandInterceptors;
    }

    public DmnEngineConfiguration setCustomPreCommandInterceptors(List<CommandInterceptor> customPreCommandInterceptors) {
        this.customPreCommandInterceptors = customPreCommandInterceptors;
        return this;
    }

    public List<CommandInterceptor> getCustomPostCommandInterceptors() {
        return this.customPostCommandInterceptors;
    }

    public DmnEngineConfiguration setCustomPostCommandInterceptors(List<CommandInterceptor> customPostCommandInterceptors) {
        this.customPostCommandInterceptors = customPostCommandInterceptors;
        return this;
    }

    public List<CommandInterceptor> getCommandInterceptors() {
        return this.commandInterceptors;
    }

    public DmnEngineConfiguration setCommandInterceptors(List<CommandInterceptor> commandInterceptors) {
        this.commandInterceptors = commandInterceptors;
        return this;
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public DmnEngineConfiguration setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        return this;
    }

    public DmnRepositoryService getDmnRepositoryService() {
        return this.repositoryService;
    }

    public DmnRuleService getDmnRuleService() {
        return this.ruleService;
    }

    public RuleEngineExecutor getRuleEngineExecutor() {
        return this.ruleEngineExecutor;
    }

    public DeploymentManager getDeploymentManager() {
        return this.deploymentManager;
    }

    public DmnEngineConfiguration getDmnEngineConfiguration() {
        return this;
    }

    public DmnDeployer getDmnDeployer() {
        return this.dmnDeployer;
    }

    public DmnEngineConfiguration setDmnDeployer(DmnDeployer dmnDeployer) {
        this.dmnDeployer = dmnDeployer;
        return this;
    }

    public DmnParseFactory getDmnParseFactory() {
        return this.dmnParseFactory;
    }

    public DmnEngineConfiguration setDmnParseFactory(DmnParseFactory dmnParseFactory) {
        this.dmnParseFactory = dmnParseFactory;
        return this;
    }

    public int getDecisionCacheLimit() {
        return this.decisionCacheLimit;
    }

    public DmnEngineConfiguration setDecisionCacheLimit(int decisionCacheLimit) {
        this.decisionCacheLimit = decisionCacheLimit;
        return this;
    }

    public DeploymentCache<DecisionTableCacheEntry> getDecisionCache() {
        return this.decisionCache;
    }

    public DmnEngineConfiguration setDecisionCache(DeploymentCache<DecisionTableCacheEntry> decisionCache) {
        this.decisionCache = decisionCache;
        return this;
    }

    public DmnDeploymentDataManager getDeploymentDataManager() {
        return this.deploymentDataManager;
    }

    public void setDeploymentDataManager(DmnDeploymentDataManager deploymentDataManager) {
        this.deploymentDataManager = deploymentDataManager;
    }

    public DecisionTableDataManager getDecisionTableDataManager() {
        return this.decisionTableDataManager;
    }

    public void setDecisionTableDataManager(DecisionTableDataManager decisionTableDataManager) {
        this.decisionTableDataManager = decisionTableDataManager;
    }

    public ResourceDataManager getResourceDataManager() {
        return this.resourceDataManager;
    }

    public void setResourceDataManager(ResourceDataManager resourceDataManager) {
        this.resourceDataManager = resourceDataManager;
    }

    public DmnDeploymentEntityManager getDeploymentEntityManager() {
        return this.deploymentEntityManager;
    }

    public void setDeploymentEntityManager(DmnDeploymentEntityManager deploymentEntityManager) {
        this.deploymentEntityManager = deploymentEntityManager;
    }

    public DecisionTableEntityManager getDecisionTableEntityManager() {
        return this.decisionTableEntityManager;
    }

    public void setDecisionTableEntityManager(DecisionTableEntityManager decisionTableEntityManager) {
        this.decisionTableEntityManager = decisionTableEntityManager;
    }

    public ResourceEntityManager getResourceEntityManager() {
        return this.resourceEntityManager;
    }

    public void setResourceEntityManager(ResourceEntityManager resourceEntityManager) {
        this.resourceEntityManager = resourceEntityManager;
    }

    public CommandContextFactory getCommandContextFactory() {
        return this.commandContextFactory;
    }

    public void setCommandContextFactory(CommandContextFactory commandContextFactory) {
        this.commandContextFactory = commandContextFactory;
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public TransactionFactory getTransactionFactory() {
        return this.transactionFactory;
    }

    public void setTransactionFactory(TransactionFactory transactionFactory) {
        this.transactionFactory = transactionFactory;
    }

    public Set<Class<?>> getCustomMybatisMappers() {
        return this.customMybatisMappers;
    }

    public void setCustomMybatisMappers(Set<Class<?>> customMybatisMappers) {
        this.customMybatisMappers = customMybatisMappers;
    }

    public Set<String> getCustomMybatisXMLMappers() {
        return this.customMybatisXMLMappers;
    }

    public void setCustomMybatisXMLMappers(Set<String> customMybatisXMLMappers) {
        this.customMybatisXMLMappers = customMybatisXMLMappers;
    }

    public List<SessionFactory> getCustomSessionFactories() {
        return this.customSessionFactories;
    }

    public void setCustomSessionFactories(List<SessionFactory> customSessionFactories) {
        this.customSessionFactories = customSessionFactories;
    }

    public DbSqlSessionFactory getDbSqlSessionFactory() {
        return this.dbSqlSessionFactory;
    }

    public void setDbSqlSessionFactory(DbSqlSessionFactory dbSqlSessionFactory) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
    }

    public boolean isUsingRelationalDatabase() {
        return this.usingRelationalDatabase;
    }

    public void setUsingRelationalDatabase(boolean usingRelationalDatabase) {
        this.usingRelationalDatabase = usingRelationalDatabase;
    }

    public String getDatabaseTablePrefix() {
        return this.databaseTablePrefix;
    }

    public void setDatabaseTablePrefix(String databaseTablePrefix) {
        this.databaseTablePrefix = databaseTablePrefix;
    }

    public String getDatabaseCatalog() {
        return this.databaseCatalog;
    }

    public void setDatabaseCatalog(String databaseCatalog) {
        this.databaseCatalog = databaseCatalog;
    }

    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    public void setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    public boolean isTablePrefixIsSchema() {
        return this.tablePrefixIsSchema;
    }

    public void setTablePrefixIsSchema(boolean tablePrefixIsSchema) {
        this.tablePrefixIsSchema = tablePrefixIsSchema;
    }

    public Map<Class<?>, SessionFactory> getSessionFactories() {
        return this.sessionFactories;
    }

    public DmnEngineConfiguration setSessionFactories(Map<Class<?>, SessionFactory> sessionFactories) {
        this.sessionFactories = sessionFactories;
        return this;
    }

    public TransactionContextFactory getTransactionContextFactory() {
        return this.transactionContextFactory;
    }

    public DmnEngineConfiguration setTransactionContextFactory(TransactionContextFactory transactionContextFactory) {
        this.transactionContextFactory = transactionContextFactory;
        return this;
    }

    public boolean isEnableSafeDmnXml() {
        return this.enableSafeDmnXml;
    }

    public DmnEngineConfiguration setEnableSafeDmnXml(boolean enableSafeDmnXml) {
        this.enableSafeDmnXml = enableSafeDmnXml;
        return this;
    }

    public Clock getClock() {
        return this.clock;
    }

    public DmnEngineConfiguration setClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public CustomExpressionFunctionRegistry getCustomExpressionFunctionRegistry() {
        return this.customExpressionFunctionRegistry;
    }

    public void setCustomExpressionFunctionRegistry(CustomExpressionFunctionRegistry customExpressionFunctionRegistry) {
        this.customExpressionFunctionRegistry = customExpressionFunctionRegistry;
    }

    public CustomExpressionFunctionRegistry getPostCustomExpressionFunctionRegistry() {
        return this.postCustomExpressionFunctionRegistry;
    }

    public void setPostCustomExpressionFunctionRegistry(CustomExpressionFunctionRegistry postCustomExpressionFunctionRegistry) {
        this.postCustomExpressionFunctionRegistry = postCustomExpressionFunctionRegistry;
    }

    public Map<String, Method> getCustomExpressionFunctions() {
        return this.customExpressionFunctions;
    }

    public void setCustomExpressionFunctions(Map<String, Method> customExpressionFunctions) {
        this.customExpressionFunctions = customExpressionFunctions;
    }

    public Map<Class<?>, PropertyHandler> getCustomPropertyHandlers() {
        return this.customPropertyHandlers;
    }

    public void setCustomPropertyHandlers(Map<Class<?>, PropertyHandler> customPropertyHandlers) {
        this.customPropertyHandlers = customPropertyHandlers;
    }

    public DmnEngineConfiguration setDatabaseSchemaUpdate(String databaseSchemaUpdate) {
        this.databaseSchemaUpdate = databaseSchemaUpdate;
        return this;
    }
}

