/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.engine;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.activiti.dmn.engine.ActivitiDmnException;
import org.activiti.dmn.engine.DmnEngine;
import org.activiti.dmn.engine.DmnEngineConfiguration;
import org.activiti.dmn.engine.DmnEngineInfo;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DmnEngines {
    private static Logger log = LoggerFactory.getLogger(DmnEngines.class);
    public static final String NAME_DEFAULT = "default";
    protected static boolean isInitialized;
    protected static Map<String, DmnEngine> dmnEngines;
    protected static Map<String, DmnEngineInfo> dmnEngineInfosByName;
    protected static Map<String, DmnEngineInfo> dmnEngineInfosByResourceUrl;
    protected static List<DmnEngineInfo> dmnEngineInfos;

    public static synchronized void init() {
        if (!DmnEngines.isInitialized()) {
            if (dmnEngines == null) {
                dmnEngines = new HashMap<String, DmnEngine>();
            }
            ClassLoader classLoader = DmnEngines.class.getClassLoader();
            Enumeration<URL> resources = null;
            try {
                resources = classLoader.getResources("activiti.dmn.cfg.xml");
            }
            catch (IOException e) {
                throw new ActivitiDmnException("problem retrieving activiti.dmn.cfg.xml resources on the classpath: " + System.getProperty("java.class.path"), e);
            }
            HashSet<URL> configUrls = new HashSet<URL>();
            while (resources.hasMoreElements()) {
                configUrls.add(resources.nextElement());
            }
            for (URL resource : configUrls) {
                log.info("Initializing dmn engine using configuration '{}'", (Object)resource.toString());
                DmnEngines.initDmnEngineFromResource(resource);
            }
            DmnEngines.setInitialized(true);
        } else {
            log.info("DMN engines already initialized");
        }
    }

    public static void registerDmnEngine(DmnEngine dmnEngine) {
        dmnEngines.put(dmnEngine.getName(), dmnEngine);
    }

    public static void unregister(DmnEngine dmnEngine) {
        dmnEngines.remove(dmnEngine.getName());
    }

    private static DmnEngineInfo initDmnEngineFromResource(URL resourceUrl) {
        DmnEngineInfo dmnEngineInfo = dmnEngineInfosByResourceUrl.get(resourceUrl.toString());
        if (dmnEngineInfo != null) {
            dmnEngineInfos.remove(dmnEngineInfo);
            if (dmnEngineInfo.getException() == null) {
                String dmnEngineName = dmnEngineInfo.getName();
                dmnEngines.remove(dmnEngineName);
                dmnEngineInfosByName.remove(dmnEngineName);
            }
            dmnEngineInfosByResourceUrl.remove(dmnEngineInfo.getResourceUrl());
        }
        String resourceUrlString = resourceUrl.toString();
        try {
            log.info("initializing dmn engine for resource {}", (Object)resourceUrl);
            DmnEngine dmnEngine = DmnEngines.buildDmnEngine(resourceUrl);
            String dmnEngineName = dmnEngine.getName();
            log.info("initialised dmn engine {}", (Object)dmnEngineName);
            dmnEngineInfo = new DmnEngineInfo(dmnEngineName, resourceUrlString, null);
            dmnEngines.put(dmnEngineName, dmnEngine);
            dmnEngineInfosByName.put(dmnEngineName, dmnEngineInfo);
        }
        catch (Throwable e) {
            log.error("Exception while initializing dmn engine: {}", (Object)e.getMessage(), (Object)e);
            dmnEngineInfo = new DmnEngineInfo(null, resourceUrlString, DmnEngines.getExceptionString(e));
        }
        dmnEngineInfosByResourceUrl.put(resourceUrlString, dmnEngineInfo);
        dmnEngineInfos.add(dmnEngineInfo);
        return dmnEngineInfo;
    }

    private static String getExceptionString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    protected static DmnEngine buildDmnEngine(URL resource) {
        InputStream inputStream = null;
        try {
            inputStream = resource.openStream();
            DmnEngineConfiguration dmnEngineConfiguration = DmnEngineConfiguration.createDmnEngineConfigurationFromInputStream(inputStream);
            DmnEngine dmnEngine = dmnEngineConfiguration.buildDmnEngine();
            return dmnEngine;
        }
        catch (IOException e) {
            throw new ActivitiDmnException("couldn't open resource stream: " + e.getMessage(), e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public static List<DmnEngineInfo> getDmnEngineInfos() {
        return dmnEngineInfos;
    }

    public static DmnEngineInfo getDmnEngineInfo(String dmnEngineName) {
        return dmnEngineInfosByName.get(dmnEngineName);
    }

    public static DmnEngine getDefaultDmnEngine() {
        return DmnEngines.getDmnEngine(NAME_DEFAULT);
    }

    public static DmnEngine getDmnEngine(String dmnEngineName) {
        if (!DmnEngines.isInitialized()) {
            DmnEngines.init();
        }
        return dmnEngines.get(dmnEngineName);
    }

    public static DmnEngineInfo retry(String resourceUrl) {
        log.debug("retying initializing of resource {}", (Object)resourceUrl);
        try {
            return DmnEngines.initDmnEngineFromResource(new URL(resourceUrl));
        }
        catch (MalformedURLException e) {
            throw new ActivitiDmnException("invalid url: " + resourceUrl, e);
        }
    }

    public static Map<String, DmnEngine> getDmnEngines() {
        return dmnEngines;
    }

    public static synchronized void destroy() {
        if (DmnEngines.isInitialized()) {
            HashMap<String, DmnEngine> engines = new HashMap<String, DmnEngine>(dmnEngines);
            dmnEngines = new HashMap<String, DmnEngine>();
            for (String dmnEngineName : engines.keySet()) {
                DmnEngine dmnEngine = (DmnEngine)engines.get(dmnEngineName);
                try {
                    dmnEngine.close();
                }
                catch (Exception e) {
                    log.error("exception while closing {}", (Object)(dmnEngineName == null ? "the default dmn engine" : "dmn engine " + dmnEngineName), (Object)e);
                }
            }
            dmnEngineInfosByName.clear();
            dmnEngineInfosByResourceUrl.clear();
            dmnEngineInfos.clear();
            DmnEngines.setInitialized(false);
        }
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static void setInitialized(boolean isInitialized) {
        DmnEngines.isInitialized = isInitialized;
    }

    static {
        dmnEngines = new HashMap<String, DmnEngine>();
        dmnEngineInfosByName = new HashMap<String, DmnEngineInfo>();
        dmnEngineInfosByResourceUrl = new HashMap<String, DmnEngineInfo>();
        dmnEngineInfos = new ArrayList<DmnEngineInfo>();
    }
}

