/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.engine.impl.context;

import java.util.Stack;
import org.activiti.dmn.engine.DmnEngineConfiguration;
import org.activiti.dmn.engine.impl.interceptor.CommandContext;

public class Context {
    protected static ThreadLocal<Stack<CommandContext>> commandContextThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Stack<DmnEngineConfiguration>> dmnEngineConfigurationStackThreadLocal = new ThreadLocal();

    public static CommandContext getCommandContext() {
        Stack stack = Context.getStack(commandContextThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (CommandContext)stack.peek();
    }

    public static void setCommandContext(CommandContext commandContext) {
        Context.getStack(commandContextThreadLocal).push(commandContext);
    }

    public static void removeCommandContext() {
        Context.getStack(commandContextThreadLocal).pop();
    }

    public static DmnEngineConfiguration getDmnEngineConfiguration() {
        Stack stack = Context.getStack(dmnEngineConfigurationStackThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (DmnEngineConfiguration)stack.peek();
    }

    public static void setDmnEngineConfiguration(DmnEngineConfiguration dmnEngineConfiguration) {
        Context.getStack(dmnEngineConfigurationStackThreadLocal).push(dmnEngineConfiguration);
    }

    public static void removeDmnEngineConfiguration() {
        Context.getStack(dmnEngineConfigurationStackThreadLocal).pop();
    }

    protected static <T> Stack<T> getStack(ThreadLocal<Stack<T>> threadLocal) {
        Stack<Object> stack = threadLocal.get();
        if (stack == null) {
            stack = new Stack();
            threadLocal.set(stack);
        }
        return stack;
    }
}

