/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.engine.impl.deployer;

import org.activiti.dmn.engine.DmnEngineConfiguration;
import org.activiti.dmn.engine.impl.context.Context;
import org.activiti.dmn.engine.impl.deployer.ParsedDeployment;
import org.activiti.dmn.engine.impl.persistence.deploy.DecisionTableCacheEntry;
import org.activiti.dmn.engine.impl.persistence.deploy.DeploymentCache;
import org.activiti.dmn.engine.impl.persistence.entity.DecisionTableEntity;
import org.activiti.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;
import org.activiti.dmn.model.Decision;
import org.activiti.dmn.model.DmnDefinition;

public class CachingAndArtifactsManager {
    public void updateCachingAndArtifacts(ParsedDeployment parsedDeployment) {
        DmnEngineConfiguration dmnEngineConfiguration = Context.getDmnEngineConfiguration();
        DeploymentCache<DecisionTableCacheEntry> decisionTableCache = dmnEngineConfiguration.getDeploymentManager().getDecisionCache();
        DmnDeploymentEntity deployment = parsedDeployment.getDeployment();
        for (DecisionTableEntity decisionTable : parsedDeployment.getAllDecisionTables()) {
            DmnDefinition dmnDefinition = parsedDeployment.getDmnDefinitionForDecisionTable(decisionTable);
            Decision decision = parsedDeployment.getDecisionForDecisionTable(decisionTable);
            DecisionTableCacheEntry cacheEntry = new DecisionTableCacheEntry(decisionTable, dmnDefinition, decision);
            decisionTableCache.add(decisionTable.getId(), cacheEntry);
            deployment.addDeployedArtifact(decisionTable);
        }
    }
}

