/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.engine.impl.mvel;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.activiti.dmn.engine.impl.audit.DecisionExecutionAuditUtil;
import org.activiti.dmn.engine.impl.mvel.MvelExecutionContext;
import org.activiti.dmn.model.DmnDefinition;
import org.activiti.dmn.model.InputClause;
import org.activiti.dmn.model.OutputClause;
import org.mvel2.ParserContext;
import org.mvel2.integration.PropertyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MvelExecutionContextBuilder {
    private static final Logger logger = LoggerFactory.getLogger(MvelExecutionContextBuilder.class);

    public static MvelExecutionContext build(DmnDefinition definition, Map<String, Object> inputVariables, Map<String, Method> customExpressionFunctions, Map<Class<?>, PropertyHandler> propertyHandlers) {
        MvelExecutionContext executionContext = new MvelExecutionContext();
        executionContext.setAuditContainer(DecisionExecutionAuditUtil.initializeRuleExecutionAudit(definition, inputVariables));
        ParserContext parserContext = new ParserContext();
        if (customExpressionFunctions != null && !customExpressionFunctions.isEmpty()) {
            for (Map.Entry entry : customExpressionFunctions.entrySet()) {
                parserContext.addImport((String)entry.getKey(), (Method)entry.getValue());
            }
        }
        executionContext.setParserContext(parserContext);
        if (propertyHandlers != null) {
            for (Class clazz : propertyHandlers.keySet()) {
                executionContext.addPropertyHandler(clazz, propertyHandlers.get(clazz));
            }
        }
        MvelExecutionContextBuilder.preProcessInputVariables(definition, inputVariables);
        executionContext.setStackVariables(inputVariables);
        logger.debug("Execution Context created");
        return executionContext;
    }

    protected static void preProcessInputVariables(DmnDefinition definition, Map<String, Object> inputVariables) {
        if (inputVariables == null) {
            inputVariables = new HashMap<String, Object>();
        }
        for (InputClause inputClause : definition.getCurrentDecisionTable().getInputs()) {
            if (inputVariables.containsKey(inputClause.getInputExpression().getText()) || !"boolean".equals(inputClause.getInputExpression().getTypeRef())) continue;
            inputVariables.put(inputClause.getInputExpression().getText(), Boolean.FALSE);
        }
        for (OutputClause outputClause : definition.getCurrentDecisionTable().getOutputs()) {
            if (inputVariables.containsKey(outputClause.getName()) && inputVariables.get(outputClause.getName()) != null) continue;
            if ("number".equals(outputClause.getTypeRef())) {
                inputVariables.put(outputClause.getName(), 0.0);
                continue;
            }
            if ("date".equals(outputClause.getTypeRef())) {
                inputVariables.put(outputClause.getName(), new Date());
                continue;
            }
            inputVariables.put(outputClause.getName(), "");
        }
    }
}

