/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.engine.impl.parser;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.activiti.dmn.converter.util.InputStreamProvider;
import org.activiti.dmn.engine.ActivitiDmnException;
import org.activiti.dmn.engine.DmnEngineConfiguration;
import org.activiti.dmn.engine.impl.context.Context;
import org.activiti.dmn.engine.impl.io.InputStreamSource;
import org.activiti.dmn.engine.impl.io.ResourceStreamSource;
import org.activiti.dmn.engine.impl.io.StreamSource;
import org.activiti.dmn.engine.impl.io.StringStreamSource;
import org.activiti.dmn.engine.impl.io.UrlStreamSource;
import org.activiti.dmn.engine.impl.persistence.entity.DecisionTableEntity;
import org.activiti.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;
import org.activiti.dmn.model.Decision;
import org.activiti.dmn.model.DmnDefinition;
import org.activiti.dmn.xml.constants.DmnXMLConstants;
import org.activiti.dmn.xml.converter.DmnXMLConverter;
import org.activiti.dmn.xml.exception.DmnXMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmnParse
implements DmnXMLConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DmnParse.class);
    protected String name;
    protected boolean validateSchema = true;
    protected StreamSource streamSource;
    protected String sourceSystemId;
    protected DmnDefinition dmnDefinition;
    protected String targetNamespace;
    protected DmnDeploymentEntity deployment;
    protected List<DecisionTableEntity> decisionTables = new ArrayList<DecisionTableEntity>();

    public DmnParse deployment(DmnDeploymentEntity deployment) {
        this.deployment = deployment;
        return this;
    }

    public DmnParse execute(DmnEngineConfiguration dmnEngineConfig) {
        try {
            DmnXMLConverter converter = new DmnXMLConverter();
            boolean enableSafeDmnXml = dmnEngineConfig.isEnableSafeDmnXml();
            String encoding = dmnEngineConfig.getXmlEncoding();
            this.dmnDefinition = encoding != null ? converter.convertToDmnModel((InputStreamProvider)this.streamSource, this.validateSchema, enableSafeDmnXml, encoding) : converter.convertToDmnModel((InputStreamProvider)this.streamSource, this.validateSchema, enableSafeDmnXml);
            if (this.dmnDefinition != null && this.dmnDefinition.getDrgElements() != null) {
                for (Decision decision : this.dmnDefinition.getDrgElements()) {
                    DecisionTableEntity decisionTableEntity = (DecisionTableEntity)Context.getDmnEngineConfiguration().getDecisionTableEntityManager().create();
                    decisionTableEntity.setKey(decision.getId());
                    decisionTableEntity.setName(decision.getName());
                    decisionTableEntity.setResourceName(this.name);
                    decisionTableEntity.setDeploymentId(this.deployment.getId());
                    decisionTableEntity.setParentDeploymentId(this.deployment.getParentDeploymentId());
                    decisionTableEntity.setDescription(decision.getDescription());
                    this.decisionTables.add(decisionTableEntity);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof ActivitiDmnException) {
                throw (ActivitiDmnException)e;
            }
            if (e instanceof DmnXMLException) {
                throw (DmnXMLException)e;
            }
            throw new ActivitiDmnException("Error parsing XML", e);
        }
        return this;
    }

    public DmnParse name(String name) {
        this.name = name;
        return this;
    }

    public DmnParse sourceInputStream(InputStream inputStream) {
        if (this.name == null) {
            this.name("inputStream");
        }
        this.setStreamSource(new InputStreamSource(inputStream));
        return this;
    }

    public DmnParse sourceUrl(URL url) {
        if (this.name == null) {
            this.name(url.toString());
        }
        this.setStreamSource(new UrlStreamSource(url));
        return this;
    }

    public DmnParse sourceUrl(String url) {
        try {
            return this.sourceUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new ActivitiDmnException("malformed url: " + url, e);
        }
    }

    public DmnParse sourceResource(String resource) {
        if (this.name == null) {
            this.name(resource);
        }
        this.setStreamSource(new ResourceStreamSource(resource));
        return this;
    }

    public DmnParse sourceString(String string) {
        if (this.name == null) {
            this.name("string");
        }
        this.setStreamSource(new StringStreamSource(string));
        return this;
    }

    protected void setStreamSource(StreamSource streamSource) {
        if (this.streamSource != null) {
            throw new ActivitiDmnException("invalid: multiple sources " + this.streamSource + " and " + streamSource);
        }
        this.streamSource = streamSource;
    }

    public String getSourceSystemId() {
        return this.sourceSystemId;
    }

    public DmnParse setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
        return this;
    }

    public boolean isValidateSchema() {
        return this.validateSchema;
    }

    public void setValidateSchema(boolean validateSchema) {
        this.validateSchema = validateSchema;
    }

    public List<DecisionTableEntity> getDecisionTables() {
        return this.decisionTables;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public DmnDeploymentEntity getDeployment() {
        return this.deployment;
    }

    public void setDeployment(DmnDeploymentEntity deployment) {
        this.deployment = deployment;
    }

    public DmnDefinition getDmnDefinition() {
        return this.dmnDefinition;
    }

    public void setDmnDefinition(DmnDefinition dmnDefinition) {
        this.dmnDefinition = dmnDefinition;
    }
}

