/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.engine.impl.persistence.entity;

import java.util.List;
import java.util.Map;
import org.activiti.dmn.api.DecisionTable;
import org.activiti.dmn.api.DmnDeployment;
import org.activiti.dmn.engine.DmnEngineConfiguration;
import org.activiti.dmn.engine.impl.DmnDeploymentQueryImpl;
import org.activiti.dmn.engine.impl.Page;
import org.activiti.dmn.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.dmn.engine.impl.persistence.entity.DecisionTableEntity;
import org.activiti.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;
import org.activiti.dmn.engine.impl.persistence.entity.DmnDeploymentEntityManager;
import org.activiti.dmn.engine.impl.persistence.entity.ResourceEntity;
import org.activiti.dmn.engine.impl.persistence.entity.data.DataManager;
import org.activiti.dmn.engine.impl.persistence.entity.data.DmnDeploymentDataManager;

public class DmnDeploymentEntityManagerImpl
extends AbstractEntityManager<DmnDeploymentEntity>
implements DmnDeploymentEntityManager {
    protected DmnDeploymentDataManager deploymentDataManager;

    public DmnDeploymentEntityManagerImpl(DmnEngineConfiguration dmnEngineConfiguration, DmnDeploymentDataManager deploymentDataManager) {
        super(dmnEngineConfiguration);
        this.deploymentDataManager = deploymentDataManager;
    }

    @Override
    protected DataManager<DmnDeploymentEntity> getDataManager() {
        return this.deploymentDataManager;
    }

    @Override
    public void insert(DmnDeploymentEntity deployment) {
        super.insert(deployment);
        for (ResourceEntity resource : deployment.getResources().values()) {
            resource.setDeploymentId(deployment.getId());
            this.getResourceEntityManager().insert(resource);
        }
    }

    @Override
    public void deleteDeployment(String deploymentId) {
        this.deleteDecisionTablesForDeployment(deploymentId);
        this.getResourceEntityManager().deleteResourcesByDeploymentId(deploymentId);
        this.delete(this.findById(deploymentId));
    }

    protected void deleteDecisionTablesForDeployment(String deploymentId) {
        this.getDecisionTableEntityManager().deleteDecisionTablesByDeploymentId(deploymentId);
    }

    protected DecisionTableEntity findLatestDecisionTable(DecisionTable decisionTable) {
        DecisionTableEntity latestDecisionTable = null;
        latestDecisionTable = decisionTable.getTenantId() != null && !"".equals(decisionTable.getTenantId()) ? this.getDecisionTableEntityManager().findLatestDecisionTableByKeyAndTenantId(decisionTable.getKey(), decisionTable.getTenantId()) : this.getDecisionTableEntityManager().findLatestDecisionTableByKey(decisionTable.getKey());
        return latestDecisionTable;
    }

    @Override
    public DmnDeploymentEntity findLatestDeploymentByName(String deploymentName) {
        return this.deploymentDataManager.findLatestDeploymentByName(deploymentName);
    }

    @Override
    public long findDeploymentCountByQueryCriteria(DmnDeploymentQueryImpl deploymentQuery) {
        return this.deploymentDataManager.findDeploymentCountByQueryCriteria(deploymentQuery);
    }

    @Override
    public List<DmnDeployment> findDeploymentsByQueryCriteria(DmnDeploymentQueryImpl deploymentQuery, Page page) {
        return this.deploymentDataManager.findDeploymentsByQueryCriteria(deploymentQuery, page);
    }

    @Override
    public List<String> getDeploymentResourceNames(String deploymentId) {
        return this.deploymentDataManager.getDeploymentResourceNames(deploymentId);
    }

    @Override
    public List<DmnDeployment> findDeploymentsByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.deploymentDataManager.findDeploymentsByNativeQuery(parameterMap, firstResult, maxResults);
    }

    @Override
    public long findDeploymentCountByNativeQuery(Map<String, Object> parameterMap) {
        return this.deploymentDataManager.findDeploymentCountByNativeQuery(parameterMap);
    }

    public DmnDeploymentDataManager getDeploymentDataManager() {
        return this.deploymentDataManager;
    }

    public void setDeploymentDataManager(DmnDeploymentDataManager deploymentDataManager) {
        this.deploymentDataManager = deploymentDataManager;
    }
}

