/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.engine.impl.persistence.entity.data;

import java.util.ArrayList;
import java.util.List;
import org.activiti.dmn.engine.DmnEngineConfiguration;
import org.activiti.dmn.engine.impl.db.DbSqlSession;
import org.activiti.dmn.engine.impl.db.Entity;
import org.activiti.dmn.engine.impl.persistence.AbstractManager;
import org.activiti.dmn.engine.impl.persistence.entity.data.DataManager;

public abstract class AbstractDataManager<EntityImpl extends Entity>
extends AbstractManager
implements DataManager<EntityImpl> {
    public AbstractDataManager(DmnEngineConfiguration dmnEngineConfiguration) {
        super(dmnEngineConfiguration);
    }

    public abstract Class<? extends EntityImpl> getManagedEntityClass();

    public List<Class<? extends EntityImpl>> getManagedEntitySubClasses() {
        return null;
    }

    protected DbSqlSession getDbSqlSession() {
        return this.getSession(DbSqlSession.class);
    }

    @Override
    public EntityImpl findById(String entityId) {
        if (entityId == null) {
            return null;
        }
        return this.getDbSqlSession().selectById(this.getManagedEntityClass(), entityId);
    }

    @Override
    public void insert(EntityImpl entity) {
        this.getDbSqlSession().insert((Entity)entity);
    }

    @Override
    public EntityImpl update(EntityImpl entity) {
        this.getDbSqlSession().update((Entity)entity);
        return entity;
    }

    @Override
    public void delete(String id) {
        EntityImpl entity = this.findById(id);
        this.delete(entity);
    }

    @Override
    public void delete(EntityImpl entity) {
        this.getDbSqlSession().delete((Entity)entity);
    }

    protected EntityImpl findByQuery(String selectQuery, Object parameter) {
        return (EntityImpl)((Entity)this.getDbSqlSession().selectOne(selectQuery, parameter));
    }

    protected List<EntityImpl> getList(String dbQueryName, Object parameter) {
        List result = this.getDbSqlSession().selectList(dbQueryName, parameter);
        return new ArrayList(result);
    }
}

