/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.engine.impl.util;

import org.activiti.dmn.engine.ActivitiDmnException;
import org.activiti.dmn.engine.impl.context.Context;
import org.activiti.dmn.engine.impl.persistence.deploy.DecisionTableCacheEntry;
import org.activiti.dmn.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.dmn.engine.impl.persistence.entity.DecisionTableEntity;
import org.activiti.dmn.engine.impl.persistence.entity.DecisionTableEntityManager;
import org.activiti.dmn.model.Decision;
import org.activiti.dmn.model.DmnDefinition;

public class DecisionTableUtil {
    public static DecisionTableEntity getDecisionTableEntity(String decisionTableId) {
        return DecisionTableUtil.getDecisionTableEntity(decisionTableId, false);
    }

    public static DecisionTableEntity getDecisionTableEntity(String decisionTableId, boolean checkCacheOnly) {
        if (checkCacheOnly) {
            DecisionTableCacheEntry cacheEntry = Context.getDmnEngineConfiguration().getDecisionCache().get(decisionTableId);
            if (cacheEntry != null) {
                return cacheEntry.getDecisionTableEntity();
            }
            return null;
        }
        return Context.getDmnEngineConfiguration().getDeploymentManager().findDeployedDecisionById(decisionTableId);
    }

    public static Decision getDecision(String decisionTableId) {
        DeploymentManager deploymentManager = Context.getDmnEngineConfiguration().getDeploymentManager();
        DecisionTableEntity decisionTableEntity = deploymentManager.findDeployedDecisionById(decisionTableId);
        return deploymentManager.resolveDecisionTable(decisionTableEntity).getDecision();
    }

    public static DmnDefinition getDmnDefinition(String decisionTableId) {
        DeploymentManager deploymentManager = Context.getDmnEngineConfiguration().getDeploymentManager();
        DecisionTableEntity decisionTableEntity = deploymentManager.findDeployedDecisionById(decisionTableId);
        return deploymentManager.resolveDecisionTable(decisionTableEntity).getDmnDefinition();
    }

    public static DmnDefinition getDmnDefinitionFromCache(String decisionTableId) {
        DecisionTableCacheEntry cacheEntry = Context.getDmnEngineConfiguration().getDecisionCache().get(decisionTableId);
        if (cacheEntry != null) {
            return cacheEntry.getDmnDefinition();
        }
        return null;
    }

    public static DecisionTableEntity getDecisionTableFromDatabase(String decisionTableId) {
        DecisionTableEntityManager decisionTableEntityManager = Context.getDmnEngineConfiguration().getDecisionTableEntityManager();
        DecisionTableEntity decisionTable = (DecisionTableEntity)decisionTableEntityManager.findById(decisionTableId);
        if (decisionTable == null) {
            throw new ActivitiDmnException("No decision table found with id " + decisionTableId);
        }
        return decisionTable;
    }
}

