/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.engine.test;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.dmn.api.DmnDeploymentBuilder;
import org.activiti.dmn.api.DmnRepositoryService;
import org.activiti.dmn.engine.ActivitiDmnObjectNotFoundException;
import org.activiti.dmn.engine.DmnEngine;
import org.activiti.dmn.engine.DmnEngineConfiguration;
import org.activiti.dmn.engine.impl.deployer.ParsedDeploymentBuilder;
import org.activiti.dmn.engine.test.DmnDeploymentAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DmnTestHelper {
    private static Logger log = LoggerFactory.getLogger(DmnTestHelper.class);
    public static final String EMPTY_LINE = "\n";
    static Map<String, DmnEngine> dmnEngines = new HashMap<String, DmnEngine>();

    public static String annotationDeploymentSetUp(DmnEngine dmnEngine, Class<?> testClass, String methodName) {
        String deploymentId = null;
        Method method = null;
        try {
            method = testClass.getMethod(methodName, null);
        }
        catch (Exception e) {
            log.warn("Could not get method by reflection. This could happen if you are using @Parameters in combination with annotations.", (Throwable)e);
            return null;
        }
        DmnDeploymentAnnotation deploymentAnnotation = method.getAnnotation(DmnDeploymentAnnotation.class);
        if (deploymentAnnotation != null) {
            log.debug("annotation @Deployment creates deployment for {}.{}", (Object)testClass.getSimpleName(), (Object)methodName);
            String[] resources = deploymentAnnotation.resources();
            if (resources.length == 0) {
                String name = method.getName();
                String resource = DmnTestHelper.getDmnDecisionResource(testClass, name);
                resources = new String[]{resource};
            }
            DmnDeploymentBuilder deploymentBuilder = dmnEngine.getDmnRepositoryService().createDeployment().name(testClass.getSimpleName() + "." + methodName);
            for (String resource : resources) {
                deploymentBuilder.addClasspathResource(resource);
            }
            deploymentId = deploymentBuilder.deploy().getId();
        }
        return deploymentId;
    }

    public static void annotationDeploymentTearDown(DmnEngine dmnEngine, String deploymentId, Class<?> testClass, String methodName) {
        log.debug("annotation @Deployment deletes deployment for {}.{}", (Object)testClass.getSimpleName(), (Object)methodName);
        if (deploymentId != null) {
            try {
                dmnEngine.getDmnRepositoryService().deleteDeployment(deploymentId);
            }
            catch (ActivitiDmnObjectNotFoundException activitiDmnObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    public static String getDmnDecisionResource(Class<?> type, String name) {
        for (String suffix : ParsedDeploymentBuilder.DMN_RESOURCE_SUFFIXES) {
            String resource = type.getName().replace('.', '/') + "." + name + "." + suffix;
            InputStream inputStream = DmnTestHelper.class.getClassLoader().getResourceAsStream(resource);
            if (inputStream == null) continue;
            return resource;
        }
        return type.getName().replace('.', '/') + "." + name + "." + ParsedDeploymentBuilder.DMN_RESOURCE_SUFFIXES[0];
    }

    public static DmnEngine getDmnEngine(String configurationResource) {
        DmnEngine dmnEngine = dmnEngines.get(configurationResource);
        if (dmnEngine == null) {
            log.debug("==== BUILDING DMN ENGINE ========================================================================");
            dmnEngine = DmnEngineConfiguration.createDmnEngineConfigurationFromResource(configurationResource).setDatabaseSchemaUpdate("create-drop").buildDmnEngine();
            log.debug("==== DMN ENGINE CREATED =========================================================================");
            dmnEngines.put(configurationResource, dmnEngine);
        }
        return dmnEngine;
    }

    public static void closeDmnEngines() {
        for (DmnEngine dmnEngine : dmnEngines.values()) {
            dmnEngine.close();
        }
        dmnEngines.clear();
    }

    public static void assertAndEnsureCleanDb(DmnEngine dmnEngine) {
        log.debug("verifying that db is clean after test");
        DmnRepositoryService repositoryService = dmnEngine.getDmnEngineConfiguration().getDmnRepositoryService();
        List deployments = repositoryService.createDeploymentQuery().list();
        if (deployments != null && !deployments.isEmpty()) {
            throw new AssertionError((Object)"DmnDeployments is not empty");
        }
    }
}

