/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.converter.child;

import javax.xml.stream.XMLStreamReader;
import org.activiti.dmn.model.DecisionTable;
import org.activiti.dmn.model.DmnElement;
import org.activiti.dmn.xml.constants.DmnXMLConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseChildElementParser
implements DmnXMLConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseChildElementParser.class);

    public abstract String getElementName();

    public abstract void parseChildElement(XMLStreamReader var1, DmnElement var2, DecisionTable var3) throws Exception;

    protected void parseChildElements(XMLStreamReader xtr, DmnElement parentElement, DecisionTable decisionTable, BaseChildElementParser parser) throws Exception {
        boolean readyWithChildElements = false;
        while (!readyWithChildElements && xtr.hasNext()) {
            xtr.next();
            if (xtr.isStartElement()) {
                if (!parser.getElementName().equals(xtr.getLocalName())) continue;
                parser.parseChildElement(xtr, parentElement, decisionTable);
                continue;
            }
            if (!xtr.isEndElement() || !this.getElementName().equalsIgnoreCase(xtr.getLocalName())) continue;
            readyWithChildElements = true;
        }
    }

    public boolean accepts(DmnElement element) {
        return element != null;
    }
}

