/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.xml.converter;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.dmn.converter.child.BaseChildElementParser;
import org.activiti.dmn.converter.util.DmnXMLUtil;
import org.activiti.dmn.model.DecisionRule;
import org.activiti.dmn.model.DecisionTable;
import org.activiti.dmn.model.DmnDefinition;
import org.activiti.dmn.model.DmnElement;
import org.activiti.dmn.model.InputClause;
import org.activiti.dmn.model.ItemDefinition;
import org.activiti.dmn.model.OutputClause;
import org.activiti.dmn.xml.constants.DmnXMLConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDmnXMLConverter
implements DmnXMLConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseDmnXMLConverter.class);

    public void convertToDmnModel(XMLStreamReader xtr, DmnDefinition model, DecisionTable decisionTable) throws Exception {
        String elementId = xtr.getAttributeValue(null, "id");
        String elementName = xtr.getAttributeValue(null, "name");
        DmnElement parsedElement = this.convertXMLToElement(xtr, model, decisionTable);
        if (parsedElement instanceof InputClause) {
            decisionTable.addInput((InputClause)parsedElement);
        } else if (parsedElement instanceof OutputClause) {
            decisionTable.addOutput((OutputClause)parsedElement);
        } else if (parsedElement instanceof DecisionRule) {
            decisionTable.addRule((DecisionRule)parsedElement);
        } else if (parsedElement instanceof ItemDefinition) {
            model.addItemDefinition((ItemDefinition)parsedElement);
        }
    }

    public void convertToXML(XMLStreamWriter xtw, DmnElement baseElement, DmnDefinition model) throws Exception {
        xtw.writeStartElement(this.getXMLElementName());
        boolean didWriteExtensionStartElement = false;
        this.writeDefaultAttribute("id", baseElement.getId(), xtw);
        this.writeAdditionalAttributes(baseElement, model, xtw);
        this.writeAdditionalChildElements(baseElement, model, xtw);
        xtw.writeEndElement();
    }

    protected abstract Class<? extends DmnElement> getDmnElementType();

    protected abstract DmnElement convertXMLToElement(XMLStreamReader var1, DmnDefinition var2, DecisionTable var3) throws Exception;

    protected abstract String getXMLElementName();

    protected abstract void writeAdditionalAttributes(DmnElement var1, DmnDefinition var2, XMLStreamWriter var3) throws Exception;

    protected abstract void writeAdditionalChildElements(DmnElement var1, DmnDefinition var2, XMLStreamWriter var3) throws Exception;

    protected void parseChildElements(String elementName, DmnElement parentElement, DecisionTable decisionTable, XMLStreamReader xtr) throws Exception {
        this.parseChildElements(elementName, parentElement, null, decisionTable, xtr);
    }

    protected void parseChildElements(String elementName, DmnElement parentElement, Map<String, BaseChildElementParser> additionalParsers, DecisionTable decisionTable, XMLStreamReader xtr) throws Exception {
        HashMap<String, BaseChildElementParser> childParsers = new HashMap<String, BaseChildElementParser>();
        if (additionalParsers != null) {
            childParsers.putAll(additionalParsers);
        }
        DmnXMLUtil.parseChildElements(elementName, parentElement, xtr, childParsers, decisionTable);
    }

    protected void writeDefaultAttribute(String attributeName, String value, XMLStreamWriter xtw) throws Exception {
        DmnXMLUtil.writeDefaultAttribute(attributeName, value, xtw);
    }

    protected void writeQualifiedAttribute(String attributeName, String value, XMLStreamWriter xtw) throws Exception {
        DmnXMLUtil.writeQualifiedAttribute(attributeName, value, xtw);
    }
}

