/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.cmd.NeedsActiveTaskCmd;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

public class AddIdentityLinkCmd
extends NeedsActiveTaskCmd<Void> {
    private static final long serialVersionUID = 1L;
    protected String userId;
    protected String groupId;
    protected String type;

    public AddIdentityLinkCmd(String taskId, String userId, String groupId, String type) {
        super(taskId);
        this.validateParams(userId, groupId, type, taskId);
        this.taskId = taskId;
        this.userId = userId;
        this.groupId = groupId;
        this.type = type;
    }

    protected void validateParams(String userId, String groupId, String type, String taskId) {
        if (taskId == null) {
            throw new ActivitiIllegalArgumentException("taskId is null");
        }
        if (type == null) {
            throw new ActivitiIllegalArgumentException("type is required when adding a new task identity link");
        }
        if ("assignee".equals(type)) {
            if (groupId != null) {
                throw new ActivitiIllegalArgumentException("Incompatible usage: cannot use ASSIGNEE together with a groupId");
            }
        } else if (userId == null && groupId == null) {
            throw new ActivitiIllegalArgumentException("userId and groupId cannot both be null");
        }
    }

    @Override
    protected Void execute(CommandContext commandContext, TaskEntity task) {
        boolean assignedToNoOne = false;
        if ("assignee".equals(this.type)) {
            task.setAssignee(this.userId);
            assignedToNoOne = this.userId == null;
        } else if ("owner".equals(this.type)) {
            task.setOwner(this.userId);
        } else {
            task.addIdentityLink(this.userId, this.groupId, this.type);
        }
        if (assignedToNoOne) {
            commandContext.getHistoryManager().createIdentityLinkComment(this.taskId, this.userId, this.groupId, this.type, false, true);
        } else {
            commandContext.getHistoryManager().createIdentityLinkComment(this.taskId, this.userId, this.groupId, this.type, true);
        }
        return null;
    }
}

