/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.Date;
import org.activiti.engine.impl.calendar.BusinessCalendar;
import org.activiti.engine.impl.calendar.CycleBusinessCalendar;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerEntity
extends JobEntity {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(TimerEntity.class);
    protected String repeat;

    public TimerEntity() {
    }

    public TimerEntity(TimerDeclarationImpl timerDeclaration) {
        this.jobHandlerType = timerDeclaration.getJobHandlerType();
        this.jobHandlerConfiguration = timerDeclaration.getJobHandlerConfiguration();
        this.isExclusive = timerDeclaration.isExclusive();
        this.repeat = timerDeclaration.getRepeat();
        this.retries = timerDeclaration.getRetries();
    }

    private TimerEntity(TimerEntity te) {
        this.jobHandlerConfiguration = te.jobHandlerConfiguration;
        this.jobHandlerType = te.jobHandlerType;
        this.isExclusive = te.isExclusive;
        this.repeat = te.repeat;
        this.retries = te.retries;
        this.executionId = te.executionId;
        this.processInstanceId = te.processInstanceId;
    }

    @Override
    public void execute(CommandContext commandContext) {
        super.execute(commandContext);
        if (this.repeat == null) {
            if (log.isDebugEnabled()) {
                log.debug("Timer {} fired. Deleting timer.", (Object)this.getId());
            }
            this.delete();
        } else {
            this.delete();
            Date newTimer = this.calculateRepeat();
            if (newTimer != null) {
                TimerEntity te = new TimerEntity(this);
                te.setDuedate(newTimer);
                Context.getCommandContext().getJobEntityManager().schedule(te);
            }
        }
    }

    private Date calculateRepeat() {
        BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(CycleBusinessCalendar.NAME);
        return businessCalendar.resolveDuedate(this.repeat);
    }

    public String getRepeat() {
        return this.repeat;
    }

    public void setRepeat(String repeat) {
        this.repeat = repeat;
    }
}

