/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.diagram;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.activiti.bpmn.model.AssociationDirection;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.util.IoUtil;
import org.activiti.engine.impl.util.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDiagramCanvas {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ProcessDiagramCanvas.class);
    protected static final int ARROW_WIDTH = 5;
    protected static final int CONDITIONAL_INDICATOR_WIDTH = 16;
    protected static final int DEFAULT_INDICATOR_WIDTH = 10;
    protected static final int MARKER_WIDTH = 12;
    protected static final int FONT_SIZE = 11;
    protected static final int FONT_SPACING = 2;
    protected static final int TEXT_PADDING = 3;
    protected static final int ANNOTATION_TEXT_PADDING = 7;
    protected static final int LINE_HEIGHT = 13;
    protected static Color TASK_BOX_COLOR = new Color(255, 255, 204);
    protected static Color SUBPROCESS_BOX_COLOR = new Color(250, 251, 252);
    protected static Color BOUNDARY_EVENT_COLOR = new Color(255, 255, 255);
    protected static Color CONDITIONAL_INDICATOR_COLOR = new Color(255, 255, 255);
    protected static Color HIGHLIGHT_COLOR = Color.RED;
    protected static Color LABEL_COLOR = new Color(112, 146, 190);
    protected static Font LABEL_FONT = null;
    protected static Font ANNOTATION_FONT = new Font("Arial", 0, 11);
    protected static Font TASK_FONT = new Font("Arial", 0, 11);
    protected static Stroke THICK_TASK_BORDER_STROKE = new BasicStroke(3.0f);
    protected static Stroke GATEWAY_TYPE_STROKE = new BasicStroke(3.0f);
    protected static Stroke END_EVENT_STROKE = new BasicStroke(3.0f);
    protected static Stroke MULTI_INSTANCE_STROKE = new BasicStroke(1.3f);
    protected static Stroke EVENT_SUBPROCESS_STROKE = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{1.0f}, 0.0f);
    protected static Stroke INTERRUPTING_EVENT_STROKE = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{4.0f, 3.0f}, 0.0f);
    protected static Stroke HIGHLIGHT_FLOW_STROKE = new BasicStroke(1.3f);
    protected static Stroke ANNOTATION_STROKE = new BasicStroke(2.0f);
    protected static Stroke ASSOCIATION_STROKE = new BasicStroke(2.0f, 0, 0, 1.0f, new float[]{2.0f, 2.0f}, 0.0f);
    protected static int ICON_SIZE = 16;
    protected static int ICON_PADDING = 3;
    protected static Image USERTASK_IMAGE;
    protected static Image SCRIPTTASK_IMAGE;
    protected static Image SERVICETASK_IMAGE;
    protected static Image RECEIVETASK_IMAGE;
    protected static Image SENDTASK_IMAGE;
    protected static Image MANUALTASK_IMAGE;
    protected static Image BUSINESS_RULE_TASK_IMAGE;
    protected static Image TIMER_IMAGE;
    protected static Image ERROR_THROW_IMAGE;
    protected static Image ERROR_CATCH_IMAGE;
    protected static Image SIGNAL_CATCH_IMAGE;
    protected static Image SIGNAL_THROW_IMAGE;
    protected int canvasWidth = -1;
    protected int canvasHeight = -1;
    protected int minX = -1;
    protected int minY = -1;
    protected BufferedImage processDiagram;
    protected Graphics2D g;
    protected FontMetrics fontMetrics;
    protected boolean closed;
    protected String activityFontName = "Arial";
    protected String labelFontName = "Arial";

    public ProcessDiagramCanvas(int width, int height) {
        this.canvasWidth = width;
        this.canvasHeight = height;
        if (Context.getProcessEngineConfiguration() != null) {
            this.activityFontName = Context.getProcessEngineConfiguration().getActivityFontName();
        }
        if (Context.getProcessEngineConfiguration() != null) {
            this.labelFontName = Context.getProcessEngineConfiguration().getLabelFontName();
        }
        this.processDiagram = new BufferedImage(width, height, 2);
        this.g = this.processDiagram.createGraphics();
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g.setPaint(Color.black);
        Font font = new Font(this.activityFontName, 1, 11);
        this.g.setFont(font);
        this.fontMetrics = this.g.getFontMetrics();
        LABEL_FONT = new Font(this.labelFontName, 2, 10);
    }

    public ProcessDiagramCanvas(int width, int height, int minX, int minY) {
        this(width, height);
        this.minX = minX;
        this.minY = minY;
    }

    public InputStream generateImage(String imageType) {
        if (this.closed) {
            throw new ActivitiException("ProcessDiagramGenerator already closed");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.minX = this.minX <= 5 ? 5 : this.minX;
            this.minY = this.minY <= 5 ? 5 : this.minY;
            BufferedImage imageToSerialize = this.processDiagram;
            if (this.minX >= 0 && this.minY >= 0) {
                imageToSerialize = this.processDiagram.getSubimage(this.minX - 5, this.minY - 5, this.canvasWidth - this.minX + 5, this.canvasHeight - this.minY + 5);
            }
            ImageIO.write((RenderedImage)imageToSerialize, imageType, out);
        }
        catch (IOException e) {
            throw new ActivitiException("Error while generating process image", e);
        }
        finally {
            IoUtil.closeSilently(out);
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    public void close() {
        this.g.dispose();
        this.closed = true;
    }

    public void drawNoneStartEvent(int x, int y, int width, int height) {
        this.drawStartEvent(x, y, width, height, null);
    }

    public void drawTimerStartEvent(int x, int y, int width, int height) {
        this.drawStartEvent(x, y, width, height, TIMER_IMAGE);
    }

    public void drawStartEvent(int x, int y, int width, int height, Image image) {
        this.g.draw(new Ellipse2D.Double(x, y, width, height));
        if (image != null) {
            this.g.drawImage(image, x, y, width, height, null);
        }
    }

    public void drawNoneEndEvent(int x, int y, int width, int height) {
        Stroke originalStroke = this.g.getStroke();
        this.g.setStroke(END_EVENT_STROKE);
        this.g.draw(new Ellipse2D.Double(x, y, width, height));
        this.g.setStroke(originalStroke);
    }

    public void drawErrorEndEvent(String name, int x, int y, int width, int height) {
        this.drawErrorEndEvent(x, y, width, height);
        this.drawLabel(name, x, y, width, height);
    }

    public void drawErrorEndEvent(int x, int y, int width, int height) {
        this.drawNoneEndEvent(x, y, width, height);
        this.g.drawImage(ERROR_THROW_IMAGE, x + 3, y + 3, width - 6, height - 6, null);
    }

    public void drawErrorStartEvent(int x, int y, int width, int height) {
        this.drawNoneStartEvent(x, y, width, height);
        this.g.drawImage(ERROR_CATCH_IMAGE, x + 3, y + 3, width - 6, height - 6, null);
    }

    public void drawCatchingEvent(int x, int y, int width, int height, boolean isInterrupting, Image image) {
        Ellipse2D.Double outerCircle = new Ellipse2D.Double(x, y, width, height);
        int innerCircleX = x + 3;
        int innerCircleY = y + 3;
        int innerCircleWidth = width - 6;
        int innerCircleHeight = height - 6;
        Ellipse2D.Double innerCircle = new Ellipse2D.Double(innerCircleX, innerCircleY, innerCircleWidth, innerCircleHeight);
        Paint originalPaint = this.g.getPaint();
        Stroke originalStroke = this.g.getStroke();
        this.g.setPaint(BOUNDARY_EVENT_COLOR);
        this.g.fill(outerCircle);
        this.g.setPaint(originalPaint);
        if (isInterrupting) {
            this.g.setStroke(INTERRUPTING_EVENT_STROKE);
        }
        this.g.draw(outerCircle);
        this.g.setStroke(originalStroke);
        this.g.draw(innerCircle);
        this.g.drawImage(image, innerCircleX, innerCircleY, innerCircleWidth, innerCircleHeight, null);
    }

    public void drawCatchingTimerEvent(String name, int x, int y, int width, int height, boolean isInterrupting) {
        this.drawCatchingTimerEvent(x, y, width, height, isInterrupting);
        this.drawLabel(name, x, y, width, height);
    }

    public void drawCatchingTimerEvent(int x, int y, int width, int height, boolean isInterrupting) {
        this.drawCatchingEvent(x, y, width, height, isInterrupting, TIMER_IMAGE);
    }

    public void drawCatchingErrorEvent(String name, int x, int y, int width, int height, boolean isInterrupting) {
        this.drawCatchingErrorEvent(x, y, width, height, isInterrupting);
        this.drawLabel(name, x, y, width, height);
    }

    public void drawCatchingErrorEvent(int x, int y, int width, int height, boolean isInterrupting) {
        this.drawCatchingEvent(x, y, width, height, isInterrupting, ERROR_CATCH_IMAGE);
    }

    public void drawCatchingSignalEvent(String name, int x, int y, int width, int height, boolean isInterrupting) {
        this.drawCatchingSignalEvent(x, y, width, height, isInterrupting);
        this.drawLabel(name, x, y, width, height);
    }

    public void drawCatchingSignalEvent(int x, int y, int width, int height, boolean isInterrupting) {
        this.drawCatchingEvent(x, y, width, height, isInterrupting, SIGNAL_CATCH_IMAGE);
    }

    public void drawThrowingSignalEvent(int x, int y, int width, int height) {
        this.drawCatchingEvent(x, y, width, height, false, SIGNAL_THROW_IMAGE);
    }

    public void drawThrowingNoneEvent(int x, int y, int width, int height) {
        this.drawCatchingEvent(x, y, width, height, false, null);
    }

    public void drawSequenceflow(int srcX, int srcY, int targetX, int targetY, boolean conditional) {
        this.drawSequenceflow(srcX, srcY, targetX, targetY, conditional, false);
    }

    public void drawSequenceflow(int srcX, int srcY, int targetX, int targetY, boolean conditional, boolean highLighted) {
        Paint originalPaint = this.g.getPaint();
        if (highLighted) {
            this.g.setPaint(HIGHLIGHT_COLOR);
        }
        Line2D.Double line = new Line2D.Double(srcX, srcY, targetX, targetY);
        this.g.draw(line);
        this.drawArrowHead(line);
        if (conditional) {
            this.drawConditionalSequenceFlowIndicator(line);
        }
        if (highLighted) {
            this.g.setPaint(originalPaint);
        }
    }

    public void drawAssociation(int[] xPoints, int[] yPoints, AssociationDirection associationDirection, boolean highLighted) {
        boolean conditional = false;
        boolean isDefault = false;
        this.drawConnection(xPoints, yPoints, conditional, isDefault, "association", associationDirection, highLighted);
    }

    public void drawSequenceflow(int[] xPoints, int[] yPoints, boolean conditional, boolean isDefault, boolean highLighted) {
        this.drawConnection(xPoints, yPoints, conditional, isDefault, "sequenceFlow", AssociationDirection.ONE, highLighted);
    }

    public void drawConnection(int[] xPoints, int[] yPoints, boolean conditional, boolean isDefault, String connectionType, AssociationDirection associationDirection, boolean highLighted) {
        Paint originalPaint = this.g.getPaint();
        Stroke originalStroke = this.g.getStroke();
        if (connectionType.equals("association")) {
            this.g.setStroke(ASSOCIATION_STROKE);
        } else if (highLighted) {
            this.g.setPaint(HIGHLIGHT_COLOR);
            this.g.setStroke(HIGHLIGHT_FLOW_STROKE);
        }
        int radius = 15;
        Path2D.Double path = new Path2D.Double();
        boolean isDefaultConditionAvailable = false;
        for (int i = 0; i < xPoints.length; ++i) {
            Integer anchorX = xPoints[i];
            Integer anchorY = yPoints[i];
            double targetX = anchorX.intValue();
            double targetY = anchorY.intValue();
            double ax = 0.0;
            double ay = 0.0;
            double bx = 0.0;
            double by = 0.0;
            double zx = 0.0;
            double zy = 0.0;
            if (i > 0 && i < xPoints.length - 1) {
                Integer cx = anchorX;
                Integer cy = anchorY;
                double lineLengthY = yPoints[i] - yPoints[i - 1];
                double lineLengthX = xPoints[i] - xPoints[i - 1];
                double lineLength = Math.sqrt(Math.pow(lineLengthY, 2.0) + Math.pow(lineLengthX, 2.0));
                double dx = lineLengthX * (double)radius / lineLength;
                double dy = lineLengthY * (double)radius / lineLength;
                targetX -= dx;
                targetY -= dy;
                boolean bl = isDefaultConditionAvailable = isDefault && i == 1 && lineLength > 10.0;
                if (lineLength < (double)(2 * radius) && i > 1) {
                    targetX = (double)xPoints[i] - lineLengthX / 2.0;
                    targetY = (double)yPoints[i] - lineLengthY / 2.0;
                }
                lineLengthY = yPoints[i + 1] - yPoints[i];
                lineLengthX = xPoints[i + 1] - xPoints[i];
                lineLength = Math.sqrt(Math.pow(lineLengthY, 2.0) + Math.pow(lineLengthX, 2.0));
                if (lineLength < (double)radius) {
                    lineLength = radius;
                }
                dx = lineLengthX * (double)radius / lineLength;
                dy = lineLengthY * (double)radius / lineLength;
                double nextSrcX = (double)xPoints[i] + dx;
                double nextSrcY = (double)yPoints[i] + dy;
                if (lineLength < (double)(2 * radius) && i < xPoints.length - 2) {
                    nextSrcX = (double)xPoints[i] + lineLengthX / 2.0;
                    nextSrcY = (double)yPoints[i] + lineLengthY / 2.0;
                }
                double dx0 = ((double)cx.intValue() - targetX) / 3.0;
                double dy0 = ((double)cy.intValue() - targetY) / 3.0;
                ax = (double)cx.intValue() - dx0;
                ay = (double)cy.intValue() - dy0;
                double dx1 = ((double)cx.intValue() - nextSrcX) / 3.0;
                double dy1 = ((double)cy.intValue() - nextSrcY) / 3.0;
                bx = (double)cx.intValue() - dx1;
                by = (double)cy.intValue() - dy1;
                zx = nextSrcX;
                zy = nextSrcY;
            }
            if (i == 0) {
                ((Path2D)path).moveTo(targetX, targetY);
            } else {
                ((Path2D)path).lineTo(targetX, targetY);
            }
            if (i <= 0 || i >= xPoints.length - 1) continue;
            ((Path2D)path).curveTo(ax, ay, bx, by, zx, zy);
        }
        this.g.draw(path);
        if (isDefaultConditionAvailable) {
            Line2D.Double line = new Line2D.Double(xPoints[0], yPoints[0], xPoints[1], yPoints[1]);
            this.drawDefaultSequenceFlowIndicator(line);
        }
        if (conditional) {
            Line2D.Double line = new Line2D.Double(xPoints[0], yPoints[0], xPoints[1], yPoints[1]);
            this.drawConditionalSequenceFlowIndicator(line);
        }
        if (associationDirection.equals((Object)AssociationDirection.ONE) || associationDirection.equals((Object)AssociationDirection.BOTH)) {
            Line2D.Double line = new Line2D.Double(xPoints[xPoints.length - 2], yPoints[xPoints.length - 2], xPoints[xPoints.length - 1], yPoints[xPoints.length - 1]);
            this.drawArrowHead(line);
        }
        if (associationDirection.equals((Object)AssociationDirection.BOTH)) {
            Line2D.Double line = new Line2D.Double(xPoints[1], yPoints[1], xPoints[0], yPoints[0]);
            this.drawArrowHead(line);
        }
        this.g.setPaint(originalPaint);
        this.g.setStroke(originalStroke);
    }

    public void drawSequenceflowWithoutArrow(int srcX, int srcY, int targetX, int targetY, boolean conditional) {
        this.drawSequenceflowWithoutArrow(srcX, srcY, targetX, targetY, conditional, false);
    }

    public void drawSequenceflowWithoutArrow(int srcX, int srcY, int targetX, int targetY, boolean conditional, boolean highLighted) {
        Paint originalPaint = this.g.getPaint();
        if (highLighted) {
            this.g.setPaint(HIGHLIGHT_COLOR);
        }
        Line2D.Double line = new Line2D.Double(srcX, srcY, targetX, targetY);
        this.g.draw(line);
        if (conditional) {
            this.drawConditionalSequenceFlowIndicator(line);
        }
        if (highLighted) {
            this.g.setPaint(originalPaint);
        }
    }

    public void drawArrowHead(Line2D.Double line) {
        int doubleArrowWidth = 10;
        Polygon arrowHead = new Polygon();
        arrowHead.addPoint(0, 0);
        arrowHead.addPoint(-5, -doubleArrowWidth);
        arrowHead.addPoint(5, -doubleArrowWidth);
        AffineTransform transformation = new AffineTransform();
        transformation.setToIdentity();
        double angle = Math.atan2(line.y2 - line.y1, line.x2 - line.x1);
        transformation.translate(line.x2, line.y2);
        transformation.rotate(angle - 1.5707963267948966);
        AffineTransform originalTransformation = this.g.getTransform();
        this.g.setTransform(transformation);
        this.g.fill(arrowHead);
        this.g.setTransform(originalTransformation);
    }

    public void drawDefaultSequenceFlowIndicator(Line2D.Double line) {
        double length = 10.0;
        double halfOfLength = length / 2.0;
        double f = 8.0;
        Line2D.Double defaultIndicator = new Line2D.Double(-halfOfLength, 0.0, halfOfLength, 0.0);
        double angle = Math.atan2(line.y2 - line.y1, line.x2 - line.x1);
        double dx = f * Math.cos(angle);
        double dy = f * Math.sin(angle);
        double x1 = line.x1 + dx;
        double y1 = line.y1 + dy;
        AffineTransform transformation = new AffineTransform();
        transformation.setToIdentity();
        transformation.translate(x1, y1);
        transformation.rotate(angle - 2.356194490192345);
        AffineTransform originalTransformation = this.g.getTransform();
        this.g.setTransform(transformation);
        this.g.draw(defaultIndicator);
        this.g.setTransform(originalTransformation);
    }

    public void drawConditionalSequenceFlowIndicator(Line2D.Double line) {
        int horizontal = 11;
        int halfOfHorizontal = horizontal / 2;
        int halfOfVertical = 8;
        Polygon conditionalIndicator = new Polygon();
        conditionalIndicator.addPoint(0, 0);
        conditionalIndicator.addPoint(-halfOfHorizontal, halfOfVertical);
        conditionalIndicator.addPoint(0, 16);
        conditionalIndicator.addPoint(halfOfHorizontal, halfOfVertical);
        AffineTransform transformation = new AffineTransform();
        transformation.setToIdentity();
        double angle = Math.atan2(line.y2 - line.y1, line.x2 - line.x1);
        transformation.translate(line.x1, line.y1);
        transformation.rotate(angle - 1.5707963267948966);
        AffineTransform originalTransformation = this.g.getTransform();
        this.g.setTransform(transformation);
        this.g.draw(conditionalIndicator);
        Paint originalPaint = this.g.getPaint();
        this.g.setPaint(CONDITIONAL_INDICATOR_COLOR);
        this.g.fill(conditionalIndicator);
        this.g.setPaint(originalPaint);
        this.g.setTransform(originalTransformation);
    }

    public void drawTask(String name, int x, int y, int width, int height) {
        this.drawTask(name, x, y, width, height, false);
    }

    public void drawPoolOrLane(String name, int x, int y, int width, int height) {
        this.g.drawRect(x, y, width, height);
        if (name != null && name.length() > 0) {
            int availableTextSpace = height - 6;
            AffineTransform transformation = new AffineTransform();
            transformation.setToIdentity();
            transformation.rotate(4.71238898038469);
            Font currentFont = this.g.getFont();
            Font theDerivedFont = currentFont.deriveFont(transformation);
            this.g.setFont(theDerivedFont);
            String truncated = this.fitTextToWidth(name, availableTextSpace);
            int realWidth = this.fontMetrics.stringWidth(truncated);
            this.g.drawString(truncated, x + 2 + this.fontMetrics.getHeight(), 3 + y + availableTextSpace - (availableTextSpace - realWidth) / 2);
            this.g.setFont(currentFont);
        }
    }

    protected void drawTask(String name, int x, int y, int width, int height, boolean thickBorder) {
        Paint originalPaint = this.g.getPaint();
        this.g.setPaint(new GradientPaint(x + 50, y, Color.white, x + 50, y + 50, TASK_BOX_COLOR));
        int arcR = 20;
        if (thickBorder) {
            arcR = 8;
        }
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(x, y, width, height, arcR, arcR);
        this.g.fill(rect);
        this.g.setPaint(originalPaint);
        if (thickBorder) {
            Stroke originalStroke = this.g.getStroke();
            this.g.setStroke(THICK_TASK_BORDER_STROKE);
            this.g.draw(rect);
            this.g.setStroke(originalStroke);
        } else {
            this.g.draw(rect);
        }
        if (name != null && name.length() > 0) {
            int boxWidth = width - 6;
            int boxHeight = height - ICON_SIZE - ICON_PADDING - ICON_PADDING - 12 - 2 - 2;
            int boxX = x + width / 2 - boxWidth / 2;
            int boxY = y + height / 2 - boxHeight / 2 + ICON_PADDING + ICON_PADDING - 2 - 2;
            this.drawMultilineCentredText(name, boxX, boxY, boxWidth, boxHeight);
        }
    }

    protected void drawMultilineCentredText(String text, int x, int y, int boxWidth, int boxHeight) {
        this.drawMultilineText(text, x, y, boxWidth, boxHeight, true);
    }

    protected void drawMultilineAnnotationText(String text, int x, int y, int boxWidth, int boxHeight) {
        this.drawMultilineText(text, x, y, boxWidth, boxHeight, false);
    }

    protected void drawMultilineText(String text, int x, int y, int boxWidth, int boxHeight, boolean centered) {
        AttributedString attributedString = new AttributedString(text);
        attributedString.addAttribute(TextAttribute.FONT, this.g.getFont());
        attributedString.addAttribute(TextAttribute.FOREGROUND, Color.black);
        AttributedCharacterIterator characterIterator = attributedString.getIterator();
        int currentHeight = 0;
        ArrayList<TextLayout> layouts = new ArrayList<TextLayout>();
        String lastLine = null;
        LineBreakMeasurer measurer = new LineBreakMeasurer(characterIterator, this.g.getFontRenderContext());
        TextLayout layout = null;
        while (measurer.getPosition() < characterIterator.getEndIndex() && currentHeight <= boxHeight) {
            int previousPosition = measurer.getPosition();
            layout = measurer.nextLayout(boxWidth);
            int height = Float.valueOf(layout.getDescent() + layout.getAscent() + layout.getLeading()).intValue();
            if (currentHeight + height > boxHeight) {
                layouts.remove(layouts.size() - 1);
                if (lastLine.length() >= 4) {
                    lastLine = lastLine.substring(0, lastLine.length() - 4) + "...";
                }
                layouts.add(new TextLayout(lastLine, this.g.getFont(), this.g.getFontRenderContext()));
                continue;
            }
            layouts.add(layout);
            lastLine = text.substring(previousPosition, measurer.getPosition());
            currentHeight += height;
        }
        int currentY = y + (centered ? (boxHeight - currentHeight) / 2 : 0);
        int currentX = 0;
        for (TextLayout textLayout : layouts) {
            currentY = (int)((float)currentY + textLayout.getAscent());
            currentX = x + (centered ? (boxWidth - Double.valueOf(textLayout.getBounds().getWidth()).intValue()) / 2 : 0);
            textLayout.draw(this.g, currentX, currentY);
            currentY = (int)((float)currentY + (textLayout.getDescent() + textLayout.getLeading()));
        }
    }

    protected String fitTextToWidth(String original, int width) {
        String text = original;
        int maxWidth = width - 10;
        while (this.fontMetrics.stringWidth(text + "...") > maxWidth && text.length() > 0) {
            text = text.substring(0, text.length() - 1);
        }
        if (!text.equals(original)) {
            text = text + "...";
        }
        return text;
    }

    public void drawUserTask(String name, int x, int y, int width, int height) {
        this.drawTask(name, x, y, width, height);
        this.g.drawImage(USERTASK_IMAGE, x + ICON_PADDING, y + ICON_PADDING, ICON_SIZE, ICON_SIZE, null);
    }

    public void drawScriptTask(String name, int x, int y, int width, int height) {
        this.drawTask(name, x, y, width, height);
        this.g.drawImage(SCRIPTTASK_IMAGE, x + ICON_PADDING, y + ICON_PADDING, ICON_SIZE, ICON_SIZE, null);
    }

    public void drawServiceTask(String name, int x, int y, int width, int height) {
        this.drawTask(name, x, y, width, height);
        this.g.drawImage(SERVICETASK_IMAGE, x + ICON_PADDING, y + ICON_PADDING, ICON_SIZE, ICON_SIZE, null);
    }

    public void drawReceiveTask(String name, int x, int y, int width, int height) {
        this.drawTask(name, x, y, width, height);
        this.g.drawImage(RECEIVETASK_IMAGE, x + ICON_PADDING, y + ICON_PADDING, ICON_SIZE, ICON_SIZE, null);
    }

    public void drawSendTask(String name, int x, int y, int width, int height) {
        this.drawTask(name, x, y, width, height);
        this.g.drawImage(SENDTASK_IMAGE, x + ICON_PADDING, y + ICON_PADDING, ICON_SIZE, ICON_SIZE, null);
    }

    public void drawManualTask(String name, int x, int y, int width, int height) {
        this.drawTask(name, x, y, width, height);
        this.g.drawImage(MANUALTASK_IMAGE, x + ICON_PADDING, y + ICON_PADDING, ICON_SIZE, ICON_SIZE, null);
    }

    public void drawBusinessRuleTask(String name, int x, int y, int width, int height) {
        this.drawTask(name, x, y, width, height);
        this.g.drawImage(BUSINESS_RULE_TASK_IMAGE, x + ICON_PADDING, y + ICON_PADDING, ICON_SIZE, ICON_SIZE, null);
    }

    public void drawExpandedSubProcess(String name, int x, int y, int width, int height, Boolean isTriggeredByEvent) {
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(x, y, width, height, 8.0, 8.0);
        if (isTriggeredByEvent.booleanValue()) {
            Stroke originalStroke = this.g.getStroke();
            this.g.setStroke(EVENT_SUBPROCESS_STROKE);
            this.g.draw(rect);
            this.g.setStroke(originalStroke);
        } else {
            Paint originalPaint = this.g.getPaint();
            this.g.setPaint(SUBPROCESS_BOX_COLOR);
            this.g.fill(rect);
            this.g.setPaint(originalPaint);
            this.g.draw(rect);
        }
        String text = this.fitTextToWidth(name, width);
        this.g.drawString(text, x + 10, y + 15);
    }

    public void drawCollapsedSubProcess(String name, int x, int y, int width, int height, Boolean isTriggeredByEvent) {
        this.drawCollapsedTask(name, x, y, width, height, false);
    }

    public void drawCollapsedCallActivity(String name, int x, int y, int width, int height) {
        this.drawCollapsedTask(name, x, y, width, height, true);
    }

    protected void drawCollapsedTask(String name, int x, int y, int width, int height, boolean thickBorder) {
        this.drawTask(name, x, y, width, height, thickBorder);
    }

    public void drawCollapsedMarker(int x, int y, int width, int height) {
        int rectangleWidth = 12;
        int rectangleHeight = 12;
        Rectangle rect = new Rectangle(x + (width - rectangleWidth) / 2, y + height - rectangleHeight - 3, rectangleWidth, rectangleHeight);
        this.g.draw(rect);
        Line2D.Double line = new Line2D.Double(rect.getCenterX(), rect.getY() + 2.0, rect.getCenterX(), rect.getMaxY() - 2.0);
        this.g.draw(line);
        line = new Line2D.Double(rect.getMinX() + 2.0, rect.getCenterY(), rect.getMaxX() - 2.0, rect.getCenterY());
        this.g.draw(line);
    }

    public void drawActivityMarkers(int x, int y, int width, int height, boolean multiInstanceSequential, boolean multiInstanceParallel, boolean collapsed) {
        if (collapsed) {
            if (!multiInstanceSequential && !multiInstanceParallel) {
                this.drawCollapsedMarker(x, y, width, height);
            } else {
                this.drawCollapsedMarker(x - 6 - 2, y, width, height);
                if (multiInstanceSequential) {
                    this.drawMultiInstanceMarker(true, x + 6 + 2, y, width, height);
                } else if (multiInstanceParallel) {
                    this.drawMultiInstanceMarker(false, x + 6 + 2, y, width, height);
                }
            }
        } else if (multiInstanceSequential) {
            this.drawMultiInstanceMarker(true, x, y, width, height);
        } else if (multiInstanceParallel) {
            this.drawMultiInstanceMarker(false, x, y, width, height);
        }
    }

    public void drawGateway(int x, int y, int width, int height) {
        Polygon rhombus = new Polygon();
        rhombus.addPoint(x, y + height / 2);
        rhombus.addPoint(x + width / 2, y + height);
        rhombus.addPoint(x + width, y + height / 2);
        rhombus.addPoint(x + width / 2, y);
        this.g.draw(rhombus);
    }

    public void drawParallelGateway(int x, int y, int width, int height) {
        this.drawGateway(x, y, width, height);
        Stroke orginalStroke = this.g.getStroke();
        this.g.setStroke(GATEWAY_TYPE_STROKE);
        Line2D.Double line = new Line2D.Double(x + 10, y + height / 2, x + width - 10, y + height / 2);
        this.g.draw(line);
        line = new Line2D.Double(x + width / 2, y + height - 10, x + width / 2, y + 10);
        this.g.draw(line);
        this.g.setStroke(orginalStroke);
    }

    public void drawExclusiveGateway(int x, int y, int width, int height) {
        this.drawGateway(x, y, width, height);
        int quarterWidth = width / 4;
        int quarterHeight = height / 4;
        Stroke orginalStroke = this.g.getStroke();
        this.g.setStroke(GATEWAY_TYPE_STROKE);
        Line2D.Double line = new Line2D.Double(x + quarterWidth + 3, y + quarterHeight + 3, x + 3 * quarterWidth - 3, y + 3 * quarterHeight - 3);
        this.g.draw(line);
        line = new Line2D.Double(x + quarterWidth + 3, y + 3 * quarterHeight - 3, x + 3 * quarterWidth - 3, y + quarterHeight + 3);
        this.g.draw(line);
        this.g.setStroke(orginalStroke);
    }

    public void drawInclusiveGateway(int x, int y, int width, int height) {
        this.drawGateway(x, y, width, height);
        int diameter = width / 2;
        Stroke orginalStroke = this.g.getStroke();
        this.g.setStroke(GATEWAY_TYPE_STROKE);
        Ellipse2D.Double circle = new Ellipse2D.Double((width - diameter) / 2 + x, (height - diameter) / 2 + y, diameter, diameter);
        this.g.draw(circle);
        this.g.setStroke(orginalStroke);
    }

    public void drawEventBasedGateway(int x, int y, int width, int height) {
        this.drawGateway(x, y, width, height);
        double scale = 0.6;
        this.drawCatchingEvent((int)((double)x + (double)width * (1.0 - scale) / 2.0), (int)((double)y + (double)height * (1.0 - scale) / 2.0), (int)((double)width * scale), (int)((double)height * scale), false, null);
        double r = (double)width / 6.0;
        int topX = (int)(0.95 * r);
        int topY = (int)(-0.31 * r);
        int bottomX = (int)(0.59 * r);
        int bottomY = (int)(0.81 * r);
        int[] xPoints = new int[]{0, topX, bottomX, -bottomX, -topX};
        int[] yPoints = new int[]{-((int)r), topY, bottomY, bottomY, topY};
        Polygon pentagon = new Polygon(xPoints, yPoints, 5);
        pentagon.translate(x + width / 2, y + width / 2);
        this.g.drawPolygon(pentagon);
    }

    public void drawMultiInstanceMarker(boolean sequential, int x, int y, int width, int height) {
        int rectangleWidth = 12;
        int rectangleHeight = 12;
        int lineX = x + (width - rectangleWidth) / 2;
        int lineY = y + height - rectangleHeight - 3;
        Stroke orginalStroke = this.g.getStroke();
        this.g.setStroke(MULTI_INSTANCE_STROKE);
        if (sequential) {
            this.g.draw(new Line2D.Double(lineX, lineY, lineX + rectangleWidth, lineY));
            this.g.draw(new Line2D.Double(lineX, lineY + rectangleHeight / 2, lineX + rectangleWidth, lineY + rectangleHeight / 2));
            this.g.draw(new Line2D.Double(lineX, lineY + rectangleHeight, lineX + rectangleWidth, lineY + rectangleHeight));
        } else {
            this.g.draw(new Line2D.Double(lineX, lineY, lineX, lineY + rectangleHeight));
            this.g.draw(new Line2D.Double(lineX + rectangleWidth / 2, lineY, lineX + rectangleWidth / 2, lineY + rectangleHeight));
            this.g.draw(new Line2D.Double(lineX + rectangleWidth, lineY, lineX + rectangleWidth, lineY + rectangleHeight));
        }
        this.g.setStroke(orginalStroke);
    }

    public void drawHighLight(int x, int y, int width, int height) {
        Paint originalPaint = this.g.getPaint();
        Stroke originalStroke = this.g.getStroke();
        this.g.setPaint(HIGHLIGHT_COLOR);
        this.g.setStroke(THICK_TASK_BORDER_STROKE);
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(x, y, width, height, 20.0, 20.0);
        this.g.draw(rect);
        this.g.setPaint(originalPaint);
        this.g.setStroke(originalStroke);
    }

    public void drawTextAnnotation(String text, int x, int y, int width, int height) {
        Font originalFont = this.g.getFont();
        Stroke originalStroke = this.g.getStroke();
        this.g.setFont(ANNOTATION_FONT);
        Path2D.Double path = new Path2D.Double();
        x = (int)((double)x + 0.5);
        int lineLength = 18;
        ((Path2D)path).moveTo(x + lineLength, y);
        ((Path2D)path).lineTo(x, y);
        ((Path2D)path).lineTo(x, y + height);
        ((Path2D)path).lineTo(x + lineLength, y + height);
        ((Path2D)path).lineTo(x + lineLength, y + height - 1);
        ((Path2D)path).lineTo(x + 1, y + height - 1);
        ((Path2D)path).lineTo(x + 1, y + 1);
        ((Path2D)path).lineTo(x + lineLength, y + 1);
        path.closePath();
        this.g.draw(path);
        int boxWidth = width - 14;
        int boxHeight = height - 14;
        int boxX = x + width / 2 - boxWidth / 2;
        int boxY = y + height / 2 - boxHeight / 2;
        this.drawMultilineAnnotationText(text, boxX, boxY, boxWidth, boxHeight);
        this.g.setFont(originalFont);
        this.g.setStroke(originalStroke);
    }

    public void drawLabel(String text, int x, int y, int width, int height) {
        this.drawLabel(text, x, y, width, height, true);
    }

    public void drawLabel(String text, int x, int y, int width, int height, boolean centered) {
        float interline = 1.0f;
        if (text != null && text.length() > 0) {
            Paint originalPaint = this.g.getPaint();
            Font originalFont = this.g.getFont();
            this.g.setPaint(LABEL_COLOR);
            this.g.setFont(LABEL_FONT);
            int wrapWidth = 100;
            int textY = y + height;
            AttributedString as = new AttributedString(text);
            as.addAttribute(TextAttribute.FOREGROUND, this.g.getPaint());
            as.addAttribute(TextAttribute.FONT, this.g.getFont());
            AttributedCharacterIterator aci = as.getIterator();
            FontRenderContext frc = new FontRenderContext(null, true, false);
            LineBreakMeasurer lbm = new LineBreakMeasurer(aci, frc);
            while (lbm.getPosition() < text.length()) {
                TextLayout tl = lbm.nextLayout(wrapWidth);
                textY = (int)((float)textY + tl.getAscent());
                Rectangle2D bb = tl.getBounds();
                float tY = x;
                if (centered) {
                    tY += (float)((int)((double)(width / 2) - bb.getWidth() / 2.0));
                }
                tl.draw(this.g, tY, textY);
                textY = (int)((float)textY + (tl.getDescent() + tl.getLeading() + (interline - 1.0f) * tl.getAscent()));
            }
            this.g.setFont(originalFont);
            this.g.setPaint(originalPaint);
        }
    }

    public List<GraphicInfo> connectionPerfectionizer(SHAPE_TYPE sourceShapeType, SHAPE_TYPE targetShapeType, GraphicInfo sourceGraphicInfo, GraphicInfo targetGraphicInfo, List<GraphicInfo> graphicInfoList) {
        Line2D.Double lineLast;
        Line2D.Double lineFirst;
        Shape shapeFirst = ProcessDiagramCanvas.createShape(sourceShapeType, sourceGraphicInfo);
        Shape shapeLast = ProcessDiagramCanvas.createShape(targetShapeType, targetGraphicInfo);
        GraphicInfo graphicInfoFirst = graphicInfoList.get(0);
        GraphicInfo graphicInfoLast = graphicInfoList.get(graphicInfoList.size() - 1);
        if (shapeFirst != null) {
            graphicInfoFirst.setX(shapeFirst.getBounds2D().getCenterX());
            graphicInfoFirst.setY(shapeFirst.getBounds2D().getCenterY());
        }
        if (shapeLast != null) {
            graphicInfoLast.setX(shapeLast.getBounds2D().getCenterX());
            graphicInfoLast.setY(shapeLast.getBounds2D().getCenterY());
        }
        Point p = null;
        if (shapeFirst != null && (p = ProcessDiagramCanvas.getIntersection(shapeFirst, lineFirst = new Line2D.Double(graphicInfoFirst.getX(), graphicInfoFirst.getY(), graphicInfoList.get(1).getX(), graphicInfoList.get(1).getY()))) != null) {
            graphicInfoFirst.setX(p.getX());
            graphicInfoFirst.setY(p.getY());
        }
        if (shapeLast != null && (p = ProcessDiagramCanvas.getIntersection(shapeLast, lineLast = new Line2D.Double(graphicInfoLast.getX(), graphicInfoLast.getY(), graphicInfoList.get(graphicInfoList.size() - 2).getX(), graphicInfoList.get(graphicInfoList.size() - 2).getY()))) != null) {
            graphicInfoLast.setX(p.getX());
            graphicInfoLast.setY(p.getY());
        }
        return graphicInfoList;
    }

    private static Shape createShape(SHAPE_TYPE shapeType, GraphicInfo graphicInfo) {
        if (SHAPE_TYPE.Rectangle.equals((Object)shapeType)) {
            return new Rectangle2D.Double(graphicInfo.getX(), graphicInfo.getY(), graphicInfo.getWidth(), graphicInfo.getHeight());
        }
        if (SHAPE_TYPE.Rhombus.equals((Object)shapeType)) {
            Path2D.Double rhombus = new Path2D.Double();
            rhombus.moveTo(graphicInfo.getX(), graphicInfo.getY() + graphicInfo.getHeight() / 2.0);
            rhombus.lineTo(graphicInfo.getX() + graphicInfo.getWidth() / 2.0, graphicInfo.getY() + graphicInfo.getHeight());
            rhombus.lineTo(graphicInfo.getX() + graphicInfo.getWidth(), graphicInfo.getY() + graphicInfo.getHeight() / 2.0);
            rhombus.lineTo(graphicInfo.getX() + graphicInfo.getWidth() / 2.0, graphicInfo.getY());
            rhombus.lineTo(graphicInfo.getX(), graphicInfo.getY() + graphicInfo.getHeight() / 2.0);
            rhombus.closePath();
            return rhombus;
        }
        if (SHAPE_TYPE.Ellipse.equals((Object)shapeType)) {
            return new Ellipse2D.Double(graphicInfo.getX(), graphicInfo.getY(), graphicInfo.getWidth(), graphicInfo.getHeight());
        }
        return null;
    }

    private static Point getIntersection(Shape shape, Line2D.Double line) {
        if (shape instanceof Ellipse2D) {
            return ProcessDiagramCanvas.getEllipseIntersection(shape, line);
        }
        if (shape instanceof Rectangle2D || shape instanceof Path2D) {
            return ProcessDiagramCanvas.getShapeIntersection(shape, line);
        }
        return null;
    }

    private static Point getEllipseIntersection(Shape shape, Line2D.Double line) {
        double angle = Math.atan2(line.y2 - line.y1, line.x2 - line.x1);
        double x = shape.getBounds2D().getWidth() / 2.0 * Math.cos(angle) + shape.getBounds2D().getCenterX();
        double y = shape.getBounds2D().getHeight() / 2.0 * Math.sin(angle) + shape.getBounds2D().getCenterY();
        Point p = new Point();
        p.setLocation(x, y);
        return p;
    }

    private static Point getShapeIntersection(Shape shape, Line2D.Double line) {
        PathIterator it = shape.getPathIterator(null);
        double[] coords = new double[6];
        double[] pos = new double[2];
        Line2D.Double l = new Line2D.Double();
        while (!it.isDone()) {
            int type = it.currentSegment(coords);
            switch (type) {
                case 0: {
                    pos[0] = coords[0];
                    pos[1] = coords[1];
                    break;
                }
                case 1: {
                    l = new Line2D.Double(pos[0], pos[1], coords[0], coords[1]);
                    if (line.intersectsLine(l)) {
                        return ProcessDiagramCanvas.getLinesIntersection(line, l);
                    }
                    pos[0] = coords[0];
                    pos[1] = coords[1];
                    break;
                }
                case 4: {
                    break;
                }
            }
            it.next();
        }
        return null;
    }

    private static Point getLinesIntersection(Line2D a, Line2D b) {
        double d = (a.getX1() - a.getX2()) * (b.getY2() - b.getY1()) - (a.getY1() - a.getY2()) * (b.getX2() - b.getX1());
        double da = (a.getX1() - b.getX1()) * (b.getY2() - b.getY1()) - (a.getY1() - b.getY1()) * (b.getX2() - b.getX1());
        double ta = da / d;
        Point p = new Point();
        p.setLocation(a.getX1() + ta * (a.getX2() - a.getX1()), a.getY1() + ta * (a.getY2() - a.getY1()));
        return p;
    }

    static {
        try {
            USERTASK_IMAGE = ImageIO.read(ReflectUtil.getResourceAsStream("org/activiti/engine/impl/bpmn/deployer/user.png"));
            SCRIPTTASK_IMAGE = ImageIO.read(ReflectUtil.getResourceAsStream("org/activiti/engine/impl/bpmn/deployer/script.png"));
            SERVICETASK_IMAGE = ImageIO.read(ReflectUtil.getResourceAsStream("org/activiti/engine/impl/bpmn/deployer/service.png"));
            RECEIVETASK_IMAGE = ImageIO.read(ReflectUtil.getResourceAsStream("org/activiti/engine/impl/bpmn/deployer/receive.png"));
            SENDTASK_IMAGE = ImageIO.read(ReflectUtil.getResourceAsStream("org/activiti/engine/impl/bpmn/deployer/send.png"));
            MANUALTASK_IMAGE = ImageIO.read(ReflectUtil.getResourceAsStream("org/activiti/engine/impl/bpmn/deployer/manual.png"));
            BUSINESS_RULE_TASK_IMAGE = ImageIO.read(ReflectUtil.getResourceAsStream("org/activiti/engine/impl/bpmn/deployer/business_rule.png"));
            TIMER_IMAGE = ImageIO.read(ReflectUtil.getResourceAsStream("org/activiti/engine/impl/bpmn/deployer/timer.png"));
            ERROR_THROW_IMAGE = ImageIO.read(ReflectUtil.getResourceAsStream("org/activiti/engine/impl/bpmn/deployer/error_throw.png"));
            ERROR_CATCH_IMAGE = ImageIO.read(ReflectUtil.getResourceAsStream("org/activiti/engine/impl/bpmn/deployer/error_catch.png"));
            SIGNAL_CATCH_IMAGE = ImageIO.read(ReflectUtil.getResourceAsStream("org/activiti/engine/impl/bpmn/deployer/signal_catch.png"));
            SIGNAL_THROW_IMAGE = ImageIO.read(ReflectUtil.getResourceAsStream("org/activiti/engine/impl/bpmn/deployer/signal_throw.png"));
        }
        catch (IOException e) {
            LOGGER.warn("Could not load image for process diagram creation: {}", (Object)e.getMessage());
        }
    }

    public static enum SHAPE_TYPE {
        Rectangle,
        Rhombus,
        Ellipse;

    }
}

