/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.variable;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.util.IoUtil;
import org.activiti.engine.impl.util.ReflectUtil;
import org.activiti.engine.impl.variable.ByteArrayType;
import org.activiti.engine.impl.variable.ValueFields;

public class SerializableType
extends ByteArrayType {
    public static final String TYPE_NAME = "serializable";
    private static final long serialVersionUID = 1L;

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        Object cachedObject = valueFields.getCachedValue();
        if (cachedObject != null) {
            return cachedObject;
        }
        byte[] bytes = (byte[])super.getValue(valueFields);
        if (bytes != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            try {
                ObjectInputStream ois = this.createObjectInputStream(bais);
                Object deserializedObject = ois.readObject();
                valueFields.setCachedValue(deserializedObject);
                if (valueFields instanceof VariableInstanceEntity) {
                    Context.getCommandContext().getDbSqlSession().addDeserializedObject(deserializedObject, bytes, (VariableInstanceEntity)valueFields);
                }
                Object object = deserializedObject;
                return object;
            }
            catch (Exception e) {
                throw new ActivitiException("Couldn't deserialize object in variable '" + valueFields.getName() + "'", e);
            }
            finally {
                IoUtil.closeSilently(bais);
            }
        }
        return null;
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        byte[] byteArray = SerializableType.serialize(value, valueFields);
        valueFields.setCachedValue(value);
        if (valueFields.getBytes() == null && valueFields instanceof VariableInstanceEntity) {
            Context.getCommandContext().getDbSqlSession().addDeserializedObject(valueFields.getCachedValue(), byteArray, (VariableInstanceEntity)valueFields);
        }
        super.setValue(byteArray, valueFields);
    }

    public static byte[] serialize(Object value, ValueFields valueFields) {
        if (value == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = SerializableType.createObjectOutputStream(baos);
            oos.writeObject(value);
        }
        catch (Exception e) {
            throw new ActivitiException("Couldn't serialize value '" + value + "' in variable '" + valueFields.getName() + "'", e);
        }
        finally {
            IoUtil.closeSilently(oos);
        }
        return baos.toByteArray();
    }

    @Override
    public boolean isAbleToStore(Object value) {
        return value instanceof Serializable;
    }

    protected ObjectInputStream createObjectInputStream(InputStream is) throws IOException {
        return new ObjectInputStream(is){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                return ReflectUtil.loadClass(desc.getName());
            }
        };
    }

    private static ObjectOutputStream createObjectOutputStream(OutputStream os) throws IOException {
        return new ObjectOutputStream(os);
    }
}

