/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.identity.Group;
import org.activiti.engine.impl.AbstractQuery;
import org.activiti.engine.impl.AbstractVariableQueryImpl;
import org.activiti.engine.impl.HistoricTaskInstanceQueryProperty;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.QueryVariableValue;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.variable.VariableTypes;

public class HistoricTaskInstanceQueryImpl
extends AbstractVariableQueryImpl<HistoricTaskInstanceQuery, HistoricTaskInstance>
implements HistoricTaskInstanceQuery {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String processDefinitionKeyLike;
    protected String processDefinitionKeyLikeIgnoreCase;
    protected String processDefinitionName;
    protected String processDefinitionNameLike;
    protected String deploymentId;
    protected List<String> deploymentIds;
    protected String processInstanceId;
    protected String processInstanceBusinessKey;
    protected String processInstanceBusinessKeyLike;
    protected String processInstanceBusinessKeyLikeIgnoreCase;
    protected String executionId;
    protected String taskId;
    protected String taskName;
    protected String taskNameLike;
    protected String taskNameLikeIgnoreCase;
    protected List<String> taskNameList;
    protected List<String> taskNameListIgnoreCase;
    protected String taskParentTaskId;
    protected String taskDescription;
    protected String taskDescriptionLike;
    protected String taskDescriptionLikeIgnoreCase;
    protected String taskDeleteReason;
    protected String taskDeleteReasonLike;
    protected String taskOwner;
    protected String taskOwnerLike;
    protected String taskOwnerLikeIgnoreCase;
    protected String taskAssignee;
    protected String taskAssigneeLike;
    protected String taskAssigneeLikeIgnoreCase;
    protected String taskDefinitionKey;
    protected String taskDefinitionKeyLike;
    protected String candidateUser;
    protected String candidateGroup;
    private List<String> candidateGroups;
    protected String involvedUser;
    protected Integer taskPriority;
    protected Integer taskMinPriority;
    protected Integer taskMaxPriority;
    protected boolean finished;
    protected boolean unfinished;
    protected boolean processFinished;
    protected boolean processUnfinished;
    protected Date dueDate;
    protected Date dueAfter;
    protected Date dueBefore;
    protected boolean withoutDueDate = false;
    protected Date creationDate;
    protected Date creationAfterDate;
    protected Date creationBeforeDate;
    protected Date completedDate;
    protected Date completedAfterDate;
    protected Date completedBeforeDate;
    protected String category;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;
    protected boolean includeTaskLocalVariables = false;
    protected boolean includeProcessVariables = false;
    protected HistoricTaskInstanceQueryImpl orQueryObject;
    protected boolean inOrStatement = false;

    public HistoricTaskInstanceQueryImpl() {
    }

    public HistoricTaskInstanceQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public HistoricTaskInstanceQueryImpl(CommandExecutor commandExecutor, String databaseType) {
        super(commandExecutor);
        this.databaseType = databaseType;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        this.checkQueryOk();
        return commandContext.getHistoricTaskInstanceEntityManager().findHistoricTaskInstanceCountByQueryCriteria(this);
    }

    @Override
    public List<HistoricTaskInstance> executeList(CommandContext commandContext, Page page) {
        this.ensureVariablesInitialized();
        this.checkQueryOk();
        if (this.includeTaskLocalVariables || this.includeProcessVariables) {
            return commandContext.getHistoricTaskInstanceEntityManager().findHistoricTaskInstancesAndVariablesByQueryCriteria(this);
        }
        return commandContext.getHistoricTaskInstanceEntityManager().findHistoricTaskInstancesByQueryCriteria(this);
    }

    @Override
    public HistoricTaskInstanceQueryImpl processInstanceId(String processInstanceId) {
        if (this.inOrStatement) {
            this.orQueryObject.processInstanceId = processInstanceId;
        } else {
            this.processInstanceId = processInstanceId;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl processInstanceBusinessKey(String processInstanceBusinessKey) {
        if (this.inOrStatement) {
            this.orQueryObject.processInstanceBusinessKey = processInstanceBusinessKey;
        } else {
            this.processInstanceBusinessKey = processInstanceBusinessKey;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl processInstanceBusinessKeyLike(String processInstanceBusinessKeyLike) {
        if (this.inOrStatement) {
            this.orQueryObject.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
        } else {
            this.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery processInstanceBusinessKeyLikeIgnoreCase(String processInstanceBusinessKeyLikeIgnoreCase) {
        if (this.inOrStatement) {
            this.orQueryObject.processInstanceBusinessKeyLikeIgnoreCase = processInstanceBusinessKeyLikeIgnoreCase.toLowerCase();
        } else {
            this.processInstanceBusinessKeyLikeIgnoreCase = processInstanceBusinessKeyLikeIgnoreCase.toLowerCase();
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl executionId(String executionId) {
        if (this.inOrStatement) {
            this.orQueryObject.executionId = executionId;
        } else {
            this.executionId = executionId;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl processDefinitionId(String processDefinitionId) {
        if (this.inOrStatement) {
            this.orQueryObject.processDefinitionId = processDefinitionId;
        } else {
            this.processDefinitionId = processDefinitionId;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery processDefinitionKey(String processDefinitionKey) {
        if (this.inOrStatement) {
            this.orQueryObject.processDefinitionKey = processDefinitionKey;
        } else {
            this.processDefinitionKey = processDefinitionKey;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery processDefinitionKeyLike(String processDefinitionKeyLike) {
        if (this.inOrStatement) {
            this.orQueryObject.processDefinitionKeyLike = processDefinitionKeyLike;
        } else {
            this.processDefinitionKeyLike = processDefinitionKeyLike;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery processDefinitionKeyLikeIgnoreCase(String processDefinitionKeyLikeIgnoreCase) {
        if (this.inOrStatement) {
            this.orQueryObject.processDefinitionKeyLikeIgnoreCase = processDefinitionKeyLikeIgnoreCase.toLowerCase();
        } else {
            this.processDefinitionKeyLikeIgnoreCase = processDefinitionKeyLikeIgnoreCase.toLowerCase();
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery processDefinitionName(String processDefinitionName) {
        if (this.inOrStatement) {
            this.orQueryObject.processDefinitionName = processDefinitionName;
        } else {
            this.processDefinitionName = processDefinitionName;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery processDefinitionNameLike(String processDefinitionNameLike) {
        if (this.inOrStatement) {
            this.orQueryObject.processDefinitionNameLike = processDefinitionNameLike;
        } else {
            this.processDefinitionNameLike = processDefinitionNameLike;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery deploymentId(String deploymentId) {
        if (this.inOrStatement) {
            this.orQueryObject.deploymentId = deploymentId;
        } else {
            this.deploymentId = deploymentId;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery deploymentIdIn(List<String> deploymentIds) {
        if (this.inOrStatement) {
            this.orQueryObject.deploymentIds = deploymentIds;
        } else {
            this.deploymentIds = deploymentIds;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskId(String taskId) {
        if (this.inOrStatement) {
            this.orQueryObject.taskId = taskId;
        } else {
            this.taskId = taskId;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskName(String taskName) {
        if (this.inOrStatement) {
            this.orQueryObject.taskName = taskName;
        } else {
            this.taskName = taskName;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskNameIn(List<String> taskNameList) {
        if (taskNameList == null) {
            throw new ActivitiIllegalArgumentException("Task name list is null");
        }
        if (taskNameList.isEmpty()) {
            throw new ActivitiIllegalArgumentException("Task name list is empty");
        }
        if (this.taskName != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both taskNameIn and taskName");
        }
        if (this.taskNameLike != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both taskNameIn and taskNameLike");
        }
        if (this.taskNameLikeIgnoreCase != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both taskNameIn and taskNameLikeIgnoreCase");
        }
        if (this.inOrStatement) {
            this.orQueryObject.taskNameList = taskNameList;
        } else {
            this.taskNameList = taskNameList;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskNameInIgnoreCase(List<String> taskNameList) {
        if (taskNameList == null) {
            throw new ActivitiIllegalArgumentException("Task name list is null");
        }
        if (taskNameList.isEmpty()) {
            throw new ActivitiIllegalArgumentException("Task name list is empty");
        }
        for (String taskName : taskNameList) {
            if (taskName != null) continue;
            throw new ActivitiIllegalArgumentException("None of the given task names can be null");
        }
        if (this.taskName != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both taskNameInIgnoreCase and name");
        }
        if (this.taskNameLike != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both taskNameInIgnoreCase and nameLike");
        }
        if (this.taskNameLikeIgnoreCase != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both taskNameInIgnoreCase and nameLikeIgnoreCase");
        }
        int nameListSize = taskNameList.size();
        ArrayList<String> caseIgnoredTaskNameList = new ArrayList<String>(nameListSize);
        for (String taskName : taskNameList) {
            caseIgnoredTaskNameList.add(taskName.toLowerCase());
        }
        if (this.inOrStatement) {
            this.orQueryObject.taskNameListIgnoreCase = caseIgnoredTaskNameList;
        } else {
            this.taskNameListIgnoreCase = caseIgnoredTaskNameList;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskNameLike(String taskNameLike) {
        if (this.inOrStatement) {
            this.orQueryObject.taskNameLike = taskNameLike;
        } else {
            this.taskNameLike = taskNameLike;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskNameLikeIgnoreCase(String taskNameLikeIgnoreCase) {
        if (this.inOrStatement) {
            this.orQueryObject.taskNameLikeIgnoreCase = taskNameLikeIgnoreCase.toLowerCase();
        } else {
            this.taskNameLikeIgnoreCase = taskNameLikeIgnoreCase.toLowerCase();
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskParentTaskId(String parentTaskId) {
        if (this.inOrStatement) {
            this.orQueryObject.taskParentTaskId = parentTaskId;
        } else {
            this.taskParentTaskId = parentTaskId;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskDescription(String taskDescription) {
        if (this.inOrStatement) {
            this.orQueryObject.taskDescription = taskDescription;
        } else {
            this.taskDescription = taskDescription;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskDescriptionLike(String taskDescriptionLike) {
        if (this.inOrStatement) {
            this.orQueryObject.taskDescriptionLike = taskDescriptionLike;
        } else {
            this.taskDescriptionLike = taskDescriptionLike;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskDescriptionLikeIgnoreCase(String taskDescriptionLikeIgnoreCase) {
        if (this.inOrStatement) {
            this.orQueryObject.taskDescriptionLikeIgnoreCase = taskDescriptionLikeIgnoreCase.toLowerCase();
        } else {
            this.taskDescriptionLikeIgnoreCase = taskDescriptionLikeIgnoreCase.toLowerCase();
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskDeleteReason(String taskDeleteReason) {
        if (this.inOrStatement) {
            this.orQueryObject.taskDeleteReason = taskDeleteReason;
        } else {
            this.taskDeleteReason = taskDeleteReason;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskDeleteReasonLike(String taskDeleteReasonLike) {
        if (this.inOrStatement) {
            this.orQueryObject.taskDeleteReasonLike = taskDeleteReasonLike;
        } else {
            this.taskDeleteReasonLike = taskDeleteReasonLike;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskAssignee(String taskAssignee) {
        if (this.inOrStatement) {
            this.orQueryObject.taskAssignee = taskAssignee;
        } else {
            this.taskAssignee = taskAssignee;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskAssigneeLike(String taskAssigneeLike) {
        if (this.inOrStatement) {
            this.orQueryObject.taskAssigneeLike = taskAssigneeLike;
        } else {
            this.taskAssigneeLike = taskAssigneeLike;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskAssigneeLikeIgnoreCase(String taskAssigneeLikeIgnoreCase) {
        if (this.inOrStatement) {
            this.orQueryObject.taskAssigneeLikeIgnoreCase = taskAssigneeLikeIgnoreCase.toLowerCase();
        } else {
            this.taskAssigneeLikeIgnoreCase = taskAssigneeLikeIgnoreCase.toLowerCase();
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskOwner(String taskOwner) {
        if (this.inOrStatement) {
            this.orQueryObject.taskOwner = taskOwner;
        } else {
            this.taskOwner = taskOwner;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskOwnerLike(String taskOwnerLike) {
        if (this.inOrStatement) {
            this.orQueryObject.taskOwnerLike = taskOwnerLike;
        } else {
            this.taskOwnerLike = taskOwnerLike;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskOwnerLikeIgnoreCase(String taskOwnerLikeIgnoreCase) {
        if (this.inOrStatement) {
            this.orQueryObject.taskOwnerLikeIgnoreCase = taskOwnerLikeIgnoreCase.toLowerCase();
        } else {
            this.taskOwnerLikeIgnoreCase = taskOwnerLikeIgnoreCase.toLowerCase();
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery finished() {
        if (this.inOrStatement) {
            this.orQueryObject.finished = true;
        } else {
            this.finished = true;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery unfinished() {
        if (this.inOrStatement) {
            this.orQueryObject.unfinished = true;
        } else {
            this.unfinished = true;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskVariableValueEquals(String variableName, Object variableValue) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueEquals(variableName, variableValue);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueEquals(variableName, variableValue);
    }

    @Override
    public HistoricTaskInstanceQuery taskVariableValueEquals(Object variableValue) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueEquals(variableValue);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueEquals(variableValue);
    }

    @Override
    public HistoricTaskInstanceQuery taskVariableValueEqualsIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueEqualsIgnoreCase(name, value);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueEqualsIgnoreCase(name, value);
    }

    @Override
    public HistoricTaskInstanceQuery taskVariableValueNotEqualsIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueNotEqualsIgnoreCase(name, value);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueNotEqualsIgnoreCase(name, value);
    }

    @Override
    public HistoricTaskInstanceQuery taskVariableValueNotEquals(String variableName, Object variableValue) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueNotEquals(variableName, variableValue);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueNotEquals(variableName, variableValue);
    }

    @Override
    public HistoricTaskInstanceQuery taskVariableValueGreaterThan(String name, Object value) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueGreaterThan(name, value);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueGreaterThan(name, value);
    }

    @Override
    public HistoricTaskInstanceQuery taskVariableValueGreaterThanOrEqual(String name, Object value) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueGreaterThanOrEqual(name, value);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueGreaterThanOrEqual(name, value);
    }

    @Override
    public HistoricTaskInstanceQuery taskVariableValueLessThan(String name, Object value) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueLessThan(name, value);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueLessThan(name, value);
    }

    @Override
    public HistoricTaskInstanceQuery taskVariableValueLessThanOrEqual(String name, Object value) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueLessThanOrEqual(name, value);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueLessThanOrEqual(name, value);
    }

    @Override
    public HistoricTaskInstanceQuery taskVariableValueLike(String name, String value) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueLike(name, value);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueLike(name, value);
    }

    @Override
    public HistoricTaskInstanceQuery processVariableValueEquals(String variableName, Object variableValue) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueEquals(variableName, variableValue, false);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueEquals(variableName, variableValue, false);
    }

    @Override
    public HistoricTaskInstanceQuery processVariableValueNotEquals(String variableName, Object variableValue) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueNotEquals(variableName, variableValue, false);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueNotEquals(variableName, variableValue, false);
    }

    @Override
    public HistoricTaskInstanceQuery processVariableValueEquals(Object variableValue) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueEquals(variableValue, false);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueEquals(variableValue, false);
    }

    @Override
    public HistoricTaskInstanceQuery processVariableValueEqualsIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueEqualsIgnoreCase(name, value, false);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueEqualsIgnoreCase(name, value, false);
    }

    @Override
    public HistoricTaskInstanceQuery processVariableValueNotEqualsIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueNotEqualsIgnoreCase(name, value, false);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueNotEqualsIgnoreCase(name, value, false);
    }

    @Override
    public HistoricTaskInstanceQuery processVariableValueGreaterThan(String name, Object value) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueGreaterThan(name, value, false);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueGreaterThan(name, value, false);
    }

    @Override
    public HistoricTaskInstanceQuery processVariableValueGreaterThanOrEqual(String name, Object value) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueGreaterThanOrEqual(name, value, false);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueGreaterThanOrEqual(name, value, false);
    }

    @Override
    public HistoricTaskInstanceQuery processVariableValueLessThan(String name, Object value) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueLessThan(name, value, false);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueLessThan(name, value, false);
    }

    @Override
    public HistoricTaskInstanceQuery processVariableValueLessThanOrEqual(String name, Object value) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueLessThanOrEqual(name, value, false);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueLessThanOrEqual(name, value, false);
    }

    @Override
    public HistoricTaskInstanceQuery processVariableValueLike(String name, String value) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueLike(name, value, false);
            return this;
        }
        return (HistoricTaskInstanceQuery)this.variableValueLike(name, value, false);
    }

    @Override
    public HistoricTaskInstanceQuery taskDefinitionKey(String taskDefinitionKey) {
        if (this.inOrStatement) {
            this.orQueryObject.taskDefinitionKey = taskDefinitionKey;
        } else {
            this.taskDefinitionKey = taskDefinitionKey;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskDefinitionKeyLike(String taskDefinitionKeyLike) {
        if (this.inOrStatement) {
            this.orQueryObject.taskDefinitionKeyLike = taskDefinitionKeyLike;
        } else {
            this.taskDefinitionKeyLike = taskDefinitionKeyLike;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskPriority(Integer taskPriority) {
        if (this.inOrStatement) {
            this.orQueryObject.taskPriority = taskPriority;
        } else {
            this.taskPriority = taskPriority;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskMinPriority(Integer taskMinPriority) {
        if (this.inOrStatement) {
            this.orQueryObject.taskMinPriority = taskMinPriority;
        } else {
            this.taskMinPriority = taskMinPriority;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskMaxPriority(Integer taskMaxPriority) {
        if (this.inOrStatement) {
            this.orQueryObject.taskMaxPriority = taskMaxPriority;
        } else {
            this.taskMaxPriority = taskMaxPriority;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery processFinished() {
        if (this.inOrStatement) {
            this.orQueryObject.processFinished = true;
        } else {
            this.processFinished = true;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery processUnfinished() {
        if (this.inOrStatement) {
            this.orQueryObject.processUnfinished = true;
        } else {
            this.processUnfinished = true;
        }
        return this;
    }

    @Override
    protected void ensureVariablesInitialized() {
        VariableTypes types = Context.getProcessEngineConfiguration().getVariableTypes();
        for (QueryVariableValue var : this.queryVariableValues) {
            var.initialize(types);
        }
        if (this.orQueryObject != null) {
            this.orQueryObject.ensureVariablesInitialized();
        }
    }

    @Override
    public HistoricTaskInstanceQuery taskDueDate(Date dueDate) {
        if (this.inOrStatement) {
            this.orQueryObject.dueDate = dueDate;
        } else {
            this.dueDate = dueDate;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery dueDate(Date dueDate) {
        return this.taskDueDate(dueDate);
    }

    @Override
    public HistoricTaskInstanceQuery taskDueAfter(Date dueAfter) {
        if (this.inOrStatement) {
            this.orQueryObject.dueAfter = dueAfter;
        } else {
            this.dueAfter = dueAfter;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery dueAfter(Date dueDate) {
        return this.taskDueAfter(dueDate);
    }

    @Override
    public HistoricTaskInstanceQuery taskDueBefore(Date dueBefore) {
        if (this.inOrStatement) {
            this.orQueryObject.dueBefore = dueBefore;
        } else {
            this.dueBefore = dueBefore;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery dueBefore(Date dueDate) {
        return this.taskDueBefore(dueDate);
    }

    @Override
    public HistoricTaskInstanceQuery taskCreatedOn(Date creationDate) {
        if (this.inOrStatement) {
            this.orQueryObject.creationDate = creationDate;
        } else {
            this.creationDate = creationDate;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskCreatedBefore(Date creationBeforeDate) {
        if (this.inOrStatement) {
            this.orQueryObject.creationBeforeDate = creationBeforeDate;
        } else {
            this.creationBeforeDate = creationBeforeDate;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskCreatedAfter(Date creationAfterDate) {
        if (this.inOrStatement) {
            this.orQueryObject.creationAfterDate = creationAfterDate;
        } else {
            this.creationAfterDate = creationAfterDate;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskCompletedOn(Date completedDate) {
        if (this.inOrStatement) {
            this.orQueryObject.completedDate = completedDate;
        } else {
            this.completedDate = completedDate;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskCompletedBefore(Date completedBeforeDate) {
        if (this.inOrStatement) {
            this.orQueryObject.completedBeforeDate = completedBeforeDate;
        } else {
            this.completedBeforeDate = completedBeforeDate;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskCompletedAfter(Date completedAfterDate) {
        if (this.inOrStatement) {
            this.orQueryObject.completedAfterDate = completedAfterDate;
        } else {
            this.completedAfterDate = completedAfterDate;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery withoutTaskDueDate() {
        if (this.inOrStatement) {
            this.orQueryObject.withoutDueDate = true;
        } else {
            this.withoutDueDate = true;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery withoutDueDate() {
        return this.withoutTaskDueDate();
    }

    @Override
    public HistoricTaskInstanceQuery taskCategory(String category) {
        if (this.inOrStatement) {
            this.orQueryObject.category = category;
        } else {
            this.category = category;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskCandidateUser(String candidateUser) {
        if (candidateUser == null) {
            throw new ActivitiIllegalArgumentException("Candidate user is null");
        }
        if (this.candidateGroup != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateUser and candidateGroup");
        }
        if (this.candidateGroups != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateUser and candidateGroupIn");
        }
        if (this.inOrStatement) {
            this.orQueryObject.candidateUser = candidateUser;
        } else {
            this.candidateUser = candidateUser;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskCandidateGroup(String candidateGroup) {
        if (candidateGroup == null) {
            throw new ActivitiIllegalArgumentException("Candidate group is null");
        }
        if (this.candidateUser != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateGroup and candidateUser");
        }
        if (this.candidateGroups != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateGroup and candidateGroupIn");
        }
        if (this.inOrStatement) {
            this.orQueryObject.candidateGroup = candidateGroup;
        } else {
            this.candidateGroup = candidateGroup;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskCandidateGroupIn(List<String> candidateGroups) {
        if (candidateGroups == null) {
            throw new ActivitiIllegalArgumentException("Candidate group list is null");
        }
        if (candidateGroups.isEmpty()) {
            throw new ActivitiIllegalArgumentException("Candidate group list is empty");
        }
        if (this.candidateUser != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateGroupIn and candidateUser");
        }
        if (this.candidateGroup != null) {
            throw new ActivitiIllegalArgumentException("Invalid query usage: cannot set both candidateGroupIn and candidateGroup");
        }
        if (this.inOrStatement) {
            this.orQueryObject.candidateGroups = candidateGroups;
        } else {
            this.candidateGroups = candidateGroups;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskInvolvedUser(String involvedUser) {
        if (this.inOrStatement) {
            this.orQueryObject.involvedUser = involvedUser;
        } else {
            this.involvedUser = involvedUser;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskTenantId(String tenantId) {
        if (tenantId == null) {
            throw new ActivitiIllegalArgumentException("task tenant id is null");
        }
        if (this.inOrStatement) {
            this.orQueryObject.tenantId = tenantId;
        } else {
            this.tenantId = tenantId;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new ActivitiIllegalArgumentException("task tenant id is null");
        }
        if (this.inOrStatement) {
            this.orQueryObject.tenantIdLike = tenantIdLike;
        } else {
            this.tenantIdLike = tenantIdLike;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery taskWithoutTenantId() {
        if (this.inOrStatement) {
            this.orQueryObject.withoutTenantId = true;
        } else {
            this.withoutTenantId = true;
        }
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery includeTaskLocalVariables() {
        this.includeTaskLocalVariables = true;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery includeProcessVariables() {
        this.includeProcessVariables = true;
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery or() {
        if (this.orQueryObject != null) {
            throw new ActivitiException("Only one OR statement is allowed");
        }
        this.inOrStatement = true;
        this.orQueryObject = new HistoricTaskInstanceQueryImpl();
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery endOr() {
        if (this.orQueryObject == null || !this.inOrStatement) {
            throw new ActivitiException("OR statement hasn't started, so it can't be ended");
        }
        this.inOrStatement = false;
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByTaskId() {
        this.orderBy(HistoricTaskInstanceQueryProperty.HISTORIC_TASK_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByHistoricActivityInstanceId() {
        this.orderBy(HistoricTaskInstanceQueryProperty.PROCESS_DEFINITION_ID);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByProcessDefinitionId() {
        this.orderBy(HistoricTaskInstanceQueryProperty.PROCESS_DEFINITION_ID);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByProcessInstanceId() {
        this.orderBy(HistoricTaskInstanceQueryProperty.PROCESS_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByExecutionId() {
        this.orderBy(HistoricTaskInstanceQueryProperty.EXECUTION_ID);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByHistoricTaskInstanceDuration() {
        this.orderBy(HistoricTaskInstanceQueryProperty.DURATION);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByHistoricTaskInstanceEndTime() {
        this.orderBy(HistoricTaskInstanceQueryProperty.END);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByHistoricActivityInstanceStartTime() {
        this.orderBy(HistoricTaskInstanceQueryProperty.START);
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery orderByHistoricTaskInstanceStartTime() {
        this.orderBy(HistoricTaskInstanceQueryProperty.START);
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery orderByTaskCreateTime() {
        return this.orderByHistoricTaskInstanceStartTime();
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByTaskName() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_NAME);
        return this;
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByTaskDescription() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_DESCRIPTION);
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery orderByTaskAssignee() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_ASSIGNEE);
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery orderByTaskOwner() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_OWNER);
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery orderByTaskDueDate() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_DUE_DATE);
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery orderByDueDateNullsFirst() {
        return (HistoricTaskInstanceQuery)this.orderBy(HistoricTaskInstanceQueryProperty.TASK_DUE_DATE, AbstractQuery.NullHandlingOnOrder.NULLS_FIRST);
    }

    @Override
    public HistoricTaskInstanceQuery orderByDueDateNullsLast() {
        return (HistoricTaskInstanceQuery)this.orderBy(HistoricTaskInstanceQueryProperty.TASK_DUE_DATE, AbstractQuery.NullHandlingOnOrder.NULLS_LAST);
    }

    @Override
    public HistoricTaskInstanceQueryImpl orderByDeleteReason() {
        this.orderBy(HistoricTaskInstanceQueryProperty.DELETE_REASON);
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery orderByTaskDefinitionKey() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_DEFINITION_KEY);
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery orderByTaskPriority() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TASK_PRIORITY);
        return this;
    }

    @Override
    public HistoricTaskInstanceQuery orderByTenantId() {
        this.orderBy(HistoricTaskInstanceQueryProperty.TENANT_ID_);
        return this;
    }

    @Override
    protected void checkQueryOk() {
        super.checkQueryOk();
        if (this.includeProcessVariables || this.includeTaskLocalVariables) {
            ((HistoricTaskInstanceQuery)this.orderBy(HistoricTaskInstanceQueryProperty.INCLUDED_VARIABLE_TIME)).asc();
        }
    }

    public String getMssqlOrDB2OrderBy() {
        String specialOrderBy = super.getOrderBy();
        if (specialOrderBy != null && specialOrderBy.length() > 0) {
            specialOrderBy = specialOrderBy.replace("RES.", "TEMPRES_");
            specialOrderBy = specialOrderBy.replace("VAR.", "TEMPVAR_");
        }
        return specialOrderBy;
    }

    public List<String> getCandidateGroups() {
        if (this.candidateGroup != null) {
            ArrayList<String> candidateGroupList = new ArrayList<String>(1);
            candidateGroupList.add(this.candidateGroup);
            return candidateGroupList;
        }
        if (this.candidateUser != null) {
            return this.getGroupsForCandidateUser(this.candidateUser);
        }
        if (this.candidateGroups != null) {
            return this.candidateGroups;
        }
        return null;
    }

    protected List<String> getGroupsForCandidateUser(String candidateUser) {
        List<Group> groups = Context.getCommandContext().getGroupIdentityManager().findGroupsByUser(candidateUser);
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Group group : groups) {
            groupIds.add(group.getId());
        }
        return groupIds;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getProcessInstanceBusinessKey() {
        return this.processInstanceBusinessKey;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getProcessDefinitionKeyLike() {
        return this.processDefinitionKeyLike;
    }

    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public String getProcessDefinitionNameLike() {
        return this.processDefinitionNameLike;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public List<String> getDeploymentIds() {
        return this.deploymentIds;
    }

    public String getProcessInstanceBusinessKeyLike() {
        return this.processInstanceBusinessKeyLike;
    }

    public String getTaskDefinitionKeyLike() {
        return this.taskDefinitionKeyLike;
    }

    public Integer getTaskPriority() {
        return this.taskPriority;
    }

    public Integer getTaskMinPriority() {
        return this.taskMinPriority;
    }

    public Integer getTaskMaxPriority() {
        return this.taskMaxPriority;
    }

    public boolean isProcessFinished() {
        return this.processFinished;
    }

    public boolean isProcessUnfinished() {
        return this.processUnfinished;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public Date getDueAfter() {
        return this.dueAfter;
    }

    public Date getDueBefore() {
        return this.dueBefore;
    }

    public boolean isWithoutDueDate() {
        return this.withoutDueDate;
    }

    public Date getCreationAfterDate() {
        return this.creationAfterDate;
    }

    public Date getCreationBeforeDate() {
        return this.creationBeforeDate;
    }

    public Date getCompletedDate() {
        return this.completedDate;
    }

    public Date getCompletedAfterDate() {
        return this.completedAfterDate;
    }

    public Date getCompletedBeforeDate() {
        return this.completedBeforeDate;
    }

    public String getCategory() {
        return this.category;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    public boolean isIncludeTaskLocalVariables() {
        return this.includeTaskLocalVariables;
    }

    public boolean isIncludeProcessVariables() {
        return this.includeProcessVariables;
    }

    public boolean isInOrStatement() {
        return this.inOrStatement;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isUnfinished() {
        return this.unfinished;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskNameLike() {
        return this.taskNameLike;
    }

    public List<String> getTaskNameList() {
        return this.taskNameList;
    }

    public List<String> getTaskNameListIgnoreCase() {
        return this.taskNameListIgnoreCase;
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    public String getTaskDescriptionLike() {
        return this.taskDescriptionLike;
    }

    public String getTaskDeleteReason() {
        return this.taskDeleteReason;
    }

    public String getTaskDeleteReasonLike() {
        return this.taskDeleteReasonLike;
    }

    public String getTaskAssignee() {
        return this.taskAssignee;
    }

    public String getTaskAssigneeLike() {
        return this.taskAssigneeLike;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    public String getTaskOwnerLike() {
        return this.taskOwnerLike;
    }

    public String getTaskOwner() {
        return this.taskOwner;
    }

    public String getTaskParentTaskId() {
        return this.taskParentTaskId;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getCandidateUser() {
        return this.candidateUser;
    }

    public String getCandidateGroup() {
        return this.candidateGroup;
    }

    public String getInvolvedUser() {
        return this.involvedUser;
    }

    public String getProcessDefinitionKeyLikeIgnoreCase() {
        return this.processDefinitionKeyLikeIgnoreCase;
    }

    public String getProcessInstanceBusinessKeyLikeIgnoreCase() {
        return this.processInstanceBusinessKeyLikeIgnoreCase;
    }

    public String getTaskNameLikeIgnoreCase() {
        return this.taskNameLikeIgnoreCase;
    }

    public String getTaskDescriptionLikeIgnoreCase() {
        return this.taskDescriptionLikeIgnoreCase;
    }

    public String getTaskOwnerLikeIgnoreCase() {
        return this.taskOwnerLikeIgnoreCase;
    }

    public String getTaskAssigneeLikeIgnoreCase() {
        return this.taskAssigneeLikeIgnoreCase;
    }

    public HistoricTaskInstanceQueryImpl getOrQueryObject() {
        return this.orQueryObject;
    }
}

