/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.bpmn.model.Assignment;
import org.activiti.bpmn.model.DataAssociation;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.bpmn.data.AbstractDataAssociation;
import org.activiti.engine.impl.bpmn.data.SimpleDataInputAssociation;
import org.activiti.engine.impl.bpmn.data.TransformationDataOutputAssociation;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import org.activiti.engine.impl.bpmn.webservice.MessageImplicitDataInputAssociation;
import org.activiti.engine.impl.bpmn.webservice.MessageImplicitDataOutputAssociation;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractExternalInvocationBpmnParseHandler<T extends FlowNode>
extends AbstractActivityBpmnParseHandler<T> {
    public AbstractDataAssociation createDataInputAssociation(BpmnParse bpmnParse, DataAssociation dataAssociationElement) {
        if (dataAssociationElement.getAssignments().isEmpty()) {
            return new MessageImplicitDataInputAssociation(dataAssociationElement.getSourceRef(), dataAssociationElement.getTargetRef());
        }
        SimpleDataInputAssociation dataAssociation = new SimpleDataInputAssociation(dataAssociationElement.getSourceRef(), dataAssociationElement.getTargetRef());
        for (Assignment assigmentElement : dataAssociationElement.getAssignments()) {
            if (!StringUtils.isNotEmpty((CharSequence)assigmentElement.getFrom()) || !StringUtils.isNotEmpty((CharSequence)assigmentElement.getTo())) continue;
            Expression from = bpmnParse.getExpressionManager().createExpression(assigmentElement.getFrom());
            Expression to = bpmnParse.getExpressionManager().createExpression(assigmentElement.getTo());
            org.activiti.engine.impl.bpmn.data.Assignment assignment = new org.activiti.engine.impl.bpmn.data.Assignment(from, to);
            dataAssociation.addAssignment(assignment);
        }
        return dataAssociation;
    }

    public AbstractDataAssociation createDataOutputAssociation(BpmnParse bpmnParse, DataAssociation dataAssociationElement) {
        if (StringUtils.isNotEmpty((CharSequence)dataAssociationElement.getSourceRef())) {
            return new MessageImplicitDataOutputAssociation(dataAssociationElement.getTargetRef(), dataAssociationElement.getSourceRef());
        }
        Expression transformation = bpmnParse.getExpressionManager().createExpression(dataAssociationElement.getTransformation());
        TransformationDataOutputAssociation dataOutputAssociation = new TransformationDataOutputAssociation(null, dataAssociationElement.getTargetRef(), transformation);
        return dataOutputAssociation;
    }
}

