/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.event.ActivitiEventDispatcher;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.calendar.DurationHelper;
import org.activiti.engine.impl.cfg.TransactionContext;
import org.activiti.engine.impl.cfg.TransactionState;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.JobAddedNotification;
import org.activiti.engine.impl.jobexecutor.JobExecutor;
import org.activiti.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRetryCmd
implements Command<Object> {
    private static final Logger log = LoggerFactory.getLogger((String)JobRetryCmd.class.getName());
    protected String jobId;
    protected Throwable exception;

    public JobRetryCmd(String jobId, Throwable exception) {
        this.jobId = jobId;
        this.exception = exception;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        ActivitiEventDispatcher eventDispatcher;
        JobEntity job = commandContext.getJobEntityManager().findJobById(this.jobId);
        ActivityImpl activity = this.getCurrentActivity(commandContext, job);
        if (activity == null || activity.getFailedJobRetryTimeCycleValue() == null) {
            log.error("activitiy or FailedJobRetryTimerCycleValue is null in job " + this.jobId + "'. only decrementing retries.");
            job.setRetries(job.getRetries() - 1);
            job.setLockOwner(null);
            job.setLockExpirationTime(null);
            if (job.getDuedate() == null) {
                job.setDuedate(this.calculateDueDate(commandContext, commandContext.getProcessEngineConfiguration().getAsyncFailedJobWaitTime(), null));
            } else {
                job.setDuedate(this.calculateDueDate(commandContext, commandContext.getProcessEngineConfiguration().getDefaultFailedJobWaitTime(), job.getDuedate()));
            }
        } else {
            String failedJobRetryTimeCycle = activity.getFailedJobRetryTimeCycleValue();
            try {
                DurationHelper durationHelper = new DurationHelper(failedJobRetryTimeCycle, commandContext.getProcessEngineConfiguration().getClock());
                job.setLockExpirationTime(durationHelper.getDateAfter());
                if (job.getExceptionMessage() == null) {
                    log.debug("Applying JobRetryStrategy '" + failedJobRetryTimeCycle + "' the first time for job " + job.getId() + " with " + durationHelper.getTimes() + " retries");
                    job.setRetries(durationHelper.getTimes());
                } else {
                    log.debug("Decrementing retries of JobRetryStrategy '" + failedJobRetryTimeCycle + "' for job " + job.getId());
                }
                job.setRetries(job.getRetries() - 1);
            }
            catch (Exception e) {
                throw new ActivitiException("failedJobRetryTimeCylcle has wrong format:" + failedJobRetryTimeCycle, this.exception);
            }
        }
        if (this.exception != null) {
            job.setExceptionMessage(this.exception.getMessage());
            job.setExceptionStacktrace(this.getExceptionStacktrace());
        }
        if ((eventDispatcher = commandContext.getEventDispatcher()).isEnabled()) {
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_UPDATED, job));
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.JOB_RETRIES_DECREMENTED, job));
        }
        JobExecutor jobExecutor = commandContext.getProcessEngineConfiguration().getJobExecutor();
        JobAddedNotification messageAddedNotification = new JobAddedNotification(jobExecutor);
        TransactionContext transactionContext = commandContext.getTransactionContext();
        transactionContext.addTransactionListener(TransactionState.COMMITTED, messageAddedNotification);
        return null;
    }

    protected Date calculateDueDate(CommandContext commandContext, int waitTimeInSeconds, Date oldDate) {
        GregorianCalendar newDateCal = new GregorianCalendar();
        if (oldDate != null) {
            newDateCal.setTime(oldDate);
        } else {
            newDateCal.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
        }
        ((Calendar)newDateCal).add(13, waitTimeInSeconds);
        return newDateCal.getTime();
    }

    private ActivityImpl getCurrentActivity(CommandContext commandContext, JobEntity job) {
        ExecutionEntity execution;
        String type = job.getJobHandlerType();
        ActivityImpl activity = null;
        if ("timer-transition".equals(type) || "timer-intermediate-transition".equals(type)) {
            ExecutionEntity execution2 = this.fetchExecutionEntity(commandContext, job.getExecutionId());
            if (execution2 != null) {
                activity = execution2.getProcessDefinition().findActivity(job.getJobHandlerConfiguration());
            }
        } else if ("timer-start-event".equals(type)) {
            DeploymentManager deploymentManager = commandContext.getProcessEngineConfiguration().getDeploymentManager();
            ProcessDefinitionEntity processDefinition = deploymentManager.findDeployedLatestProcessDefinitionByKeyAndTenantId(job.getJobHandlerConfiguration(), job.getTenantId());
            if (processDefinition != null) {
                activity = processDefinition.getInitial();
            }
        } else if ("async-continuation".equals(type) && (execution = this.fetchExecutionEntity(commandContext, job.getExecutionId())) != null) {
            activity = execution.getActivity();
        }
        return activity;
    }

    private String getExceptionStacktrace() {
        StringWriter stringWriter = new StringWriter();
        this.exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private ExecutionEntity fetchExecutionEntity(CommandContext commandContext, String executionId) {
        return commandContext.getExecutionEntityManager().findExecutionById(executionId);
    }
}

