/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.jobexecutor;

import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.jobexecutor.AcquireJobsRunnable;
import org.activiti.engine.impl.jobexecutor.ExecuteJobsRunnable;
import org.activiti.engine.impl.jobexecutor.JobExecutor;
import org.activiti.engine.impl.jobexecutor.LockFreeJobExecutor;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockFreeAcquireJobsRunnable
implements AcquireJobsRunnable {
    private static Logger log = LoggerFactory.getLogger(LockFreeAcquireJobsRunnable.class);
    protected final LockFreeJobExecutor jobExecutor;
    protected volatile boolean isInterrupted = false;
    protected volatile boolean isJobAdded = false;
    protected final Object MONITOR = new Object();
    protected final AtomicBoolean isWaiting = new AtomicBoolean(false);

    public LockFreeAcquireJobsRunnable(LockFreeJobExecutor jobExecutor) {
        this.jobExecutor = jobExecutor;
    }

    @Override
    public synchronized void run() {
        log.info("{} starting to acquire jobs", (Object)this.jobExecutor.getName());
        CommandExecutor commandExecutor = this.jobExecutor.getCommandExecutor();
        while (!this.isInterrupted) {
            this.isJobAdded = false;
            Integer nrOfAquiredJobs = 0;
            try {
                nrOfAquiredJobs = commandExecutor.execute(new Command<Integer>(){

                    @Override
                    public Integer execute(CommandContext commandContext) {
                        return commandContext.getJobEntityManager().updateJobLockForAllJobs(LockFreeAcquireJobsRunnable.this.jobExecutor.getLockOwner(), this.getLockExpirationTime(commandContext, LockFreeAcquireJobsRunnable.this.jobExecutor.getLockTimeInMillis()));
                    }

                    protected Date getLockExpirationTime(CommandContext commandContext, int lockTimeInMillis) {
                        GregorianCalendar gregorianCalendar = new GregorianCalendar();
                        gregorianCalendar.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
                        gregorianCalendar.add(14, lockTimeInMillis);
                        return gregorianCalendar.getTime();
                    }
                });
            }
            catch (Exception e) {
                log.warn("Error while acquiring job", (Throwable)e);
            }
            if (nrOfAquiredJobs == 0) {
                this.sleep();
            } else {
                log.debug("Wrote lock owner to {} jobs. Putting them on the queue now.", (Object)nrOfAquiredJobs);
            }
            this.putAcquiredJobsOnQueue();
        }
        log.info("{} stopped job acquisition", (Object)this.jobExecutor.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sleep() {
        long millisToWait = this.jobExecutor.getWaitTimeInMillis();
        if (millisToWait > 0L && !this.isJobAdded) {
            try {
                log.info("job acquisition thread sleeping for {} millis", (Object)millisToWait);
                Object object = this.MONITOR;
                synchronized (object) {
                    if (!this.isInterrupted) {
                        this.isWaiting.set(true);
                        this.MONITOR.wait(millisToWait);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("job acquisition thread woke up");
                }
            }
            catch (InterruptedException e) {
                if (log.isDebugEnabled()) {
                    log.debug("job acquisition wait interrupted");
                }
            }
            finally {
                this.isWaiting.set(false);
            }
        }
    }

    protected void putAcquiredJobsOnQueue() {
        int start = 0;
        List<JobEntity> jobs = this.fetchJobs(start);
        boolean refetchJobs = false;
        while (!jobs.isEmpty()) {
            int newJobCount = 0;
            for (JobEntity job : jobs) {
                try {
                    if (this.jobExecutor.isJobScheduledForExecution(job)) continue;
                    this.jobExecutor.jobScheduledForExecution(job);
                    this.jobExecutor.getThreadPoolExecutor().execute(new ExecuteJobsRunnable((JobExecutor)this.jobExecutor, job));
                    ++newJobCount;
                }
                catch (RejectedExecutionException e) {
                    this.jobExecutor.getRejectedJobsHandler().jobsRejected(this.jobExecutor, Arrays.asList(job.getId()));
                }
            }
            if (newJobCount == 0 && refetchJobs) break;
            jobs = this.fetchJobs(start += this.jobExecutor.getJobFetchBatchSize());
            if (!jobs.isEmpty()) continue;
            start = 0;
            jobs = this.fetchJobs(start);
            refetchJobs = true;
        }
    }

    protected List<JobEntity> fetchJobs(final int start) {
        return this.jobExecutor.getCommandExecutor().execute(new Command<List<JobEntity>>(){

            @Override
            public List<JobEntity> execute(CommandContext commandContext) {
                return commandContext.getJobEntityManager().findJobsByLockOwner(LockFreeAcquireJobsRunnable.this.jobExecutor.getLockOwner(), start, LockFreeAcquireJobsRunnable.this.jobExecutor.getJobFetchBatchSize());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.MONITOR;
        synchronized (object) {
            this.isInterrupted = true;
            if (this.isWaiting.compareAndSet(true, false)) {
                this.MONITOR.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jobWasAdded() {
        this.isJobAdded = true;
        if (this.isWaiting.compareAndSet(true, false)) {
            Object object = this.MONITOR;
            synchronized (object) {
                this.MONITOR.notifyAll();
            }
        }
    }
}

