/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.jobexecutor;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.activiti.engine.impl.jobexecutor.JobExecutor;
import org.activiti.engine.impl.jobexecutor.LockFreeAcquireJobsRunnable;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockFreeJobExecutor
extends JobExecutor {
    private static Logger log = LoggerFactory.getLogger(LockFreeJobExecutor.class);
    protected int corePoolSize = 2;
    protected int maxPoolSize = 10;
    protected long keepAliveTime = 0L;
    protected Set<String> currentlyProcessedJobs;
    protected Map<String, JobEntity> recentlyRemovedJobs;
    protected int queueSize = 100;
    protected int jobFetchBatchSize = 100;
    protected BlockingQueue<Runnable> threadPoolQueue;
    protected ThreadPoolExecutor threadPoolExecutor;
    protected long secondsToWaitOnShutdown = 60L;
    protected LockFreeAcquireJobsRunnable lockFreeAcquireJobsRunnable = new LockFreeAcquireJobsRunnable(this);

    public LockFreeJobExecutor() {
        this.setAcquireJobsRunnable(this.lockFreeAcquireJobsRunnable);
        this.initCurrentlyProcessedDataStructures();
    }

    @Override
    protected void startExecutingJobs() {
        if (this.threadPoolQueue == null) {
            log.info("Creating thread pool queue of size {}", (Object)this.queueSize);
            this.threadPoolQueue = new ArrayBlockingQueue<Runnable>(this.queueSize);
        }
        if (this.threadPoolExecutor == null) {
            log.info("Creating thread pool executor with corePoolSize {}, maxPoolSize {} and keepAliveTime {}", new Object[]{this.corePoolSize, this.maxPoolSize, this.keepAliveTime});
            this.threadPoolExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, this.keepAliveTime, TimeUnit.MILLISECONDS, this.threadPoolQueue);
            this.threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        }
        this.startJobAcquisitionThread();
    }

    @Override
    protected void stopExecutingJobs() {
        this.stopJobAcquisitionThread();
        this.threadPoolExecutor.shutdown();
        try {
            if (!this.threadPoolExecutor.awaitTermination(this.secondsToWaitOnShutdown, TimeUnit.SECONDS)) {
                log.warn("Timeout during shutdown of job executor. The current running jobs could not end within " + this.secondsToWaitOnShutdown + " seconds after shutdown operation.");
            }
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while shutting down the job executor. ", (Throwable)e);
        }
        this.threadPoolExecutor = null;
    }

    @Override
    public void executeJobs(List<String> jobIds) {
    }

    @Override
    protected void startJobAcquisitionThread() {
        if (this.jobAcquisitionThread == null) {
            this.jobAcquisitionThread = this.acquireJobsRunnable == null ? new Thread(new LockFreeAcquireJobsRunnable(this)) : new Thread(this.acquireJobsRunnable);
        }
        this.jobAcquisitionThread.start();
    }

    protected void initCurrentlyProcessedDataStructures() {
        int size = Math.max(this.getQueueSize(), this.getJobFetchBatchSize());
        this.currentlyProcessedJobs = Collections.synchronizedSet(new HashSet(size));
        final int recentlyRemovesJobsMaxSize = size * 2 + 1;
        this.recentlyRemovedJobs = Collections.synchronizedMap(new LinkedHashMap<String, JobEntity>(recentlyRemovesJobsMaxSize, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, JobEntity> eldest) {
                return this.size() > recentlyRemovesJobsMaxSize;
            }
        });
    }

    public void jobScheduledForExecution(JobEntity job) {
        this.currentlyProcessedJobs.add(job.getId());
    }

    public boolean isJobScheduledForExecution(JobEntity job) {
        boolean recentlyExecuted = this.currentlyProcessedJobs.contains(job.getId());
        if (recentlyExecuted) {
            return true;
        }
        return this.recentlyRemovedJobs.containsKey(job.getId());
    }

    @Override
    public void jobDone(JobEntity job) {
        this.recentlyRemovedJobs.put(job.getId(), job);
        this.currentlyProcessedJobs.remove(job.getId());
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
        this.initCurrentlyProcessedDataStructures();
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public long getSecondsToWaitOnShutdown() {
        return this.secondsToWaitOnShutdown;
    }

    public void setSecondsToWaitOnShutdown(long secondsToWaitOnShutdown) {
        this.secondsToWaitOnShutdown = secondsToWaitOnShutdown;
    }

    public BlockingQueue<Runnable> getThreadPoolQueue() {
        return this.threadPoolQueue;
    }

    public void setThreadPoolQueue(BlockingQueue<Runnable> threadPoolQueue) {
        this.threadPoolQueue = threadPoolQueue;
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    public int getJobFetchBatchSize() {
        return this.jobFetchBatchSize;
    }

    public void setJobFetchBatchSize(int jobFetchBatchSize) {
        this.jobFetchBatchSize = jobFetchBatchSize;
        this.initCurrentlyProcessedDataStructures();
    }

    public Set<String> getCurrentlyProcessedJobs() {
        return this.currentlyProcessedJobs;
    }

    public void setCurrentlyProcessedJobs(Set<String> currentlyProcessedJobs) {
        this.currentlyProcessedJobs = currentlyProcessedJobs;
    }

    public Map<String, JobEntity> getRecentlyRemovedJobs() {
        return this.recentlyRemovedJobs;
    }

    public void setRecentlyRemovedJobs(Map<String, JobEntity> recentlyRemovedJobs) {
        this.recentlyRemovedJobs = recentlyRemovedJobs;
    }
}

