/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricProcessInstanceQuery;
import org.activiti.engine.impl.AbstractVariableQueryImpl;
import org.activiti.engine.impl.HistoricProcessInstanceQueryProperty;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;

public class HistoricProcessInstanceQueryImpl
extends AbstractVariableQueryImpl<HistoricProcessInstanceQuery, HistoricProcessInstance>
implements HistoricProcessInstanceQuery {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String businessKey;
    protected String deploymentId;
    protected List<String> deploymentIds;
    protected boolean finished = false;
    protected boolean unfinished = false;
    protected boolean deleted = false;
    protected boolean notDeleted = false;
    protected String startedBy;
    protected String superProcessInstanceId;
    protected boolean excludeSubprocesses;
    protected List<String> processKeyNotIn;
    protected Date startedBefore;
    protected Date startedAfter;
    protected Date finishedBefore;
    protected Date finishedAfter;
    protected String processDefinitionKey;
    protected Set<String> processInstanceIds;
    protected String involvedUser;
    protected boolean includeProcessVariables;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;
    protected String name;
    protected String nameLike;
    protected String nameLikeIgnoreCase;
    protected HistoricProcessInstanceQueryImpl orQueryObject;
    protected boolean inOrStatement = false;

    public HistoricProcessInstanceQueryImpl() {
    }

    public HistoricProcessInstanceQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public HistoricProcessInstanceQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public HistoricProcessInstanceQueryImpl processInstanceId(String processInstanceId) {
        if (this.inOrStatement) {
            this.orQueryObject.processInstanceId = processInstanceId;
        } else {
            this.processInstanceId = processInstanceId;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceIds(Set<String> processInstanceIds) {
        if (processInstanceIds == null) {
            throw new ActivitiIllegalArgumentException("Set of process instance ids is null");
        }
        if (processInstanceIds.isEmpty()) {
            throw new ActivitiIllegalArgumentException("Set of process instance ids is empty");
        }
        if (this.inOrStatement) {
            this.orQueryObject.processInstanceIds = processInstanceIds;
        } else {
            this.processInstanceIds = processInstanceIds;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQueryImpl processDefinitionId(String processDefinitionId) {
        if (this.inOrStatement) {
            this.orQueryObject.processDefinitionId = processDefinitionId;
        } else {
            this.processDefinitionId = processDefinitionId;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processDefinitionKey(String processDefinitionKey) {
        if (this.inOrStatement) {
            this.orQueryObject.processDefinitionKey = processDefinitionKey;
        } else {
            this.processDefinitionKey = processDefinitionKey;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceBusinessKey(String businessKey) {
        if (this.inOrStatement) {
            this.orQueryObject.businessKey = businessKey;
        } else {
            this.businessKey = businessKey;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery deploymentId(String deploymentId) {
        if (this.inOrStatement) {
            this.orQueryObject.deploymentId = deploymentId;
        } else {
            this.deploymentId = deploymentId;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery deploymentIdIn(List<String> deploymentIds) {
        if (this.inOrStatement) {
            this.orQueryObject.deploymentIds = deploymentIds;
        } else {
            this.deploymentIds = deploymentIds;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery finished() {
        if (this.inOrStatement) {
            this.orQueryObject.finished = true;
        } else {
            this.finished = true;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery unfinished() {
        if (this.inOrStatement) {
            this.orQueryObject.unfinished = true;
        } else {
            this.unfinished = true;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery deleted() {
        if (this.inOrStatement) {
            this.orQueryObject.deleted = true;
        } else {
            this.deleted = true;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery notDeleted() {
        if (this.inOrStatement) {
            this.orQueryObject.notDeleted = true;
        } else {
            this.notDeleted = true;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery startedBy(String startedBy) {
        if (this.inOrStatement) {
            this.orQueryObject.startedBy = startedBy;
        } else {
            this.startedBy = startedBy;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processDefinitionKeyNotIn(List<String> processDefinitionKeys) {
        if (this.inOrStatement) {
            this.orQueryObject.processKeyNotIn = processDefinitionKeys;
        } else {
            this.processKeyNotIn = processDefinitionKeys;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery startedAfter(Date startedAfter) {
        if (this.inOrStatement) {
            this.orQueryObject.startedAfter = startedAfter;
        } else {
            this.startedAfter = startedAfter;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery startedBefore(Date startedBefore) {
        if (this.inOrStatement) {
            this.orQueryObject.startedBefore = startedBefore;
        } else {
            this.startedBefore = startedBefore;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery finishedAfter(Date finishedAfter) {
        if (this.inOrStatement) {
            this.orQueryObject.finishedAfter = finishedAfter;
        } else {
            this.finishedAfter = finishedAfter;
            this.finished = true;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery finishedBefore(Date finishedBefore) {
        if (this.inOrStatement) {
            this.orQueryObject.finishedBefore = finishedBefore;
        } else {
            this.finishedBefore = finishedBefore;
            this.finished = true;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery superProcessInstanceId(String superProcessInstanceId) {
        if (this.inOrStatement) {
            this.orQueryObject.superProcessInstanceId = superProcessInstanceId;
        } else {
            this.superProcessInstanceId = superProcessInstanceId;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery excludeSubprocesses(boolean excludeSubprocesses) {
        if (this.inOrStatement) {
            this.orQueryObject.excludeSubprocesses = excludeSubprocesses;
        } else {
            this.excludeSubprocesses = excludeSubprocesses;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery involvedUser(String involvedUser) {
        if (this.inOrStatement) {
            this.orQueryObject.involvedUser = involvedUser;
        } else {
            this.involvedUser = involvedUser;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery includeProcessVariables() {
        this.includeProcessVariables = true;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceTenantId(String tenantId) {
        if (tenantId == null) {
            throw new ActivitiIllegalArgumentException("process instance tenant id is null");
        }
        if (this.inOrStatement) {
            this.orQueryObject.tenantId = tenantId;
        } else {
            this.tenantId = tenantId;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new ActivitiIllegalArgumentException("process instance tenant id is null");
        }
        if (this.inOrStatement) {
            this.orQueryObject.tenantIdLike = tenantIdLike;
        } else {
            this.tenantIdLike = tenantIdLike;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceWithoutTenantId() {
        if (this.inOrStatement) {
            this.orQueryObject.withoutTenantId = true;
        } else {
            this.withoutTenantId = true;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceName(String name) {
        if (this.inOrStatement) {
            this.orQueryObject.name = name;
        } else {
            this.name = name;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceNameLike(String nameLike) {
        if (this.inOrStatement) {
            this.orQueryObject.nameLike = nameLike;
        } else {
            this.nameLike = nameLike;
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceNameLikeIgnoreCase(String nameLikeIgnoreCase) {
        if (this.inOrStatement) {
            this.orQueryObject.nameLikeIgnoreCase = nameLikeIgnoreCase.toLowerCase();
        } else {
            this.nameLikeIgnoreCase = nameLikeIgnoreCase.toLowerCase();
        }
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery variableValueEquals(String variableName, Object variableValue) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueEquals(variableName, variableValue, true);
            return this;
        }
        return (HistoricProcessInstanceQuery)this.variableValueEquals(variableName, variableValue, true);
    }

    @Override
    public HistoricProcessInstanceQuery variableValueNotEquals(String variableName, Object variableValue) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueNotEquals(variableName, variableValue, true);
            return this;
        }
        return (HistoricProcessInstanceQuery)this.variableValueNotEquals(variableName, variableValue, true);
    }

    @Override
    public HistoricProcessInstanceQuery variableValueEquals(Object variableValue) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueEquals(variableValue, true);
            return this;
        }
        return (HistoricProcessInstanceQuery)this.variableValueEquals(variableValue, true);
    }

    @Override
    public HistoricProcessInstanceQuery variableValueEqualsIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueEqualsIgnoreCase(name, value, true);
            return this;
        }
        return (HistoricProcessInstanceQuery)this.variableValueEqualsIgnoreCase(name, value, true);
    }

    @Override
    public HistoricProcessInstanceQuery variableValueNotEqualsIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueNotEqualsIgnoreCase(name, value, true);
            return this;
        }
        return (HistoricProcessInstanceQuery)this.variableValueNotEqualsIgnoreCase(name, value, true);
    }

    @Override
    public HistoricProcessInstanceQuery variableValueGreaterThan(String name, Object value) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueGreaterThan(name, value, true);
            return this;
        }
        return (HistoricProcessInstanceQuery)this.variableValueGreaterThan(name, value, true);
    }

    @Override
    public HistoricProcessInstanceQuery variableValueGreaterThanOrEqual(String name, Object value) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueGreaterThanOrEqual(name, value, true);
            return this;
        }
        return (HistoricProcessInstanceQuery)this.variableValueGreaterThanOrEqual(name, value, true);
    }

    @Override
    public HistoricProcessInstanceQuery variableValueLessThan(String name, Object value) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueLessThan(name, value, true);
            return this;
        }
        return (HistoricProcessInstanceQuery)this.variableValueLessThan(name, value, true);
    }

    @Override
    public HistoricProcessInstanceQuery variableValueLessThanOrEqual(String name, Object value) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueLessThanOrEqual(name, value, true);
            return this;
        }
        return (HistoricProcessInstanceQuery)this.variableValueLessThanOrEqual(name, value, true);
    }

    @Override
    public HistoricProcessInstanceQuery variableValueLike(String name, String value) {
        if (this.inOrStatement) {
            this.orQueryObject.variableValueLike(name, value, true);
            return this;
        }
        return (HistoricProcessInstanceQuery)this.variableValueLike(name, value, true);
    }

    @Override
    public HistoricProcessInstanceQuery or() {
        if (this.orQueryObject != null) {
            throw new ActivitiException("Only one OR statement is allowed");
        }
        this.inOrStatement = true;
        this.orQueryObject = new HistoricProcessInstanceQueryImpl();
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery endOr() {
        if (this.orQueryObject == null || !this.inOrStatement) {
            throw new ActivitiException("OR statement hasn't started, so it can't be ended");
        }
        this.inOrStatement = false;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessInstanceBusinessKey() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.BUSINESS_KEY);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessInstanceDuration() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.DURATION);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessInstanceStartTime() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.START_TIME);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessInstanceEndTime() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.END_TIME);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessDefinitionId() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.PROCESS_DEFINITION_ID);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessInstanceId() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.PROCESS_INSTANCE_ID_);
    }

    @Override
    public HistoricProcessInstanceQuery orderByTenantId() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.TENANT_ID);
    }

    public String getMssqlOrDB2OrderBy() {
        String specialOrderBy = super.getOrderBy();
        if (specialOrderBy != null && specialOrderBy.length() > 0) {
            specialOrderBy = specialOrderBy.replace("RES.", "TEMPRES_");
            specialOrderBy = specialOrderBy.replace("VAR.", "TEMPVAR_");
        }
        return specialOrderBy;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        return commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstanceCountByQueryCriteria(this);
    }

    @Override
    public List<HistoricProcessInstance> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        if (this.includeProcessVariables) {
            return commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstancesAndVariablesByQueryCriteria(this);
        }
        return commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstancesByQueryCriteria(this);
    }

    @Override
    protected void ensureVariablesInitialized() {
        super.ensureVariablesInitialized();
        if (this.orQueryObject != null) {
            this.orQueryObject.ensureVariablesInitialized();
        }
    }

    @Override
    protected void checkQueryOk() {
        super.checkQueryOk();
        if (this.includeProcessVariables) {
            ((HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.INCLUDED_VARIABLE_TIME)).asc();
        }
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public boolean isOpen() {
        return this.unfinished;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getProcessDefinitionIdLike() {
        return this.processDefinitionKey + ":%:%";
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public Set<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public String getStartedBy() {
        return this.startedBy;
    }

    public String getSuperProcessInstanceId() {
        return this.superProcessInstanceId;
    }

    public boolean isExcludeSubprocesses() {
        return this.excludeSubprocesses;
    }

    public List<String> getProcessKeyNotIn() {
        return this.processKeyNotIn;
    }

    public Date getStartedAfter() {
        return this.startedAfter;
    }

    public Date getStartedBefore() {
        return this.startedBefore;
    }

    public Date getFinishedAfter() {
        return this.finishedAfter;
    }

    public Date getFinishedBefore() {
        return this.finishedBefore;
    }

    public String getInvolvedUser() {
        return this.involvedUser;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public static long getSerialversionuid() {
        return 1L;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public List<String> getDeploymentIds() {
        return this.deploymentIds;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isUnfinished() {
        return this.unfinished;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isNotDeleted() {
        return this.notDeleted;
    }

    public boolean isIncludeProcessVariables() {
        return this.includeProcessVariables;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    public String getNameLikeIgnoreCase() {
        return this.nameLikeIgnoreCase;
    }

    public HistoricProcessInstanceQueryImpl getOrQueryObject() {
        return this.orQueryObject;
    }
}

