/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.asyncexecutor;

import org.activiti.engine.ActivitiOptimisticLockingException;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.cmd.ExecuteAsyncJobCmd;
import org.activiti.engine.impl.cmd.LockExclusiveJobCmd;
import org.activiti.engine.impl.cmd.UnlockExclusiveJobCmd;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandConfig;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.jobexecutor.FailedJobCommandFactory;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteAsyncRunnable
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(ExecuteAsyncRunnable.class);
    protected JobEntity job;
    protected CommandExecutor commandExecutor;

    public ExecuteAsyncRunnable(JobEntity job, CommandExecutor commandExecutor) {
        this.job = job;
        this.commandExecutor = commandExecutor;
    }

    @Override
    public void run() {
        CommandContext commandContext = Context.getCommandContext();
        try {
            if (this.job.isExclusive()) {
                this.commandExecutor.execute(new LockExclusiveJobCmd(this.job));
            }
        }
        catch (ActivitiOptimisticLockingException optimisticLockingException) {
            if (log.isDebugEnabled()) {
                log.debug("Optimistic locking exception during exclusive job acquisition. If you have multiple job executors running against the same database, this exception means that this thread tried to acquire an exclusive job, which already was changed by another async executor thread.This is expected behavior in a clustered environment. You can ignore this message if you indeed have multiple job executor acquisition threads running against the same database. Exception message: {}", (Object)optimisticLockingException.getMessage());
            }
            commandContext.getJobEntityManager().retryAsyncJob(this.job);
            return;
        }
        catch (Throwable t) {
            log.error("Error while locking exclusive job " + this.job.getId(), t);
            return;
        }
        try {
            this.commandExecutor.execute(new ExecuteAsyncJobCmd(this.job));
        }
        catch (ActivitiOptimisticLockingException e) {
            this.handleFailedJob(e);
            if (log.isDebugEnabled()) {
                log.debug("Optimistic locking exception during job execution. If you have multiple async executors running against the same database, this exception means that this thread tried to acquire an exclusive job, which already was changed by another async executor thread.This is expected behavior in a clustered environment. You can ignore this message if you indeed have multiple job executor threads running against the same database. Exception message: {}", (Object)e.getMessage());
            }
        }
        catch (Throwable exception) {
            this.handleFailedJob(exception);
            String message = "Job " + this.job.getId() + " failed";
            log.error(message, exception);
        }
        try {
            if (this.job.isExclusive()) {
                this.commandExecutor.execute(new UnlockExclusiveJobCmd(this.job));
            }
        }
        catch (ActivitiOptimisticLockingException optimisticLockingException) {
            if (log.isDebugEnabled()) {
                log.debug("Optimistic locking exception while unlocking the job. If you have multiple async executors running against the same database, this exception means that this thread tried to acquire an exclusive job, which already was changed by another async executor thread.This is expected behavior in a clustered environment. You can ignore this message if you indeed have multiple job executor acquisition threads running against the same database. Exception message: {}", (Object)optimisticLockingException.getMessage());
            }
            return;
        }
        catch (Throwable t) {
            log.error("Error while unlocking exclusive job " + this.job.getId(), t);
            return;
        }
    }

    protected void handleFailedJob(final Throwable exception) {
        this.commandExecutor.execute(new Command<Void>(){

            @Override
            public Void execute(CommandContext commandContext) {
                CommandConfig commandConfig = ExecuteAsyncRunnable.this.commandExecutor.getDefaultConfig().transactionRequiresNew();
                FailedJobCommandFactory failedJobCommandFactory = commandContext.getFailedJobCommandFactory();
                Command<Object> cmd = failedJobCommandFactory.getCommand(ExecuteAsyncRunnable.this.job.getId(), exception);
                log.trace("Using FailedJobCommandFactory '" + failedJobCommandFactory.getClass() + "' and command of type '" + cmd.getClass() + "'");
                ExecuteAsyncRunnable.this.commandExecutor.execute(commandConfig, cmd);
                if (commandContext.getEventDispatcher().isEnabled()) {
                    try {
                        commandContext.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityExceptionEvent(ActivitiEventType.JOB_EXECUTION_FAILURE, ExecuteAsyncRunnable.this.job, exception));
                    }
                    catch (Throwable ignore) {
                        log.warn("Exception occured while dispatching job failure event, ignoring.", ignore);
                    }
                }
                return null;
            }
        });
    }
}

