/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.JobQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.asyncexecutor.AsyncExecutor;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.cfg.TransactionState;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.jobexecutor.AsyncJobAddedNotification;
import org.activiti.engine.impl.jobexecutor.JobAddedNotification;
import org.activiti.engine.impl.jobexecutor.JobExecutor;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.persistence.entity.MessageEntity;
import org.activiti.engine.impl.persistence.entity.TimerEntity;
import org.activiti.engine.runtime.Job;

public class JobEntityManager
extends AbstractManager {
    public void send(MessageEntity message) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (processEngineConfiguration.isAsyncExecutorEnabled()) {
            Date dueDate = new Date(processEngineConfiguration.getClock().getCurrentTime().getTime() + (long)processEngineConfiguration.getAsyncExecutor().getAsyncJobLockTimeInMillis());
            message.setDuedate(dueDate);
            message.setLockExpirationTime(null);
        } else if (!processEngineConfiguration.isJobExecutorActivate()) {
            message.setDuedate(processEngineConfiguration.getClock().getCurrentTime());
            message.setLockExpirationTime(null);
        }
        message.insert();
        if (processEngineConfiguration.isAsyncExecutorEnabled()) {
            this.hintAsyncExecutor(message);
        } else {
            this.hintJobExecutor(message);
        }
    }

    public void schedule(TimerEntity timer) {
        Date duedate = timer.getDuedate();
        if (duedate == null) {
            throw new ActivitiIllegalArgumentException("duedate is null");
        }
        timer.insert();
        ProcessEngineConfigurationImpl engineConfiguration = Context.getProcessEngineConfiguration();
        if (!engineConfiguration.isAsyncExecutorEnabled() && timer.getDuedate().getTime() <= engineConfiguration.getClock().getCurrentTime().getTime()) {
            this.hintJobExecutor(timer);
        }
    }

    public void retryAsyncJob(JobEntity job) {
        AsyncExecutor asyncExecutor = Context.getProcessEngineConfiguration().getAsyncExecutor();
        asyncExecutor.executeAsyncJob(job);
    }

    protected void hintAsyncExecutor(JobEntity job) {
        AsyncExecutor asyncExecutor = Context.getProcessEngineConfiguration().getAsyncExecutor();
        AsyncJobAddedNotification transactionListener = new AsyncJobAddedNotification(job, asyncExecutor);
        Context.getCommandContext().getTransactionContext().addTransactionListener(TransactionState.COMMITTED, transactionListener);
    }

    protected void hintJobExecutor(JobEntity job) {
        JobExecutor jobExecutor = Context.getProcessEngineConfiguration().getJobExecutor();
        JobAddedNotification transactionListener = new JobAddedNotification(jobExecutor);
        Context.getCommandContext().getTransactionContext().addTransactionListener(TransactionState.COMMITTED, transactionListener);
    }

    public void cancelTimers(ExecutionEntity execution) {
        List<TimerEntity> timers = Context.getCommandContext().getJobEntityManager().findTimersByExecutionId(execution.getId());
        for (TimerEntity timer : timers) {
            if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.JOB_CANCELED, timer));
            }
            timer.delete();
        }
    }

    public JobEntity findJobById(String jobId) {
        return (JobEntity)this.getDbSqlSession().selectOne("selectJob", jobId);
    }

    public List<JobEntity> findNextJobsToExecute(Page page) {
        ProcessEngineConfigurationImpl processEngineConfig = Context.getProcessEngineConfiguration();
        Date now = processEngineConfig.getClock().getCurrentTime();
        return this.getDbSqlSession().selectList("selectNextJobsToExecute", now, page);
    }

    public List<JobEntity> findNextTimerJobsToExecute(Page page) {
        ProcessEngineConfigurationImpl processEngineConfig = Context.getProcessEngineConfiguration();
        Date now = processEngineConfig.getClock().getCurrentTime();
        return this.getDbSqlSession().selectList("selectNextTimerJobsToExecute", now, page);
    }

    public List<JobEntity> findAsyncJobsDueToExecute(Page page) {
        ProcessEngineConfigurationImpl processEngineConfig = Context.getProcessEngineConfiguration();
        Date now = processEngineConfig.getClock().getCurrentTime();
        return this.getDbSqlSession().selectList("selectAsyncJobsDueToExecute", now, page);
    }

    public List<JobEntity> findJobsByLockOwner(String lockOwner, int start, int maxNrOfJobs) {
        return this.getDbSqlSession().selectList("selectJobsByLockOwner", lockOwner, start, maxNrOfJobs);
    }

    public List<Job> findJobsByExecutionId(String executionId) {
        return this.getDbSqlSession().selectList("selectJobsByExecutionId", executionId);
    }

    public List<JobEntity> findExclusiveJobsToExecute(String processInstanceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pid", processInstanceId);
        params.put("now", Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        return this.getDbSqlSession().selectList("selectExclusiveJobsToExecute", params);
    }

    public List<TimerEntity> findUnlockedTimersByDuedate(Date duedate, Page page) {
        String query = "selectUnlockedTimersByDuedate";
        return this.getDbSqlSession().selectList("selectUnlockedTimersByDuedate", duedate, page);
    }

    public List<TimerEntity> findTimersByExecutionId(String executionId) {
        return this.getDbSqlSession().selectList("selectTimersByExecutionId", executionId);
    }

    public List<Job> findJobsByQueryCriteria(JobQueryImpl jobQuery, Page page) {
        String query = "selectJobByQueryCriteria";
        return this.getDbSqlSession().selectList("selectJobByQueryCriteria", jobQuery, page);
    }

    public List<Job> findJobsByConfiguration(String jobHandlerType, String jobHandlerConfiguration) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("handlerType", jobHandlerType);
        params.put("handlerConfiguration", jobHandlerConfiguration);
        return this.getDbSqlSession().selectList("selectJobsByConfiguration", params);
    }

    public long findJobCountByQueryCriteria(JobQueryImpl jobQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectJobCountByQueryCriteria", jobQuery);
    }

    public void updateJobTenantIdForDeployment(String deploymentId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("tenantId", newTenantId);
        this.getDbSqlSession().update("updateJobTenantIdForDeployment", params);
    }

    public int updateJobLockForAllJobs(String lockOwner, Date expirationTime) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("lockOwner", lockOwner);
        params.put("lockExpirationTime", expirationTime);
        params.put("dueDate", Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        return this.getDbSqlSession().update("updateJobLockForAllJobs", params);
    }
}

