/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.form;

import java.io.Serializable;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.form.AbstractFormType;
import org.activiti.engine.form.FormProperty;
import org.activiti.engine.impl.el.NoExecutionVariableScope;
import org.activiti.engine.impl.form.FormPropertyImpl;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;

public class FormPropertyHandler
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String name;
    protected AbstractFormType type;
    protected boolean isReadable;
    protected boolean isWritable;
    protected boolean isRequired;
    protected String variableName;
    protected Expression variableExpression;
    protected Expression defaultExpression;

    public FormProperty createFormProperty(ExecutionEntity execution) {
        FormPropertyImpl formProperty = new FormPropertyImpl(this);
        Object modelValue = null;
        if (execution != null) {
            if (this.variableName != null || this.variableExpression == null) {
                String varName;
                String string = varName = this.variableName != null ? this.variableName : this.id;
                if (execution.hasVariable(varName)) {
                    modelValue = execution.getVariable(varName);
                } else if (this.defaultExpression != null) {
                    modelValue = this.defaultExpression.getValue(execution);
                }
            } else {
                modelValue = this.variableExpression.getValue(execution);
            }
        } else if (this.defaultExpression != null) {
            modelValue = this.defaultExpression.getValue(NoExecutionVariableScope.getSharedInstance());
        }
        if (modelValue instanceof String) {
            formProperty.setValue((String)modelValue);
        } else if (this.type != null) {
            String formValue = this.type.convertModelValueToFormValue(modelValue);
            formProperty.setValue(formValue);
        } else if (modelValue != null) {
            formProperty.setValue(modelValue.toString());
        }
        return formProperty;
    }

    public void submitFormProperty(ExecutionEntity execution, Map<String, String> properties) {
        if (!this.isWritable && properties.containsKey(this.id)) {
            throw new ActivitiException("form property '" + this.id + "' is not writable");
        }
        if (this.isRequired && !properties.containsKey(this.id) && this.defaultExpression == null) {
            throw new ActivitiException("form property '" + this.id + "' is required");
        }
        boolean propertyExits = false;
        Object modelValue = null;
        if (properties.containsKey(this.id)) {
            propertyExits = true;
            String propertyValue = properties.remove(this.id);
            modelValue = this.type != null ? this.type.convertFormValueToModelValue(propertyValue) : propertyValue;
        } else if (this.defaultExpression != null) {
            Object expressionValue = this.defaultExpression.getValue(execution);
            if (this.type != null && expressionValue != null) {
                modelValue = this.type.convertFormValueToModelValue(expressionValue.toString());
            } else if (expressionValue != null) {
                modelValue = expressionValue.toString();
            } else if (this.isRequired) {
                throw new ActivitiException("form property '" + this.id + "' is required");
            }
        }
        if (propertyExits || modelValue != null) {
            if (this.variableName != null) {
                execution.setVariable(this.variableName, modelValue);
            } else if (this.variableExpression != null) {
                this.variableExpression.setValue(modelValue, execution);
            } else {
                execution.setVariable(this.id, modelValue);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AbstractFormType getType() {
        return this.type;
    }

    public void setType(AbstractFormType type) {
        this.type = type;
    }

    public boolean isReadable() {
        return this.isReadable;
    }

    public void setReadable(boolean isReadable) {
        this.isReadable = isReadable;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public Expression getVariableExpression() {
        return this.variableExpression;
    }

    public void setVariableExpression(Expression variableExpression) {
        this.variableExpression = variableExpression;
    }

    public Expression getDefaultExpression() {
        return this.defaultExpression;
    }

    public void setDefaultExpression(Expression defaultExpression) {
        this.defaultExpression = defaultExpression;
    }

    public boolean isWritable() {
        return this.isWritable;
    }

    public void setWritable(boolean isWritable) {
        this.isWritable = isWritable;
    }
}

