/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.TerminateEventDefinition;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.ScopeUtil;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;

public class TerminateEndEventActivityBehavior
extends FlowNodeActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected EndEvent endEvent;
    protected boolean terminateAll;

    public TerminateEndEventActivityBehavior(EndEvent endEvent) {
        this.endEvent = endEvent.clone();
        if (endEvent.getEventDefinitions() != null) {
            for (EventDefinition eventDefinition : endEvent.getEventDefinitions()) {
                TerminateEventDefinition terminateEventDefinition;
                if (!(eventDefinition instanceof TerminateEventDefinition) || !(terminateEventDefinition = (TerminateEventDefinition)eventDefinition).isTerminateAll()) continue;
                this.terminateAll = true;
                break;
            }
        }
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        ActivityImpl terminateEndEventActivity = (ActivityImpl)execution.getActivity();
        if (this.terminateAll) {
            ActivityExecution processInstanceExecution = this.findProcessInstanceExecution(execution);
            this.terminateProcessInstanceExecution(execution, terminateEndEventActivity, processInstanceExecution);
        } else {
            ActivityExecution scopeExecution = ScopeUtil.findScopeExecution(execution);
            this.terminateExecution(execution, terminateEndEventActivity, scopeExecution);
        }
    }

    protected ActivityExecution findProcessInstanceExecution(ActivityExecution execution) {
        ActivityExecution currentExecution = execution;
        while (currentExecution.getParent() != null) {
            currentExecution = currentExecution.getParent();
        }
        return currentExecution;
    }

    protected void terminateExecution(ActivityExecution execution, ActivityImpl terminateEndEventActivity, ActivityExecution scopeExecution) {
        this.sendCancelledEvent(execution, terminateEndEventActivity, scopeExecution);
        scopeExecution.destroyScope("terminate end event fired");
        ((InterpretableExecution)scopeExecution).setActivity(terminateEndEventActivity);
        scopeExecution.end();
    }

    protected void terminateProcessInstanceExecution(ActivityExecution execution, ActivityImpl terminateEndEventActivity, ActivityExecution processInstanceExecution) {
        this.sendCancelledEvent(execution, terminateEndEventActivity, processInstanceExecution);
        this.deleteProcessInstance((ExecutionEntity)processInstanceExecution, "terminate end event (" + terminateEndEventActivity.getId() + ")");
    }

    protected void deleteProcessInstance(ExecutionEntity processInstanceExecution, String deleteReason) {
        List<ExecutionEntity> orderedExecutions = this.orderExecutionsRootToLeaf(processInstanceExecution);
        Collections.reverse(orderedExecutions);
        for (ExecutionEntity executionToDelete : orderedExecutions) {
            executionToDelete.setDeleteReason(deleteReason);
            executionToDelete.setEnded(true);
            executionToDelete.setActive(false);
            executionToDelete.setDeleteRoot(true);
            executionToDelete.remove();
        }
    }

    protected List<ExecutionEntity> orderExecutionsRootToLeaf(ExecutionEntity execution) {
        ExecutionEntity rootExecution = execution;
        while (rootExecution.getParent() != null || rootExecution.getSuperExecution() != null) {
            rootExecution = rootExecution.getParent() != null ? rootExecution.getParent() : rootExecution.getSuperExecution();
        }
        return this.orderExecutionsRootToLeaf(rootExecution, new ArrayList<ExecutionEntity>());
    }

    protected List<ExecutionEntity> orderExecutionsRootToLeaf(ExecutionEntity rootExecution, List<ExecutionEntity> orderedExecutions) {
        orderedExecutions.add(rootExecution);
        if (rootExecution.getExecutions() != null && rootExecution.getExecutions().size() > 0) {
            for (ExecutionEntity childExecution : rootExecution.getExecutions()) {
                this.orderExecutionsRootToLeaf(childExecution, orderedExecutions);
            }
        }
        if (rootExecution.getSubProcessInstance() != null) {
            this.orderExecutionsRootToLeaf(rootExecution.getSubProcessInstance(), orderedExecutions);
        }
        return orderedExecutions;
    }

    protected void sendCancelledEvent(ActivityExecution execution, ActivityImpl terminateEndEventActivity, ActivityExecution scopeExecution) {
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createCancelledEvent(execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), terminateEndEventActivity));
        }
        this.dispatchExecutionCancelled(scopeExecution, terminateEndEventActivity);
    }

    private void dispatchExecutionCancelled(ActivityExecution execution, ActivityImpl causeActivity) {
        ActivityImpl activityImpl;
        for (ActivityExecution activityExecution : execution.getExecutions()) {
            this.dispatchExecutionCancelled(activityExecution, causeActivity);
        }
        ExecutionEntity subProcessInstance = Context.getCommandContext().getExecutionEntityManager().findSubProcessInstanceBySuperExecutionId(execution.getId());
        if (subProcessInstance != null) {
            this.dispatchExecutionCancelled(subProcessInstance, causeActivity);
        }
        if ((activityImpl = (ActivityImpl)execution.getActivity()) != null && activityImpl.getActivityBehavior() != null && activityImpl != causeActivity) {
            this.dispatchActivityCancelled(execution, activityImpl, causeActivity);
        }
    }

    protected void dispatchActivityCancelled(ActivityExecution execution, ActivityImpl activity, ActivityImpl causeActivity) {
        Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityCancelledEvent(activity.getId(), (String)activity.getProperties().get("name"), execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), (String)activity.getProperties().get("type"), activity.getActivityBehavior().getClass().getCanonicalName(), causeActivity));
    }

    public EndEvent getEndEvent() {
        return this.endEvent;
    }
}

