/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.HistoricTaskInstanceQueryImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.history.HistoryLevel;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;

public class HistoricTaskInstanceEntityManager
extends AbstractManager {
    public void deleteHistoricTaskInstancesByProcessInstanceId(String processInstanceId) {
        if (this.getHistoryManager().isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            List taskInstanceIds = this.getDbSqlSession().selectList("selectHistoricTaskInstanceIdsByProcessInstanceId", processInstanceId);
            for (String taskInstanceId : taskInstanceIds) {
                this.deleteHistoricTaskInstanceById(taskInstanceId);
            }
        }
    }

    public long findHistoricTaskInstanceCountByQueryCriteria(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            return (Long)this.getDbSqlSession().selectOne("selectHistoricTaskInstanceCountByQueryCriteria", historicTaskInstanceQuery);
        }
        return 0L;
    }

    public List<HistoricTaskInstance> findHistoricTaskInstancesByQueryCriteria(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            return this.getDbSqlSession().selectList("selectHistoricTaskInstancesByQueryCriteria", historicTaskInstanceQuery);
        }
        return Collections.EMPTY_LIST;
    }

    public List<HistoricTaskInstance> findHistoricTaskInstancesAndVariablesByQueryCriteria(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            if (historicTaskInstanceQuery.getFirstResult() < 0 || historicTaskInstanceQuery.getMaxResults() <= 0) {
                return Collections.EMPTY_LIST;
            }
            int firstResult = historicTaskInstanceQuery.getFirstResult();
            int maxResults = historicTaskInstanceQuery.getMaxResults();
            if (historicTaskInstanceQuery.getTaskVariablesLimit() != null) {
                historicTaskInstanceQuery.setMaxResults(historicTaskInstanceQuery.getTaskVariablesLimit());
            } else {
                historicTaskInstanceQuery.setMaxResults(Context.getProcessEngineConfiguration().getHistoricTaskQueryLimit());
            }
            historicTaskInstanceQuery.setFirstResult(0);
            List instanceList = this.getDbSqlSession().selectListWithRawParameterWithoutFilter("selectHistoricTaskInstancesWithVariablesByQueryCriteria", historicTaskInstanceQuery, historicTaskInstanceQuery.getFirstResult(), historicTaskInstanceQuery.getMaxResults());
            if (instanceList != null && !instanceList.isEmpty()) {
                if (firstResult > 0) {
                    if (firstResult <= instanceList.size()) {
                        int toIndex = firstResult + Math.min(maxResults, instanceList.size() - firstResult);
                        return instanceList.subList(firstResult, toIndex);
                    }
                    return Collections.EMPTY_LIST;
                }
                int toIndex = Math.min(maxResults, instanceList.size());
                return instanceList.subList(0, toIndex);
            }
        }
        return Collections.EMPTY_LIST;
    }

    public HistoricTaskInstanceEntity findHistoricTaskInstanceById(String taskId) {
        if (taskId == null) {
            throw new ActivitiIllegalArgumentException("Invalid historic task id : null");
        }
        if (this.getHistoryManager().isHistoryEnabled()) {
            return (HistoricTaskInstanceEntity)this.getDbSqlSession().selectOne("selectHistoricTaskInstance", taskId);
        }
        return null;
    }

    public List<HistoricTaskInstance> findHistoricTasksByParentTaskId(String parentTaskId) {
        return this.getDbSqlSession().selectList("selectHistoricTasksByParentTaskId", parentTaskId);
    }

    public void deleteHistoricTaskInstanceById(String taskId) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.getHistoryManager().isHistoryEnabled() && (historicTaskInstance = this.findHistoricTaskInstanceById(taskId)) != null) {
            CommandContext commandContext = Context.getCommandContext();
            List<HistoricTaskInstance> subTasks = this.findHistoricTasksByParentTaskId(taskId);
            for (HistoricTaskInstance subTask : subTasks) {
                this.deleteHistoricTaskInstanceById(subTask.getId());
            }
            commandContext.getHistoricDetailEntityManager().deleteHistoricDetailsByTaskId(taskId);
            commandContext.getHistoricVariableInstanceEntityManager().deleteHistoricVariableInstancesByTaskId(taskId);
            commandContext.getCommentEntityManager().deleteCommentsByTaskId(taskId);
            commandContext.getAttachmentEntityManager().deleteAttachmentsByTaskId(taskId);
            commandContext.getHistoricIdentityLinkEntityManager().deleteHistoricIdentityLinksByTaskId(taskId);
            this.getDbSqlSession().delete(historicTaskInstance);
        }
    }

    public List<HistoricTaskInstance> findHistoricTaskInstancesByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectHistoricTaskInstanceByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findHistoricTaskInstanceCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectHistoricTaskInstanceCountByNativeQuery", parameterMap);
    }
}

