/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.MapExceptionEntry;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.data.AbstractDataAssociation;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmProcessInstance;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.delegate.SubProcessActivityBehavior;

public class CallActivityBehavior
extends AbstractBpmnActivityBehavior
implements SubProcessActivityBehavior {
    protected String processDefinitonKey;
    private List<AbstractDataAssociation> dataInputAssociations = new ArrayList<AbstractDataAssociation>();
    private List<AbstractDataAssociation> dataOutputAssociations = new ArrayList<AbstractDataAssociation>();
    private Expression processDefinitionExpression;
    protected List<MapExceptionEntry> mapExceptions;
    protected boolean inheritVariables;

    public CallActivityBehavior(String processDefinitionKey, List<MapExceptionEntry> mapExceptions) {
        this.processDefinitonKey = processDefinitionKey;
        this.mapExceptions = mapExceptions;
    }

    public CallActivityBehavior(Expression processDefinitionExpression, List<MapExceptionEntry> mapExceptions) {
        this.processDefinitionExpression = processDefinitionExpression;
        this.mapExceptions = mapExceptions;
    }

    public void addDataInputAssociation(AbstractDataAssociation dataInputAssociation) {
        this.dataInputAssociations.add(dataInputAssociation);
    }

    public void addDataOutputAssociation(AbstractDataAssociation dataOutputAssociation) {
        this.dataOutputAssociations.add(dataOutputAssociation);
    }

    public void setInheritVariables(boolean inheritVariables) {
        this.inheritVariables = inheritVariables;
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        block7: {
            String processDefinitonKey = this.processDefinitonKey;
            if (this.processDefinitionExpression != null) {
                processDefinitonKey = (String)this.processDefinitionExpression.getValue(execution);
            }
            DeploymentManager deploymentManager = Context.getProcessEngineConfiguration().getDeploymentManager();
            ProcessDefinitionEntity processDefinition = null;
            processDefinition = execution.getTenantId() == null || "".equals(execution.getTenantId()) ? deploymentManager.findDeployedLatestProcessDefinitionByKey(processDefinitonKey) : deploymentManager.findDeployedLatestProcessDefinitionByKeyAndTenantId(processDefinitonKey, execution.getTenantId());
            if (deploymentManager.isProcessDefinitionSuspended(processDefinition.getId())) {
                throw new ActivitiException("Cannot start process instance. Process definition " + processDefinition.getName() + " (id = " + processDefinition.getId() + ") is suspended");
            }
            PvmProcessInstance subProcessInstance = execution.createSubProcessInstance(processDefinition);
            if (this.inheritVariables) {
                Map<String, Object> variables = execution.getVariables();
                for (Map.Entry<String, Object> entry : variables.entrySet()) {
                    subProcessInstance.setVariable(entry.getKey(), entry.getValue());
                }
            }
            for (AbstractDataAssociation dataInputAssociation : this.dataInputAssociations) {
                Object value = null;
                value = dataInputAssociation.getSourceExpression() != null ? dataInputAssociation.getSourceExpression().getValue(execution) : execution.getVariable(dataInputAssociation.getSource());
                subProcessInstance.setVariable(dataInputAssociation.getTarget(), value);
            }
            try {
                subProcessInstance.start();
            }
            catch (Exception e) {
                if (ErrorPropagation.mapException(e, execution, this.mapExceptions, true)) break block7;
                throw e;
            }
        }
    }

    public void setProcessDefinitonKey(String processDefinitonKey) {
        this.processDefinitonKey = processDefinitonKey;
    }

    public String getProcessDefinitonKey() {
        return this.processDefinitonKey;
    }

    @Override
    public void completing(DelegateExecution execution, DelegateExecution subProcessInstance) throws Exception {
        for (AbstractDataAssociation dataOutputAssociation : this.dataOutputAssociations) {
            Object value = null;
            value = dataOutputAssociation.getSourceExpression() != null ? dataOutputAssociation.getSourceExpression().getValue(subProcessInstance) : subProcessInstance.getVariable(dataOutputAssociation.getSource());
            execution.setVariable(dataOutputAssociation.getTarget(), value);
        }
    }

    @Override
    public void completed(ActivityExecution execution) throws Exception {
        this.leave(execution);
    }
}

