/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.agenda;

import java.util.List;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.HasExecutionListeners;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.impl.agenda.Agenda;
import org.activiti.engine.impl.bpmn.parser.factory.ListenerFactory;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;

public abstract class AbstractOperation
implements Runnable {
    protected CommandContext commandContext;
    protected Agenda agenda;
    protected ExecutionEntity execution;

    public AbstractOperation() {
    }

    public AbstractOperation(CommandContext commandContext, ExecutionEntity execution) {
        this.commandContext = commandContext;
        this.execution = execution;
        this.agenda = commandContext.getAgenda();
    }

    protected FlowElement findCurrentFlowElement(ExecutionEntity execution) {
        String processDefinitionId = execution.getProcessDefinitionId();
        Process process = ProcessDefinitionUtil.getProcess(processDefinitionId);
        String activityId = execution.getCurrentActivityId();
        FlowElement currentFlowElement = process.getFlowElement(activityId, true);
        execution.setCurrentFlowElement(currentFlowElement);
        return currentFlowElement;
    }

    protected void executeExecutionListeners(HasExecutionListeners elementWithExecutionListeners, String eventType) {
        this.executeExecutionListeners(elementWithExecutionListeners, null, eventType, false);
    }

    protected void executeExecutionListeners(HasExecutionListeners elementWithExecutionListeners, ExecutionEntity executionToUseForListener, String eventType, boolean ignoreType) {
        List listeners = elementWithExecutionListeners.getExecutionListeners();
        ListenerFactory listenerFactory = Context.getProcessEngineConfiguration().getListenerFactory();
        if (listeners != null) {
            for (ActivitiListener activitiListener : listeners) {
                ExecutionEntity executionToUse;
                if (!ignoreType && !eventType.equals(activitiListener.getEvent())) continue;
                ExecutionListener executionListener = null;
                if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equalsIgnoreCase(activitiListener.getImplementationType())) {
                    executionListener = listenerFactory.createClassDelegateExecutionListener(activitiListener);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equalsIgnoreCase(activitiListener.getImplementationType())) {
                    executionListener = listenerFactory.createExpressionExecutionListener(activitiListener);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equalsIgnoreCase(activitiListener.getImplementationType())) {
                    executionListener = listenerFactory.createDelegateExpressionExecutionListener(activitiListener);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_INSTANCE.equalsIgnoreCase(activitiListener.getImplementationType())) {
                    executionListener = (ExecutionListener)activitiListener.getInstance();
                }
                ExecutionEntity executionEntity = executionToUse = executionToUseForListener != null ? executionToUseForListener : this.execution;
                if (executionListener == null) continue;
                executionToUse.setEventName(eventType);
                executionListener.notify(executionToUse);
                executionToUse.setEventName(null);
            }
        }
    }

    public CommandContext getCommandContext() {
        return this.commandContext;
    }

    public void setCommandContext(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    public Agenda getAgenda() {
        return this.agenda;
    }

    public void setAgenda(Agenda agenda) {
        this.agenda = agenda;
    }

    public ExecutionEntity getExecution() {
        return this.execution;
    }

    public void setExecution(ExecutionEntity execution) {
        this.execution = execution;
    }
}

