/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.agenda;

import java.util.Collection;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.HasExecutionListeners;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.agenda.AbstractOperation;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.delegate.ActivityBehavior;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.logging.LogMDC;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinueMultiInstanceOperation
extends AbstractOperation {
    private static Logger logger = LoggerFactory.getLogger(ContinueMultiInstanceOperation.class);

    public ContinueMultiInstanceOperation(CommandContext commandContext, ExecutionEntity execution) {
        super(commandContext, execution);
    }

    @Override
    public void run() {
        FlowElement currentFlowElement = this.execution.getCurrentFlowElement();
        if (currentFlowElement == null) {
            currentFlowElement = this.findCurrentFlowElement(this.execution);
            this.execution.setCurrentFlowElement(currentFlowElement);
        }
        if (!(currentFlowElement instanceof FlowNode)) {
            throw new RuntimeException("Programmatic error: no valid multi instance flow node, type: " + currentFlowElement + ". Halting.");
        }
        this.continueThroughFlowNode((FlowNode)currentFlowElement);
    }

    protected void continueThroughFlowNode(FlowNode flowNode) {
        ActivityBehavior activityBehavior;
        if (CollectionUtils.isNotEmpty((Collection)flowNode.getExecutionListeners())) {
            this.executeExecutionListeners((HasExecutionListeners)flowNode, "start");
        }
        if ((activityBehavior = (ActivityBehavior)flowNode.getBehavior()) != null) {
            logger.debug("Executing activityBehavior {} on activity '{}' with execution {}", new Object[]{activityBehavior.getClass(), flowNode.getId(), this.execution.getId()});
            if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityEvent(ActivitiEventType.ACTIVITY_STARTED, flowNode.getId(), flowNode.getName(), this.execution.getId(), this.execution.getProcessInstanceId(), this.execution.getProcessDefinitionId(), (FlowElement)flowNode));
            }
            try {
                activityBehavior.execute(this.execution);
            }
            catch (BpmnError error) {
                ErrorPropagation.propagateError(error, (DelegateExecution)this.execution);
            }
            catch (RuntimeException e) {
                if (LogMDC.isMDCEnabled()) {
                    LogMDC.putMDCExecution(this.execution);
                }
                throw e;
            }
        } else {
            logger.debug("No activityBehavior on activity '{}' with execution {}", (Object)flowNode.getId(), (Object)this.execution.getId());
        }
    }
}

