/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.agenda;

import java.util.Collection;
import java.util.List;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.agenda.AbstractOperation;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.persistence.entity.JobEntityManager;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntityManager;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntityManager;

public class DestroyScopeOperation
extends AbstractOperation {
    public DestroyScopeOperation(CommandContext commandContext, ExecutionEntity execution) {
        super(commandContext, execution);
    }

    @Override
    public void run() {
        FlowElement currentFlowElement = this.execution.getCurrentFlowElement();
        ExecutionEntityManager executionEntityManager = this.commandContext.getExecutionEntityManager();
        ExecutionEntity executionEntity = this.execution;
        ExecutionEntity parentScopeExecution = null;
        if (this.execution.isScope()) {
            parentScopeExecution = executionEntity;
        } else {
            ExecutionEntity currentlyExaminedExecution = (ExecutionEntity)executionEntityManager.findById(this.execution.getParentId());
            while (currentlyExaminedExecution != null && parentScopeExecution == null) {
                if (currentlyExaminedExecution.isScope()) {
                    parentScopeExecution = currentlyExaminedExecution;
                    continue;
                }
                currentlyExaminedExecution = (ExecutionEntity)executionEntityManager.findById(currentlyExaminedExecution.getParentId());
            }
        }
        if (parentScopeExecution == null) {
            throw new ActivitiException("Programmatic error: no parent scope execution found for boundary event");
        }
        List<ExecutionEntity> childExecutions = executionEntityManager.findChildExecutionsByParentExecutionId(parentScopeExecution.getId());
        for (ExecutionEntity childExecution : childExecutions) {
            executionEntityManager.deleteExecutionAndRelatedData(childExecution, null, false);
        }
        TaskEntityManager taskEntityManager = this.commandContext.getTaskEntityManager();
        List<TaskEntity> tasksForExecution = taskEntityManager.findTasksByExecutionId(parentScopeExecution.getId());
        for (TaskEntity taskEntity : tasksForExecution) {
            taskEntityManager.delete(taskEntity);
        }
        JobEntityManager jobEntityManager = this.commandContext.getJobEntityManager();
        List<JobEntity> jobsForExecution = jobEntityManager.findJobsByExecutionId(parentScopeExecution.getId());
        for (JobEntity job : jobsForExecution) {
            jobEntityManager.delete(job);
        }
        VariableInstanceEntityManager variableInstanceEntityManager = this.commandContext.getVariableInstanceEntityManager();
        Collection<VariableInstanceEntity> variablesForExecution = variableInstanceEntityManager.findVariableInstancesByExecutionId(parentScopeExecution.getId());
        for (VariableInstanceEntity variable : variablesForExecution) {
            variableInstanceEntityManager.delete(variable);
        }
        parentScopeExecution.setScope(false);
        parentScopeExecution.setCurrentFlowElement(currentFlowElement);
    }
}

