/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.agenda;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CompensateEventDefinition;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.HasExecutionListeners;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.Transaction;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.agenda.AbstractOperation;
import org.activiti.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.ScopeUtil;
import org.activiti.engine.impl.delegate.SubProcessActivityBehavior;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndExecutionOperation
extends AbstractOperation {
    private static final Logger logger = LoggerFactory.getLogger(EndExecutionOperation.class);

    public EndExecutionOperation(CommandContext commandContext, ExecutionEntity execution) {
        super(commandContext, execution);
    }

    @Override
    public void run() {
        ExecutionEntityManager executionEntityManager = this.commandContext.getExecutionEntityManager();
        ExecutionEntity executionEntity = this.execution;
        ExecutionEntity parentExecution = null;
        if (executionEntity.getParentId() != null) {
            parentExecution = (ExecutionEntity)executionEntityManager.findById(executionEntity.getParentId());
        }
        if (parentExecution != null) {
            if (executionEntity.isScope()) {
                executionEntityManager.deleteChildExecutions(executionEntity, null, false);
            }
            logger.debug("Ending execution {}", (Object)this.execution.getId());
            executionEntityManager.deleteExecutionAndRelatedData(executionEntity, null, false);
            logger.debug("Parent execution found. Continuing process using execution {}", (Object)parentExecution.getId());
            SubProcess subProcess = null;
            if (executionEntity.getCurrentFlowElement() instanceof EndEvent) {
                EndEvent endEvent = (EndEvent)executionEntity.getCurrentFlowElement();
                subProcess = endEvent.getSubProcess();
                if (!parentExecution.getId().equals(parentExecution.getProcessInstanceId()) && subProcess != null && subProcess.getLoopCharacteristics() != null && subProcess.getBehavior() instanceof MultiInstanceActivityBehavior) {
                    List<ExecutionEntity> activeChildExecutions = this.getActiveChildExecutionsForExecution(executionEntityManager, parentExecution.getId());
                    boolean containsOtherChildExecutions = false;
                    for (ExecutionEntity activeExecution : activeChildExecutions) {
                        if (activeExecution.getId().equals(executionEntity.getId())) continue;
                        containsOtherChildExecutions = true;
                    }
                    if (!containsOtherChildExecutions) {
                        MultiInstanceActivityBehavior multiInstanceBehavior = (MultiInstanceActivityBehavior)subProcess.getBehavior();
                        parentExecution.setCurrentFlowElement((FlowElement)subProcess);
                        multiInstanceBehavior.leave(parentExecution);
                    }
                    return;
                }
            }
            if (this.getNumberOfActiveChildExecutionsForExecution(executionEntityManager, parentExecution.getId()) == 0 || this.isAllEventScopeExecutions(executionEntityManager, parentExecution)) {
                if (subProcess != null) {
                    parentExecution.setCurrentFlowElement((FlowElement)subProcess);
                    boolean hasCompensation = false;
                    if (subProcess instanceof Transaction) {
                        hasCompensation = true;
                    } else {
                        block7: for (FlowElement subElement : subProcess.getFlowElements()) {
                            Activity subActivity;
                            if (!(subElement instanceof Activity) || !CollectionUtils.isNotEmpty((Collection)(subActivity = (Activity)subElement).getBoundaryEvents())) continue;
                            for (BoundaryEvent boundaryEvent : subActivity.getBoundaryEvents()) {
                                if (!CollectionUtils.isNotEmpty((Collection)boundaryEvent.getEventDefinitions()) || !(boundaryEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition)) continue;
                                hasCompensation = true;
                                continue block7;
                            }
                        }
                    }
                    if (hasCompensation) {
                        ScopeUtil.createCopyOfSubProcessExecutionForCompensation(parentExecution, parentExecution.getParent());
                    }
                } else {
                    Activity activity;
                    if (executionEntity.getCurrentFlowElement() instanceof Activity && (activity = (Activity)executionEntity.getCurrentFlowElement()).isForCompensation()) {
                        return;
                    }
                    if (!(parentExecution.getCurrentFlowElement() instanceof SubProcess)) {
                        parentExecution.setCurrentFlowElement(executionEntity.getCurrentFlowElement());
                    }
                }
                this.agenda.planTakeOutgoingSequenceFlowsOperation(parentExecution, true);
            }
        } else {
            int activeExecutions;
            String processInstanceId = executionEntity.getId();
            logger.debug("No parent execution found. Verifying if process instance {} can be stopped.", (Object)processInstanceId);
            ExecutionEntity superExecution = executionEntity.getSuperExecution();
            SubProcessActivityBehavior subProcessActivityBehavior = null;
            if (superExecution != null) {
                FlowNode superExecutionElement = (FlowNode)superExecution.getCurrentFlowElement();
                subProcessActivityBehavior = (SubProcessActivityBehavior)superExecutionElement.getBehavior();
                try {
                    subProcessActivityBehavior.completing(superExecution, executionEntity);
                }
                catch (RuntimeException e) {
                    logger.error("Error while completing sub process of execution {}", (Object)executionEntity, (Object)e);
                    throw e;
                }
                catch (Exception e) {
                    logger.error("Error while completing sub process of execution {}", (Object)executionEntity, (Object)e);
                    throw new ActivitiException("Error while completing sub process of execution " + executionEntity, e);
                }
            }
            if ((activeExecutions = this.getNumberOfActiveChildExecutionsForProcessInstance(executionEntityManager, processInstanceId)) == 0) {
                logger.debug("No active executions found. Ending process instance {} ", (Object)processInstanceId);
                executionEntityManager.deleteProcessInstanceExecutionEntity(processInstanceId, this.execution.getCurrentFlowElement() != null ? this.execution.getCurrentFlowElement().getId() : null, "FINISHED", false, false, true);
            } else {
                logger.debug("Active executions found. Process instance {} will not be ended.", (Object)processInstanceId);
            }
            Process process = this.getProcess(executionEntity.getProcessDefinitionId());
            if (CollectionUtils.isNotEmpty((Collection)process.getExecutionListeners())) {
                this.executeExecutionListeners((HasExecutionListeners)process, executionEntity, "end", false);
            }
            if (superExecution != null) {
                superExecution.setSubProcessInstance(null);
                try {
                    subProcessActivityBehavior.completed(superExecution);
                }
                catch (RuntimeException e) {
                    logger.error("Error while completing sub process of execution {}", (Object)executionEntity, (Object)e);
                    throw e;
                }
                catch (Exception e) {
                    logger.error("Error while completing sub process of execution {}", (Object)executionEntity, (Object)e);
                    throw new ActivitiException("Error while completing sub process of execution " + executionEntity, e);
                }
            }
        }
    }

    protected int getNumberOfActiveChildExecutionsForProcessInstance(ExecutionEntityManager executionEntityManager, String processInstanceId) {
        List<ExecutionEntity> executions = executionEntityManager.findChildExecutionsByProcessInstanceId(processInstanceId);
        int activeExecutions = 0;
        for (ExecutionEntity execution : executions) {
            if (!execution.isActive() || processInstanceId.equals(execution.getId())) continue;
            ++activeExecutions;
        }
        return activeExecutions;
    }

    protected int getNumberOfActiveChildExecutionsForExecution(ExecutionEntityManager executionEntityManager, String executionId) {
        List<ExecutionEntity> executions = executionEntityManager.findChildExecutionsByParentExecutionId(executionId);
        int activeExecutions = 0;
        for (ExecutionEntity activeExecution : executions) {
            if (activeExecution.getCurrentFlowElement() instanceof BoundaryEvent) continue;
            ++activeExecutions;
        }
        return activeExecutions;
    }

    protected List<ExecutionEntity> getActiveChildExecutionsForExecution(ExecutionEntityManager executionEntityManager, String executionId) {
        ArrayList<ExecutionEntity> activeChildExecutions = new ArrayList<ExecutionEntity>();
        List<ExecutionEntity> executions = executionEntityManager.findChildExecutionsByParentExecutionId(executionId);
        for (ExecutionEntity activeExecution : executions) {
            if (activeExecution.getCurrentFlowElement() instanceof BoundaryEvent) continue;
            activeChildExecutions.add(activeExecution);
        }
        return activeChildExecutions;
    }

    protected boolean isAllEventScopeExecutions(ExecutionEntityManager executionEntityManager, ExecutionEntity parentExecution) {
        boolean allEventScopeExecutions = true;
        List<ExecutionEntity> executions = executionEntityManager.findChildExecutionsByParentExecutionId(parentExecution.getId());
        for (ExecutionEntity childExecution : executions) {
            if (childExecution.isEventScope()) {
                executionEntityManager.deleteExecutionAndRelatedData(childExecution, null, false);
                continue;
            }
            allEventScopeExecutions = false;
            break;
        }
        return allEventScopeExecutions;
    }

    protected Process getProcess(String processDefinitionId) {
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId);
        return bpmnModel.getMainProcess();
    }
}

