/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.agenda;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.CancelEventDefinition;
import org.activiti.bpmn.model.EventSubProcess;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.HasExecutionListeners;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.agenda.AbstractOperation;
import org.activiti.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.util.condition.ConditionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TakeOutgoingSequenceFlowsOperation
extends AbstractOperation {
    private static final Logger logger = LoggerFactory.getLogger(TakeOutgoingSequenceFlowsOperation.class);
    protected boolean evaluateConditions;

    public TakeOutgoingSequenceFlowsOperation(CommandContext commandContext, ExecutionEntity activityExecution, boolean evaluateConditions) {
        super(commandContext, activityExecution);
        this.evaluateConditions = evaluateConditions;
    }

    @Override
    public void run() {
        Activity activity;
        FlowElement currentFlowElement = this.execution.getCurrentFlowElement();
        if (currentFlowElement == null) {
            currentFlowElement = this.findCurrentFlowElement(this.execution);
            this.execution.setCurrentFlowElement(currentFlowElement);
        }
        if (this.execution.getParentId() != null && this.execution.isScope()) {
            this.agenda.planDestroyScopeOperation(this.execution);
        } else if (currentFlowElement instanceof Activity && CollectionUtils.isNotEmpty((Collection)(activity = (Activity)currentFlowElement).getBoundaryEvents())) {
            ArrayList<String> notToDeleteEvents = new ArrayList<String>();
            for (BoundaryEvent event : activity.getBoundaryEvents()) {
                if (!CollectionUtils.isNotEmpty((Collection)event.getEventDefinitions()) || !(event.getEventDefinitions().get(0) instanceof CancelEventDefinition)) continue;
                notToDeleteEvents.add(event.getId());
            }
            List<ExecutionEntity> childExecutions = this.commandContext.getExecutionEntityManager().findChildExecutionsByParentExecutionId(this.execution.getId());
            for (ExecutionEntity childExecution : childExecutions) {
                if (childExecution.getCurrentFlowElement() != null && notToDeleteEvents.contains(childExecution.getCurrentFlowElement().getId())) continue;
                this.commandContext.getExecutionEntityManager().deleteExecutionAndRelatedData(childExecution, null, false);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)currentFlowElement.getExecutionListeners()) && !this.execution.isProcessInstanceType()) {
            this.executeExecutionListeners((HasExecutionListeners)currentFlowElement, "end");
        }
        if (currentFlowElement instanceof FlowNode) {
            FlowNode flowNode = (FlowNode)currentFlowElement;
            if (!this.execution.getId().equals(this.execution.getProcessInstanceId())) {
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityEvent(ActivitiEventType.ACTIVITY_COMPLETED, flowNode.getId(), flowNode.getName(), this.execution.getId(), this.execution.getProcessInstanceId(), this.execution.getProcessDefinitionId(), (FlowElement)flowNode));
            }
            this.leaveFlowNode(flowNode);
        } else if (currentFlowElement instanceof SequenceFlow) {
            this.agenda.planContinueProcessOperation(this.execution);
        }
    }

    protected void leaveFlowNode(FlowNode flowNode) {
        ExecutionEntityManager executionEntityManager;
        logger.debug("Leaving flow node {} with id '{}' by following it's {} outgoing sequenceflow", new Object[]{flowNode.getClass(), flowNode.getId(), flowNode.getOutgoingFlows().size()});
        String defaultSequenceFlowId = null;
        if (flowNode instanceof Activity) {
            defaultSequenceFlowId = ((Activity)flowNode).getDefaultFlow();
        } else if (flowNode instanceof Gateway) {
            defaultSequenceFlowId = ((Gateway)flowNode).getDefaultFlow();
        }
        ArrayList<SequenceFlow> outgoingSequenceFlow = new ArrayList<SequenceFlow>();
        for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
            String skipExpressionString = sequenceFlow.getSkipExpression();
            if (!SkipExpressionUtil.isSkipExpressionEnabled((DelegateExecution)this.execution, skipExpressionString)) {
                if (this.evaluateConditions && (!this.evaluateConditions || !ConditionUtil.hasTrueCondition(sequenceFlow, this.execution) || defaultSequenceFlowId != null && defaultSequenceFlowId.equals(sequenceFlow.getId()))) continue;
                outgoingSequenceFlow.add(sequenceFlow);
                continue;
            }
            if (flowNode.getOutgoingFlows().size() != 1 && !SkipExpressionUtil.shouldSkipFlowElement(this.commandContext, this.execution, skipExpressionString)) continue;
            outgoingSequenceFlow.add(sequenceFlow);
        }
        if (outgoingSequenceFlow.size() == 0 && this.evaluateConditions && defaultSequenceFlowId != null) {
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                if (!defaultSequenceFlowId.equals(sequenceFlow.getId())) continue;
                outgoingSequenceFlow.add(sequenceFlow);
                break;
            }
        }
        if (outgoingSequenceFlow.size() == 0) {
            if (flowNode.getOutgoingFlows() == null || flowNode.getOutgoingFlows().size() == 0) {
                logger.info("No outgoing sequence flow found for flow node '{}'.", (Object)flowNode.getId());
                if (flowNode.getSubProcess() != null && flowNode.getSubProcess() instanceof EventSubProcess) {
                    executionEntityManager = this.commandContext.getExecutionEntityManager();
                    executionEntityManager.deleteChildExecutions(this.execution, null, false);
                    executionEntityManager.deleteExecutionAndRelatedData(this.execution, null, false);
                    if (flowNode.getSubProcess().getSubProcess() != null) {
                        executionEntityManager.deleteChildExecutions(this.execution.getParent(), null, false);
                        executionEntityManager.deleteExecutionAndRelatedData(this.execution.getParent(), null, false);
                        ExecutionEntity parentExecution = this.execution.getParent().getParent();
                        parentExecution.setCurrentFlowElement((FlowElement)flowNode.getSubProcess().getSubProcess());
                        this.agenda.planTakeOutgoingSequenceFlowsOperation(parentExecution);
                    } else {
                        executionEntityManager.deleteChildExecutions(this.execution.getParent(), null, false);
                        this.agenda.planEndExecutionOperation(this.execution.getParent());
                    }
                } else {
                    this.agenda.planEndExecutionOperation(this.execution);
                }
                return;
            }
            throw new ActivitiException("No outgoing sequence flow of element '" + flowNode.getId() + "' could be selected for continuing the process");
        }
        executionEntityManager = this.commandContext.getExecutionEntityManager();
        ArrayList<ExecutionEntity> outgoingExecutions = new ArrayList<ExecutionEntity>(flowNode.getOutgoingFlows().size());
        SequenceFlow sequenceFlow = (SequenceFlow)outgoingSequenceFlow.get(0);
        this.execution.setCurrentFlowElement((FlowElement)sequenceFlow);
        this.execution.setActive(true);
        outgoingExecutions.add(this.execution);
        if (outgoingSequenceFlow.size() > 1) {
            for (int i = 1; i < outgoingSequenceFlow.size(); ++i) {
                ExecutionEntity outgoingExecutionEntity = new ExecutionEntity();
                outgoingExecutionEntity.setProcessDefinitionId(this.execution.getProcessDefinitionId());
                outgoingExecutionEntity.setProcessInstanceId(this.execution.getProcessInstanceId());
                outgoingExecutionEntity.setRootProcessInstanceId(this.execution.getRootProcessInstanceId());
                outgoingExecutionEntity.setTenantId(this.execution.getTenantId());
                outgoingExecutionEntity.setScope(false);
                outgoingExecutionEntity.setActive(true);
                outgoingExecutionEntity.setParentId(this.execution.getParentId() != null ? this.execution.getParentId() : this.execution.getId());
                sequenceFlow = (SequenceFlow)outgoingSequenceFlow.get(i);
                outgoingExecutionEntity.setCurrentFlowElement((FlowElement)sequenceFlow);
                executionEntityManager.insert(outgoingExecutionEntity);
                outgoingExecutions.add(outgoingExecutionEntity);
            }
        }
        for (ExecutionEntity outgoingExecution : outgoingExecutions) {
            this.agenda.planContinueProcessOperation(outgoingExecution);
        }
    }
}

