/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.List;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.behavior.IntermediateCatchEventActivityBehavior;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntityManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.MessageEventSubscriptionEntity;

public class IntermediateCatchMessageEventActivityBehavior
extends IntermediateCatchEventActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected MessageEventDefinition messageEventDefinition;

    public IntermediateCatchMessageEventActivityBehavior(MessageEventDefinition messageEventDefinition) {
        this.messageEventDefinition = messageEventDefinition;
    }

    @Override
    public void execute(DelegateExecution execution) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        Context.getCommandContext().getEventSubscriptionEntityManager().insertMessageEvent(this.messageEventDefinition, executionEntity);
    }

    @Override
    public void trigger(DelegateExecution execution, String triggerName, Object triggerData) {
        ExecutionEntity executionEntity = this.deleteMessageEventSubScription(execution);
        this.leaveIntermediateCatchEvent(executionEntity);
    }

    @Override
    public void cancelEvent(DelegateExecution execution) {
        this.deleteMessageEventSubScription(execution);
        Context.getCommandContext().getExecutionEntityManager().deleteExecutionAndRelatedData((ExecutionEntity)execution, null, false);
    }

    protected ExecutionEntity deleteMessageEventSubScription(DelegateExecution execution) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        EventSubscriptionEntityManager eventSubscriptionEntityManager = Context.getCommandContext().getEventSubscriptionEntityManager();
        List<EventSubscriptionEntity> eventSubscriptions = executionEntity.getEventSubscriptions();
        for (EventSubscriptionEntity eventSubscription : eventSubscriptions) {
            if (!(eventSubscription instanceof MessageEventSubscriptionEntity) || !eventSubscription.getEventName().equals(this.messageEventDefinition.getMessageRef())) continue;
            eventSubscriptionEntityManager.delete(eventSubscription);
        }
        return executionEntity;
    }
}

