/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.List;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.behavior.IntermediateCatchEventActivityBehavior;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.jobexecutor.TimerEventHandler;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.persistence.entity.JobEntityManager;
import org.activiti.engine.impl.persistence.entity.TimerEntity;
import org.activiti.engine.impl.util.TimerUtil;

public class IntermediateCatchTimerEventActivityBehavior
extends IntermediateCatchEventActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected TimerEventDefinition timerEventDefinition;

    public IntermediateCatchTimerEventActivityBehavior(TimerEventDefinition timerEventDefinition) {
        this.timerEventDefinition = timerEventDefinition;
    }

    @Override
    public void execute(DelegateExecution execution) {
        TimerEntity timer = TimerUtil.createTimerEntityForTimerEventDefinition(this.timerEventDefinition, false, (ExecutionEntity)execution, "trigger-timer", TimerEventHandler.createConfiguration(execution.getCurrentActivityId(), this.timerEventDefinition.getEndDate()));
        if (timer != null) {
            Context.getCommandContext().getJobEntityManager().schedule(timer);
        }
    }

    @Override
    public void cancelEvent(DelegateExecution execution) {
        JobEntityManager jobEntityManager = Context.getCommandContext().getJobEntityManager();
        List<JobEntity> jobEntities = jobEntityManager.findJobsByExecutionId(execution.getId());
        for (JobEntity jobEntity : jobEntities) {
            jobEntityManager.delete(jobEntity);
        }
        Context.getCommandContext().getExecutionEntityManager().deleteExecutionAndRelatedData((ExecutionEntity)execution, null, false);
    }

    @Override
    public void trigger(DelegateExecution execution, String triggerName, Object triggerData) {
        this.leaveIntermediateCatchEvent(execution);
    }
}

