/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.List;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.CompensateEventDefinition;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ThrowEvent;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.ScopeUtil;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntityManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;

public class IntermediateThrowCompensationEventActivityBehavior
extends FlowNodeActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected final CompensateEventDefinition compensateEventDefinition;

    public IntermediateThrowCompensationEventActivityBehavior(CompensateEventDefinition compensateEventDefinition) {
        this.compensateEventDefinition = compensateEventDefinition;
    }

    @Override
    public void execute(DelegateExecution execution) {
        ThrowEvent throwEvent = (ThrowEvent)execution.getCurrentFlowElement();
        String activityRef = this.compensateEventDefinition.getActivityRef();
        EventSubscriptionEntityManager eventSubscriptionEntityManager = Context.getCommandContext().getEventSubscriptionEntityManager();
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        ArrayList<CompensateEventSubscriptionEntity> eventSubscriptions = new ArrayList<CompensateEventSubscriptionEntity>();
        ExecutionEntity subProcessExecution = null;
        ArrayList<String> rootCompensationActivities = new ArrayList<String>();
        if (throwEvent.getSubProcess() == null) {
            Process process = ProcessDefinitionUtil.getProcess(execution.getProcessDefinitionId());
            for (FlowElement flowElement : process.getFlowElements()) {
                Activity activity;
                if (!(flowElement instanceof Activity) || !(activity = (Activity)flowElement).isForCompensation()) continue;
                rootCompensationActivities.add(activity.getId());
            }
        }
        List<ExecutionEntity> processInstanceExecutions = executionEntityManager.findChildExecutionsByProcessInstanceId(execution.getProcessInstanceId());
        for (ExecutionEntity childExecution : processInstanceExecutions) {
            if (childExecution.getCurrentFlowElement() == null || !childExecution.getCurrentFlowElement().getId().equals(activityRef)) continue;
            subProcessExecution = childExecution;
            break;
        }
        if (rootCompensationActivities.isEmpty() && subProcessExecution == null) {
            throw new ActivitiException("No compensation activities found intermediate throw event");
        }
        for (String compensationActivity : rootCompensationActivities) {
            eventSubscriptions.addAll(eventSubscriptionEntityManager.findCompensateEventSubscriptionsByProcessInstanceIdAndActivityId(execution.getProcessInstanceId(), compensationActivity));
        }
        if (subProcessExecution != null) {
            eventSubscriptions.addAll(eventSubscriptionEntityManager.findCompensateEventSubscriptionsByExecutionId(subProcessExecution.getParentId()));
        }
        if (eventSubscriptions.isEmpty()) {
            this.leave(execution);
        } else {
            ScopeUtil.throwCompensationEvent(eventSubscriptions, execution, false);
            if (subProcessExecution != null) {
                executionEntityManager.deleteExecutionAndRelatedData(subProcessExecution, null, false);
            }
            this.leave(execution);
        }
    }
}

