/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.List;
import org.activiti.bpmn.model.Signal;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.ThrowEvent;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntityManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.SignalEventSubscriptionEntity;

public class IntermediateThrowSignalEventActivityBehavior
extends AbstractBpmnActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected final SignalEventDefinition signalEventDefinition;
    protected String signalEventName;
    protected boolean processInstanceScope;

    public IntermediateThrowSignalEventActivityBehavior(ThrowEvent throwEvent, SignalEventDefinition signalEventDefinition, Signal signal) {
        if (signal != null) {
            this.signalEventName = signal.getName();
            if ("processInstance".equals(signal.getScope())) {
                this.processInstanceScope = true;
            }
        } else {
            this.signalEventName = signalEventDefinition.getSignalRef();
        }
        this.signalEventDefinition = signalEventDefinition;
    }

    @Override
    public void execute(DelegateExecution execution) {
        CommandContext commandContext = Context.getCommandContext();
        EventSubscriptionEntityManager eventSubscriptionEntityManager = commandContext.getEventSubscriptionEntityManager();
        List<SignalEventSubscriptionEntity> subscriptionEntities = null;
        subscriptionEntities = this.processInstanceScope ? eventSubscriptionEntityManager.findSignalEventSubscriptionsByProcessInstanceAndEventName(execution.getProcessInstanceId(), this.signalEventName) : eventSubscriptionEntityManager.findSignalEventSubscriptionsByEventName(this.signalEventName, execution.getTenantId());
        for (SignalEventSubscriptionEntity signalEventSubscriptionEntity : subscriptionEntities) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createSignalEvent(ActivitiEventType.ACTIVITY_SIGNALED, signalEventSubscriptionEntity.getActivityId(), this.signalEventName, null, signalEventSubscriptionEntity.getExecutionId(), signalEventSubscriptionEntity.getProcessInstanceId(), signalEventSubscriptionEntity.getProcessDefinitionId()));
            eventSubscriptionEntityManager.eventReceived(signalEventSubscriptionEntity, null, this.signalEventDefinition.isAsync());
        }
        commandContext.getAgenda().planTakeOutgoingSequenceFlowsOperation((ExecutionEntity)execution);
    }
}

